/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.TestDatanodeBlockScanner;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.junit.Assert;
import org.junit.Test;

public class TestMissingBlocksAlert {
    private static final Log LOG = LogFactory.getLog(TestMissingBlocksAlert.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingBlocksAlert() throws IOException, InterruptedException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setInt("dfs.namenode.replication.interval", 0);
            int fileLen = 10240;
            conf.setInt("dfs.blocksize", fileLen / 2);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).buildHDFS();
            ((MiniHDFSCluster)cluster).waitActive();
            BlockManager bm = ((MiniHDFSCluster)cluster).getNamesystem().getBlockManager();
            DistributedFileSystem dfs = ((MiniHDFSCluster)cluster).getFileSystem();
            DFSTestUtil.createFile((FileSystem)dfs, new Path("/testMissingBlocksAlert/file1"), fileLen, (short)3, 0L);
            Path corruptFile = new Path("/testMissingBlocks/corruptFile");
            DFSTestUtil.createFile((FileSystem)dfs, corruptFile, fileLen, (short)3, 0L);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)dfs, corruptFile);
            Assert.assertTrue((boolean)TestDatanodeBlockScanner.corruptReplica(block, 0));
            FSDataInputStream in = dfs.open(corruptFile);
            try {
                in.readFully(new byte[fileLen]);
            }
            catch (ChecksumException ignored) {
                // empty catch block
            }
            in.close();
            LOG.info((Object)"Waiting for missing blocks count to increase...");
            while (dfs.getMissingBlocksCount() <= 0L) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((dfs.getMissingBlocksCount() == 1L ? 1 : 0) != 0);
            Assert.assertEquals((long)4L, (long)dfs.getUnderReplicatedBlocksCount());
            Assert.assertEquals((long)3L, (long)bm.getUnderReplicatedNotMissingBlocks());
            URL url = new URL("http://" + conf.get("dfs.namenode.http-address") + "/dfshealth.jsp");
            String dfsFrontPage = DFSTestUtil.urlGet(url);
            String warnStr = "WARNING : There are ";
            Assert.assertTrue((String)"HDFS Front page does not contain expected warning", (boolean)dfsFrontPage.contains(warnStr + "1 missing blocks"));
            dfs.delete(corruptFile, true);
            LOG.info((Object)"Waiting for missing blocks count to be zero...");
            while (dfs.getMissingBlocksCount() > 0L) {
                Thread.sleep(100L);
            }
            Assert.assertEquals((long)2L, (long)dfs.getUnderReplicatedBlocksCount());
            Assert.assertEquals((long)2L, (long)bm.getUnderReplicatedNotMissingBlocks());
            dfsFrontPage = DFSTestUtil.urlGet(url);
            Assert.assertFalse((String)"HDFS Front page contains unexpected warning", (boolean)dfsFrontPage.contains(warnStr));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

