/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestTrash;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHDFSTrash {
    private static MiniDFSCluster cluster = null;

    @BeforeClass
    public static void setUp() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
    }

    @AfterClass
    public static void tearDown() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testTrash() throws IOException {
        TestTrash.trashShell((FileSystem)cluster.getFileSystem(), (Path)new Path("/"));
    }

    @Test
    public void testNonDefaultFS() throws IOException {
        FileSystem fs = cluster.getFileSystem();
        Configuration conf = fs.getConf();
        conf.set("fs.defaultFS", fs.getUri().toString());
        TestTrash.trashNonDefaultFS((Configuration)conf);
    }
}

