/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.util.ConcurrentModificationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.TestFileCreation;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.junit.Assert;
import org.junit.Test;

public class TestFileCreationEmpty {
    private boolean isConcurrentModificationException = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaseExpireEmptyFiles() throws Exception {
        Thread.UncaughtExceptionHandler oldUEH = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (e instanceof ConcurrentModificationException) {
                    LeaseManager.LOG.error((Object)("t=" + t), e);
                    TestFileCreationEmpty.this.isConcurrentModificationException = true;
                }
            }
        });
        System.out.println("testLeaseExpireEmptyFiles start");
        long leasePeriod = 1000L;
        int DATANODE_NUM = 3;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.heartbeat.interval", 1);
        MiniHDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).buildHDFS();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            TestFileCreation.createFile((FileSystem)dfs, new Path("/foo"), 3);
            TestFileCreation.createFile((FileSystem)dfs, new Path("/foo2"), 3);
            TestFileCreation.createFile((FileSystem)dfs, new Path("/foo3"), 3);
            cluster.setLeasePeriod(1000L, 1000L);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Assert.assertFalse((boolean)this.isConcurrentModificationException);
        }
        finally {
            Thread.setDefaultUncaughtExceptionHandler(oldUEH);
            cluster.shutdown();
        }
    }
}

