/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestFSInputChecker {
    static final long seed = 3735928559L;
    static final int BYTES_PER_SUM = 65536;
    static final int BLOCK_SIZE = 131072;
    static final int HALF_CHUNK_SIZE = 32768;
    static final int FILE_SIZE = 262143;
    static final short NUM_OF_DATANODES = 2;
    byte[] expected = new byte[262143];
    byte[] actual;
    FSDataInputStream stm;
    Random rand = new Random(3735928559L);

    private void writeFile(FileSystem fileSys, Path name) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, new FsPermission(511), true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)2, 131072L, null);
        stm.write(this.expected);
        stm.close();
    }

    private void checkAndEraseData(byte[] actual, int from, byte[] expected, String message) throws Exception {
        for (int idx = 0; idx < actual.length; ++idx) {
            Assert.assertEquals((String)(message + " byte " + (from + idx) + " differs. expected " + expected[from + idx] + " actual " + actual[idx]), (long)actual[idx], (long)expected[from + idx]);
            actual[idx] = 0;
        }
    }

    private void checkReadAndGetPos() throws Exception {
        int offset;
        this.actual = new byte[262143];
        this.stm.seek(0L);
        for (offset = 0; offset < 196608; offset += 65536) {
            Assert.assertEquals((long)this.stm.getPos(), (long)offset);
            this.stm.readFully(this.actual, offset, 65536);
        }
        this.stm.readFully(this.actual, offset, 65535);
        Assert.assertEquals((long)this.stm.getPos(), (long)262143L);
        this.checkAndEraseData(this.actual, 0, this.expected, "Read Sanity Test");
        this.stm.seek(0L);
        Assert.assertEquals((long)this.stm.getPos(), (long)0L);
        this.stm.readFully(this.actual, 0, 32768);
        Assert.assertEquals((long)this.stm.getPos(), (long)32768L);
        this.stm.readFully(this.actual, 32768, 98304);
        Assert.assertEquals((long)this.stm.getPos(), (long)131072L);
        this.stm.readFully(this.actual, 131072, 98304);
        Assert.assertEquals((long)this.stm.getPos(), (long)229376L);
        this.stm.readFully(this.actual, 229376, Short.MAX_VALUE);
        Assert.assertEquals((long)this.stm.getPos(), (long)262143L);
        this.checkAndEraseData(this.actual, 0, this.expected, "Read Sanity Test");
        this.stm.seek(0L);
        this.stm.readFully(this.actual, 0, 98304);
        Assert.assertEquals((long)this.stm.getPos(), (long)98304L);
        this.stm.readFully(this.actual, 98304, 65536);
        Assert.assertEquals((long)this.stm.getPos(), (long)163840L);
        this.stm.readFully(this.actual, 163840, 98303);
        Assert.assertEquals((long)this.stm.getPos(), (long)262143L);
        this.checkAndEraseData(this.actual, 0, this.expected, "Read Sanity Test");
    }

    private void testSeek1(int offset) throws Exception {
        this.stm.seek((long)offset);
        Assert.assertEquals((long)offset, (long)this.stm.getPos());
        this.stm.readFully(this.actual);
        this.checkAndEraseData(this.actual, offset, this.expected, "Read Sanity Test");
    }

    private void checkSeek() throws Exception {
        this.actual = new byte[32768];
        this.testSeek1(0);
        this.testSeek1(65536);
        this.testSeek1(131072);
        this.testSeek1(163840);
        this.testSeek1(32768);
        this.testSeek1(16384);
        this.testSeek1(49152);
        this.actual = new byte[1];
        this.testSeek1(262142);
        String errMsg = null;
        try {
            this.stm.seek(262143L);
        }
        catch (IOException e) {
            errMsg = e.getMessage();
        }
        Assert.assertTrue((errMsg == null ? 1 : 0) != 0);
    }

    private void testSkip1(int skippedBytes) throws Exception {
        long oldPos = this.stm.getPos();
        IOUtils.skipFully((InputStream)this.stm, (long)skippedBytes);
        long newPos = oldPos + (long)skippedBytes;
        Assert.assertEquals((long)this.stm.getPos(), (long)newPos);
        this.stm.readFully(this.actual);
        this.checkAndEraseData(this.actual, (int)newPos, this.expected, "Read Sanity Test");
    }

    private void checkSkip() throws Exception {
        this.actual = new byte[32768];
        this.stm.seek(0L);
        this.testSkip1(65536);
        this.testSkip1(32768);
        this.testSkip1(32768);
        this.stm.seek(0L);
        this.testSkip1(32769);
        this.testSkip1(65536);
        this.testSkip1(32768);
        this.stm.seek(0L);
        this.testSkip1(1);
        this.testSkip1(1);
        this.stm.seek(0L);
        this.actual = new byte[1];
        this.testSkip1(262142);
        this.stm.seek(0L);
        IOUtils.skipFully((InputStream)this.stm, (long)262143L);
        try {
            IOUtils.skipFully((InputStream)this.stm, (long)10L);
            Assert.fail((String)"expected to get a PrematureEOFException");
        }
        catch (EOFException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Premature EOF from inputStream after skipping 0 byte(s).");
        }
        this.stm.seek(0L);
        try {
            IOUtils.skipFully((InputStream)this.stm, (long)262153L);
            Assert.fail((String)"expected to get a PrematureEOFException");
        }
        catch (EOFException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Premature EOF from inputStream after skipping 262143 byte(s).");
        }
        this.stm.seek(10L);
        try {
            IOUtils.skipFully((InputStream)this.stm, (long)262143L);
            Assert.fail((String)"expected to get a PrematureEOFException");
        }
        catch (EOFException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Premature EOF from inputStream after skipping 262133 byte(s).");
        }
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assert.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        Assert.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testChecker(FileSystem fileSys, boolean readCS) throws Exception {
        Path file = new Path("try.dat");
        this.writeFile(fileSys, file);
        try {
            if (!readCS) {
                fileSys.setVerifyChecksum(false);
            }
            this.stm = fileSys.open(file);
            this.checkReadAndGetPos();
            this.checkSeek();
            this.checkSkip();
            Assert.assertFalse((boolean)this.stm.markSupported());
            this.stm.close();
        }
        finally {
            if (!readCS) {
                fileSys.setVerifyChecksum(true);
            }
            this.cleanupFile(fileSys, file);
        }
    }

    private void testFileCorruption(LocalFileSystem fileSys) throws IOException {
        String dir = System.getProperty("test.build.data", ".");
        Path file = new Path(dir + "/corruption-test.dat");
        Path crcFile = new Path(dir + "/.corruption-test.dat.crc");
        this.writeFile((FileSystem)fileSys, file);
        int fileLen = (int)fileSys.getFileStatus(file).getLen();
        byte[] buf = new byte[fileLen];
        FSDataInputStream in = fileSys.open(file);
        IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)buf.length);
        in.close();
        this.checkFileCorruption(fileSys, file, crcFile);
        fileSys.delete(file, true);
        this.writeFile((FileSystem)fileSys, file);
        this.checkFileCorruption(fileSys, file, file);
        fileSys.delete(file, true);
    }

    private void checkFileCorruption(LocalFileSystem fileSys, Path file, Path fileToCorrupt) throws IOException {
        int corruptFileLen;
        RandomAccessFile out = new RandomAccessFile(new File(fileToCorrupt.toString()), "rw");
        byte[] buf = new byte[(int)fileSys.getFileStatus(file).getLen()];
        Assert.assertTrue((buf.length >= (corruptFileLen = (int)fileSys.getFileStatus(fileToCorrupt).getLen()) ? 1 : 0) != 0);
        this.rand.nextBytes(buf);
        out.seek(corruptFileLen / 2);
        out.write(buf, 0, corruptFileLen / 4);
        out.close();
        boolean gotException = false;
        FSDataInputStream in = fileSys.open(file);
        try {
            IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)buf.length);
        }
        catch (ChecksumException e) {
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFSInputChecker() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 131072L);
        conf.setInt("dfs.bytes-per-checksum", 65536);
        this.rand.nextBytes(this.expected);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        FileSystem fileSys = cluster.getFileSystem();
        try {
            this.testChecker(fileSys, true);
            this.testChecker(fileSys, false);
            this.testSeekAndRead(fileSys);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
        fileSys = FileSystem.getLocal((Configuration)conf);
        try {
            this.testChecker(fileSys, true);
            this.testChecker(fileSys, false);
            this.testFileCorruption((LocalFileSystem)fileSys);
            this.testSeekAndRead(fileSys);
        }
        finally {
            fileSys.close();
        }
    }

    private void testSeekAndRead(FileSystem fileSys) throws IOException {
        Path file = new Path("try.dat");
        this.writeFile(fileSys, file);
        this.stm = fileSys.open(file, fileSys.getConf().getInt("io.file.buffer.size", 4096));
        this.checkSeekAndRead();
        this.stm.close();
        this.cleanupFile(fileSys, file);
    }

    private void checkSeekAndRead() throws IOException {
        int position = 1;
        int len = 131072 - position;
        this.readAndCompare(this.stm, position, len);
        position = 65536;
        len = 65536;
        this.readAndCompare(this.stm, position, len);
    }

    private void readAndCompare(FSDataInputStream in, int position, int len) throws IOException {
        byte[] b = new byte[len];
        in.seek((long)position);
        IOUtils.readFully((InputStream)in, (byte[])b, (int)0, (int)b.length);
        for (int i = 0; i < b.length; ++i) {
            Assert.assertEquals((long)this.expected[position + i], (long)b[i]);
        }
    }
}

