/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDatanodeConfig {
    private static final File BASE_DIR = new File(MiniHDFSCluster.getBaseDirectory());
    private static MiniHDFSCluster cluster;

    @BeforeClass
    public static void setUp() throws Exception {
        TestDatanodeConfig.clearBaseDir();
        HdfsConfiguration conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).buildHDFS();
        cluster.waitActive();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
        TestDatanodeConfig.clearBaseDir();
    }

    private static void clearBaseDir() throws IOException {
        if (BASE_DIR.exists() && !FileUtil.fullyDelete((File)BASE_DIR)) {
            throw new IOException("Cannot clear BASE_DIR " + BASE_DIR);
        }
    }

    @Test
    public void testDataDirectories() throws IOException {
        File dataDir = new File(BASE_DIR, "data").getCanonicalFile();
        Configuration conf = cluster.getConfiguration(0);
        String dnDir = TestDatanodeConfig.makeURI("shv", null, Util.fileAsURI((File)dataDir).getPath());
        conf.set("dfs.datanode.data.dir", dnDir);
        DataNode dn = null;
        try {
            dn = DataNode.createDataNode((String[])new String[0], (Configuration)conf);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (dn != null) {
            dn.shutdown();
        }
        Assert.assertNull((String)"Data-node startup should have failed.", (Object)dn);
        String dnDir1 = Util.fileAsURI((File)dataDir).toString() + "1";
        String dnDir2 = TestDatanodeConfig.makeURI("file", "localhost", Util.fileAsURI((File)dataDir).getPath() + "2");
        String dnDir3 = dataDir.getAbsolutePath() + "3";
        conf.set("dfs.datanode.data.dir", dnDir1 + "," + dnDir2 + "," + dnDir3);
        cluster.startDataNodes(conf, 1, false, HdfsServerConstants.StartupOption.REGULAR, null);
        Assert.assertTrue((String)"Data-node should startup.", (boolean)cluster.isDataNodeUp());
    }

    private static String makeURI(String scheme, String host, String path) throws IOException {
        try {
            URI uDir = new URI(scheme, host, path, null);
            return uDir.toString();
        }
        catch (URISyntaxException e) {
            throw new IOException("Bad URI", e);
        }
    }
}

