/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.UpgradeUtilities;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSRollback {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hdfs.TestDFSRollback");
    private Configuration conf;
    private int testCounter = 0;
    private MiniHDFSCluster cluster = null;

    void log(String label, int numDirs) {
        LOG.info((Object)"============================================================");
        LOG.info((Object)("***TEST " + this.testCounter++ + "*** " + label + ":" + " numDirs=" + numDirs));
    }

    void checkResult(HdfsServerConstants.NodeType nodeType, String[] baseDirs) throws Exception {
        ArrayList curDirs = Lists.newArrayList();
        block4: for (String baseDir : baseDirs) {
            File curDir = new File(baseDir, "current");
            curDirs.add(curDir);
            switch (nodeType) {
                case NAME_NODE: {
                    FSImageTestUtil.assertReasonableNameCurrentDir(curDir);
                    continue block4;
                }
                case DATA_NODE: {
                    Assert.assertEquals((long)UpgradeUtilities.checksumContents(nodeType, curDir), (long)UpgradeUtilities.checksumMasterDataNodeContents());
                }
            }
        }
        FSImageTestUtil.assertParallelFilesAreIdentical(curDirs, Collections.<String>emptySet());
        for (int i = 0; i < baseDirs.length; ++i) {
            Assert.assertFalse((boolean)new File(baseDirs[i], "previous").isDirectory());
        }
    }

    void startNameNodeShouldFail(HdfsServerConstants.StartupOption operation, String searchString) {
        try {
            this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).startupOption(operation).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).buildHDFS();
            throw new AssertionError((Object)"NameNode should have failed to start");
        }
        catch (Exception expected) {
            if (!expected.getMessage().contains(searchString)) {
                Assert.fail((String)("Expected substring '" + searchString + "' in exception " + "but got: " + StringUtils.stringifyException((Throwable)expected)));
            }
            return;
        }
    }

    void startBlockPoolShouldFail(HdfsServerConstants.StartupOption operation, String bpid) throws IOException {
        this.cluster.startDataNodes(this.conf, 1, false, operation, null);
        Assert.assertFalse((String)("Block pool " + bpid + " should have failed to start"), (boolean)this.cluster.getDataNodes().get(0).isBPServiceAlive(bpid));
    }

    @Test
    public void testRollback() throws Exception {
        UpgradeUtilities.initialize();
        StorageInfo storageInfo = null;
        for (int numDirs = 1; numDirs <= 2; ++numDirs) {
            this.conf = new HdfsConfiguration();
            this.conf.setInt("dfs.datanode.scan.period.hours", -1);
            this.conf = UpgradeUtilities.initializeStorageStateConf(numDirs, this.conf);
            String[] nameNodeDirs = this.conf.getStrings("dfs.namenode.name.dir");
            String[] dataNodeDirs = this.conf.getStrings("dfs.datanode.data.dir");
            this.log("Normal NameNode rollback", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "previous");
            this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.ROLLBACK).buildHDFS();
            this.checkResult(HdfsServerConstants.NodeType.NAME_NODE, nameNodeDirs);
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("Normal DataNode rollback", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "previous");
            this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.ROLLBACK).buildHDFS();
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "previous");
            this.cluster.startDataNodes(this.conf, 1, false, HdfsServerConstants.StartupOption.ROLLBACK, null);
            this.checkResult(HdfsServerConstants.NodeType.DATA_NODE, dataNodeDirs);
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("Normal BlockPool rollback", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "previous");
            this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.ROLLBACK).buildHDFS();
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            UpgradeUtilities.createBlockPoolStorageDirs(dataNodeDirs, "current", UpgradeUtilities.getCurrentBlockPoolID(this.cluster));
            UpgradeUtilities.createBlockPoolStorageDirs(dataNodeDirs, "previous", UpgradeUtilities.getCurrentBlockPoolID(this.cluster));
            storageInfo = new StorageInfo(UpgradeUtilities.getCurrentLayoutVersion() - 1, UpgradeUtilities.getCurrentNamespaceID(this.cluster), UpgradeUtilities.getCurrentClusterID(this.cluster), UpgradeUtilities.getCurrentFsscTime(this.cluster));
            File[] dataCurrentDirs = new File[dataNodeDirs.length];
            for (int i = 0; i < dataNodeDirs.length; ++i) {
                dataCurrentDirs[i] = new File(new Path(dataNodeDirs[i] + "/current").toString());
            }
            UpgradeUtilities.createDataNodeVersionFile(dataCurrentDirs, storageInfo, UpgradeUtilities.getCurrentBlockPoolID(this.cluster));
            this.cluster.startDataNodes(this.conf, 1, false, HdfsServerConstants.StartupOption.ROLLBACK, null);
            Assert.assertTrue((boolean)this.cluster.isDataNodeUp());
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("NameNode rollback without existing previous dir", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            this.startNameNodeShouldFail(HdfsServerConstants.StartupOption.ROLLBACK, "None of the storage directories contain previous fs state");
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("DataNode rollback without existing previous dir", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.UPGRADE).buildHDFS();
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            this.cluster.startDataNodes(this.conf, 1, false, HdfsServerConstants.StartupOption.ROLLBACK, null);
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("DataNode rollback with future stored layout version in previous", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "previous");
            this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.ROLLBACK).buildHDFS();
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            File[] baseDirs = UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "previous");
            storageInfo = new StorageInfo(Integer.MIN_VALUE, UpgradeUtilities.getCurrentNamespaceID(this.cluster), UpgradeUtilities.getCurrentClusterID(this.cluster), UpgradeUtilities.getCurrentFsscTime(this.cluster));
            UpgradeUtilities.createDataNodeVersionFile(baseDirs, storageInfo, UpgradeUtilities.getCurrentBlockPoolID(this.cluster));
            this.startBlockPoolShouldFail(HdfsServerConstants.StartupOption.ROLLBACK, this.cluster.getNamesystem().getBlockPoolId());
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("DataNode rollback with newer fsscTime in previous", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "previous");
            this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(0).format(false).manageDataDfsDirs(false).manageNameDfsDirs(false).startupOption(HdfsServerConstants.StartupOption.ROLLBACK).buildHDFS();
            UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "current");
            baseDirs = UpgradeUtilities.createDataNodeStorageDirs(dataNodeDirs, "previous");
            storageInfo = new StorageInfo(UpgradeUtilities.getCurrentLayoutVersion(), UpgradeUtilities.getCurrentNamespaceID(this.cluster), UpgradeUtilities.getCurrentClusterID(this.cluster), Long.MAX_VALUE);
            UpgradeUtilities.createDataNodeVersionFile(baseDirs, storageInfo, UpgradeUtilities.getCurrentBlockPoolID(this.cluster));
            this.startBlockPoolShouldFail(HdfsServerConstants.StartupOption.ROLLBACK, this.cluster.getNamesystem().getBlockPoolId());
            this.cluster.shutdown();
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            UpgradeUtilities.createEmptyDirs(dataNodeDirs);
            this.log("NameNode rollback with no edits file", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            baseDirs = UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "previous");
            this.deleteMatchingFiles(baseDirs, "edits.*");
            this.startNameNodeShouldFail(HdfsServerConstants.StartupOption.ROLLBACK, "Gap in transactions");
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("NameNode rollback with no image file", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            baseDirs = UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "previous");
            this.deleteMatchingFiles(baseDirs, "fsimage_.*");
            this.startNameNodeShouldFail(HdfsServerConstants.StartupOption.ROLLBACK, "No valid image files found");
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("NameNode rollback with corrupt version file", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            for (File f : baseDirs = UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "previous")) {
                UpgradeUtilities.corruptFile(new File(f, "VERSION"), "layoutVersion".getBytes(Charsets.UTF_8), "xxxxxxxxxxxxx".getBytes(Charsets.UTF_8));
            }
            this.startNameNodeShouldFail(HdfsServerConstants.StartupOption.ROLLBACK, "file VERSION has layoutVersion missing");
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
            this.log("NameNode rollback with old layout version in previous", numDirs);
            UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "current");
            baseDirs = UpgradeUtilities.createNameNodeStorageDirs(nameNodeDirs, "previous");
            storageInfo = new StorageInfo(1, UpgradeUtilities.getCurrentNamespaceID(null), UpgradeUtilities.getCurrentClusterID(null), UpgradeUtilities.getCurrentFsscTime(null));
            UpgradeUtilities.createNameNodeVersionFile(this.conf, baseDirs, storageInfo, UpgradeUtilities.getCurrentBlockPoolID(this.cluster));
            this.startNameNodeShouldFail(HdfsServerConstants.StartupOption.ROLLBACK, "Cannot rollback to storage version 1 using this version");
            UpgradeUtilities.createEmptyDirs(nameNodeDirs);
        }
    }

    private void deleteMatchingFiles(File[] baseDirs, String regex) {
        for (File baseDir : baseDirs) {
            for (File f : baseDir.listFiles()) {
                if (!f.getName().matches(regex)) continue;
                f.delete();
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        LOG.info((Object)"Shutting down MiniDFSCluster");
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        new TestDFSRollback().testRollback();
    }
}

