/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class TestDFSOutputStream {
    static MiniHDFSCluster cluster;

    @BeforeClass
    public static void setup() throws IOException {
        Configuration conf = new Configuration();
        cluster = new MiniDFSCluster.Builder(conf).buildHDFS();
    }

    @Test
    public void testCloseTwice() throws IOException {
        DistributedFileSystem fs = cluster.getFileSystem();
        FSDataOutputStream os = fs.create(new Path("/test"));
        DFSOutputStream dos = (DFSOutputStream)Whitebox.getInternalState((Object)os, (String)"wrappedStream");
        AtomicReference ex = (AtomicReference)Whitebox.getInternalState((Object)dos, (String)"lastException");
        Assert.assertEquals(null, ex.get());
        dos.close();
        IOException dummy = new IOException("dummy");
        ex.set(dummy);
        try {
            dos.close();
        }
        catch (IOException e) {
            Assert.assertEquals((Object)e, (Object)dummy);
        }
        Assert.assertEquals(null, ex.get());
        dos.close();
    }

    @AfterClass
    public static void tearDown() {
        cluster.shutdown();
    }
}

