/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.util.ThreadUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDFSClientExcludedNodes {
    private MiniHDFSCluster cluster;
    private Configuration conf;

    @Before
    public void setUp() {
        this.cluster = null;
        this.conf = new HdfsConfiguration();
    }

    @After
    public void tearDown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testExcludedNodes() throws IOException {
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).buildHDFS();
        DistributedFileSystem fs = this.cluster.getFileSystem();
        Path filePath = new Path("/testExcludedNodes");
        this.cluster.stopDataNode(AppendTestUtil.nextInt(3));
        FSDataOutputStream out = fs.create(filePath, true, 4096, (short)3, fs.getDefaultBlockSize(filePath));
        out.write(20);
        try {
            out.close();
        }
        catch (Exception e) {
            Assert.fail((String)("Single DN failure should not result in a block abort: \n" + e.getMessage()));
        }
    }

    @Test(timeout=60000L)
    public void testExcludedNodesForgiveness() throws IOException {
        this.conf.setLong("dfs.client.write.exclude.nodes.cache.expiry.interval.millis", 2500L);
        this.conf.setInt("io.bytes.per.checksum", 512);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).buildHDFS();
        ArrayList<MiniHDFSCluster.DataNodeProperties> props = this.cluster.dataNodes;
        DistributedFileSystem fs = this.cluster.getFileSystem();
        Path filePath = new Path("/testForgivingExcludedNodes");
        byte[] bytes = new byte[256];
        for (int index = 0; index < bytes.length; ++index) {
            bytes[index] = 48;
        }
        FSDataOutputStream out = fs.create(filePath, true, 4096, (short)3, 512L);
        out.write(bytes);
        out.write(bytes);
        out.hflush();
        MiniHDFSCluster.DataNodeProperties two = this.cluster.stopDataNode(2);
        MiniHDFSCluster.DataNodeProperties one = this.cluster.stopDataNode(1);
        out.write(bytes);
        out.write(bytes);
        out.hflush();
        junit.framework.Assert.assertEquals((boolean)true, (boolean)this.cluster.restartDataNode(one, true));
        junit.framework.Assert.assertEquals((boolean)true, (boolean)this.cluster.restartDataNode(two, true));
        this.cluster.waitActive();
        ThreadUtil.sleepAtLeastIgnoreInterrupts((long)5000L);
        this.cluster.stopDataNode(0);
        try {
            out.write(bytes);
            out.hflush();
            out.close();
        }
        catch (Exception e) {
            Assert.fail((String)("Excluded DataNodes should be forgiven after a while and not cause file writing exception of: '" + e.getMessage() + "'"));
        }
    }
}

