/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.SecureDataNodeStarter;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.StaticMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.SSLFactory;

public class MiniDFSClusterWithNodeGroup
extends MiniHDFSCluster {
    private static String[] NODE_GROUPS = null;
    private static final Log LOG = LogFactory.getLog(MiniDFSClusterWithNodeGroup.class);

    public MiniDFSClusterWithNodeGroup(MiniDFSCluster.Builder builder) throws IOException {
        super(builder);
    }

    public static void setNodeGroups(String[] nodeGroups) {
        NODE_GROUPS = nodeGroups;
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] nodeGroups, String[] hosts, long[] simulatedCapacities, boolean setupHostsFile, boolean checkDataNodeAddrConfig, boolean checkDataNodeHostConfig) throws IOException {
        String[] stringArray;
        if (operation == HdfsServerConstants.StartupOption.RECOVER) {
            return;
        }
        if (checkDataNodeHostConfig) {
            conf.setIfUnset("dfs.datanode.hostname", "127.0.0.1");
        } else {
            conf.set("dfs.datanode.hostname", "127.0.0.1");
        }
        conf.set("dfs.datanode.hostname", "127.0.0.1");
        int curDatanodesNum = this.dataNodes.size();
        if (conf.get("dfs.blockreport.initialDelay") == null) {
            conf.setLong("dfs.blockreport.initialDelay", 0L);
        }
        if (racks != null && numDataNodes > racks.length) {
            throw new IllegalArgumentException("The length of racks [" + racks.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (nodeGroups != null && numDataNodes > nodeGroups.length) {
            throw new IllegalArgumentException("The length of nodeGroups [" + nodeGroups.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (hosts != null && numDataNodes > hosts.length) {
            throw new IllegalArgumentException("The length of hosts [" + hosts.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (racks != null && hosts == null) {
            hosts = new String[numDataNodes];
            for (int i = curDatanodesNum; i < curDatanodesNum + numDataNodes; ++i) {
                hosts[i - curDatanodesNum] = "host" + i + ".foo.com";
            }
        }
        if (simulatedCapacities != null && numDataNodes > simulatedCapacities.length) {
            throw new IllegalArgumentException("The length of simulatedCapacities [" + simulatedCapacities.length + "] is less than the number of datanodes [" + numDataNodes + "].");
        }
        if (operation == null || operation != HdfsServerConstants.StartupOption.ROLLBACK) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = operation.getName();
        }
        String[] dnArgs = stringArray;
        for (int i = curDatanodesNum; i < curDatanodesNum + numDataNodes; ++i) {
            DataNode dn;
            HdfsConfiguration dnConf = new HdfsConfiguration(conf);
            this.setupDatanodeAddress((Configuration)dnConf, setupHostsFile, checkDataNodeAddrConfig);
            if (manageDfsDirs) {
                File dir1 = this.getInstanceStorageDir(i, 0);
                File dir2 = this.getInstanceStorageDir(i, 1);
                dir1.mkdirs();
                dir2.mkdirs();
                if (!dir1.isDirectory() || !dir2.isDirectory()) {
                    throw new IOException("Mkdirs failed to create directory for DataNode " + i + ": " + dir1 + " or " + dir2);
                }
                String dirs = Util.fileAsURI((File)dir1) + "," + Util.fileAsURI((File)dir2);
                dnConf.set("dfs.datanode.data.dir", dirs);
                conf.set("dfs.datanode.data.dir", dirs);
            }
            if (simulatedCapacities != null) {
                SimulatedFSDataset.setFactory((Configuration)dnConf);
                dnConf.setLong("dfs.datanode.simulateddatastorage.capacity", simulatedCapacities[i - curDatanodesNum]);
            }
            LOG.info((Object)("Starting DataNode " + i + " with " + "dfs.datanode.data.dir" + ": " + dnConf.get("dfs.datanode.data.dir")));
            if (hosts != null) {
                dnConf.set("dfs.datanode.hostname", hosts[i - curDatanodesNum]);
                LOG.info((Object)("Starting DataNode " + i + " with hostname set to: " + dnConf.get("dfs.datanode.hostname")));
            }
            if (racks != null) {
                String name = hosts[i - curDatanodesNum];
                if (nodeGroups == null) {
                    LOG.info((Object)("Adding node with hostname : " + name + " to rack " + racks[i - curDatanodesNum]));
                    StaticMapping.addNodeToRack((String)name, (String)racks[i - curDatanodesNum]);
                } else {
                    LOG.info((Object)("Adding node with hostname : " + name + " to serverGroup " + nodeGroups[i - curDatanodesNum] + " and rack " + racks[i - curDatanodesNum]));
                    StaticMapping.addNodeToRack((String)name, (String)(racks[i - curDatanodesNum] + nodeGroups[i - curDatanodesNum]));
                }
            }
            HdfsConfiguration newconf = new HdfsConfiguration((Configuration)dnConf);
            if (hosts != null) {
                NetUtils.addStaticResolution((String)hosts[i - curDatanodesNum], (String)"localhost");
            }
            SecureDataNodeStarter.SecureResources secureResources = null;
            if (UserGroupInformation.isSecurityEnabled()) {
                SSLFactory sslFactory = new SSLFactory(SSLFactory.Mode.SERVER, (Configuration)dnConf);
                try {
                    secureResources = SecureDataNodeStarter.getSecureResources((SSLFactory)sslFactory, (Configuration)dnConf);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if ((dn = DataNode.instantiateDataNode((String[])dnArgs, (Configuration)dnConf, secureResources)) == null) {
                throw new IOException("Cannot start DataNode in " + dnConf.get("dfs.datanode.data.dir"));
            }
            String ipAddr = dn.getXferAddress().getAddress().getHostAddress();
            if (racks != null) {
                int port = dn.getXferAddress().getPort();
                if (nodeGroups == null) {
                    LOG.info((Object)("Adding node with IP:port : " + ipAddr + ":" + port + " to rack " + racks[i - curDatanodesNum]));
                    StaticMapping.addNodeToRack((String)(ipAddr + ":" + port), (String)racks[i - curDatanodesNum]);
                } else {
                    LOG.info((Object)("Adding node with IP:port : " + ipAddr + ":" + port + " to nodeGroup " + nodeGroups[i - curDatanodesNum] + " and rack " + racks[i - curDatanodesNum]));
                    StaticMapping.addNodeToRack((String)(ipAddr + ":" + port), (String)(racks[i - curDatanodesNum] + nodeGroups[i - curDatanodesNum]));
                }
            }
            dn.runDatanodeDaemon();
            this.dataNodes.add(new MiniHDFSCluster.DataNodeProperties(this, dn, (Configuration)newconf, dnArgs, secureResources));
        }
        curDatanodesNum += numDataNodes;
        this.numDataNodes += numDataNodes;
        this.waitActive();
    }

    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] nodeGroups, String[] hosts, long[] simulatedCapacities, boolean setupHostsFile) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, nodeGroups, hosts, simulatedCapacities, setupHostsFile, false, false);
    }

    public void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, long[] simulatedCapacities, String[] nodeGroups) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, nodeGroups, null, simulatedCapacities, false);
    }

    @Override
    public synchronized void startDataNodes(Configuration conf, int numDataNodes, boolean manageDfsDirs, HdfsServerConstants.StartupOption operation, String[] racks, String[] hosts, long[] simulatedCapacities, boolean setupHostsFile, boolean checkDataNodeAddrConfig, boolean checkDataNodeHostConfig) throws IOException {
        this.startDataNodes(conf, numDataNodes, manageDfsDirs, operation, racks, NODE_GROUPS, hosts, simulatedCapacities, setupHostsFile, checkDataNodeAddrConfig, checkDataNodeHostConfig);
    }
}

