/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;

@InterfaceAudience.LimitedPrivate(value={"HBase", "HDFS", "Hive", "MapReduce", "Pig"})
@InterfaceStability.Unstable
public abstract class MiniDFSCluster {
    protected static final Log LOG = LogFactory.getLog(MiniDFSCluster.class);
    private static final String CLUSTER_IMPL = "cluster";
    private static MiniDFSCluster runningInstance = null;

    public void setLeasePeriod(long soft, long hard) {
    }

    public void setLeasePeriod(long soft, long hard, int nnIndex) {
    }

    public abstract void waitClusterUp() throws IOException;

    public abstract void startDataNodes(Configuration var1, int var2, boolean var3, HdfsServerConstants.StartupOption var4, String[] var5, String[] var6, long[] var7) throws IOException;

    public abstract void startDataNodes(Configuration var1, int var2, boolean var3, HdfsServerConstants.StartupOption var4, String[] var5, String[] var6, long[] var7, boolean var8) throws IOException;

    public abstract void startDataNodes(Configuration var1, int var2, boolean var3, HdfsServerConstants.StartupOption var4, String[] var5, String[] var6, long[] var7, boolean var8, boolean var9) throws IOException;

    public abstract void startDataNodes(Configuration var1, int var2, boolean var3, HdfsServerConstants.StartupOption var4, String[] var5, String[] var6, long[] var7, boolean var8, boolean var9, boolean var10) throws IOException;

    public abstract void startDataNodes(Configuration var1, int var2, boolean var3, HdfsServerConstants.StartupOption var4, String[] var5) throws IOException;

    public abstract void startDataNodes(Configuration var1, int var2, boolean var3, HdfsServerConstants.StartupOption var4, String[] var5, long[] var6) throws IOException;

    public void shutdown() {
        LOG.info((Object)"Shutting down MiniDFSCluster");
        this.doShutdown();
        runningInstance = null;
    }

    public abstract void doShutdown();

    public abstract void shutdownDataNodes();

    public abstract Object stopDataNode(int var1);

    public abstract Object stopDataNode(String var1);

    public final boolean restartDataNode(int i) throws IOException {
        return this.restartDataNode(i, false);
    }

    public abstract boolean restartDataNode(int var1, boolean var2) throws IOException;

    public abstract boolean restartDataNodes(boolean var1) throws IOException;

    public final boolean restartDataNodes() throws IOException {
        return this.restartDataNodes(false);
    }

    public abstract boolean isClusterUp();

    public abstract boolean isDataNodeUp();

    public abstract FileSystem getFileSystem() throws IOException;

    public abstract void waitActive() throws IOException;

    public abstract void formatDataNodeDirs() throws IOException;

    public abstract int getNameNodePort();

    public static final void shutdownCluster(MiniDFSCluster cluster) {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    public abstract URI getURI();

    public static MiniDFSCluster getRunningInstance() {
        return runningInstance;
    }

    static {
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
    }

    public static class Builder {
        protected int nameNodePort = 0;
        protected int nameNodeHttpPort = 0;
        protected final Configuration conf;
        protected int numDataNodes = 1;
        protected boolean format = true;
        protected boolean manageNameDfsDirs = true;
        protected boolean manageNameDfsSharedDirs = true;
        protected boolean enableManagedDfsDirsRedundancy = true;
        protected boolean manageDataDfsDirs = true;
        protected HdfsServerConstants.StartupOption option = null;
        protected String[] racks = null;
        protected String[] hosts = null;
        protected long[] simulatedCapacities = null;
        protected String clusterId = null;
        protected boolean waitSafeMode = true;
        protected boolean setupHostsFile = false;
        protected MiniDFSNNTopology nnTopology = null;
        protected boolean checkExitOnShutdown = true;
        protected boolean checkDataNodeAddrConfig = false;
        protected boolean checkDataNodeHostConfig = false;

        public Builder(Configuration conf) {
            this.conf = conf;
        }

        public Builder nameNodePort(int val) {
            this.nameNodePort = val;
            return this;
        }

        public Builder nameNodeHttpPort(int val) {
            this.nameNodeHttpPort = val;
            return this;
        }

        public Builder numDataNodes(int val) {
            this.numDataNodes = val;
            return this;
        }

        public Builder format(boolean val) {
            this.format = val;
            return this;
        }

        public Builder manageNameDfsDirs(boolean val) {
            this.manageNameDfsDirs = val;
            return this;
        }

        public Builder manageNameDfsSharedDirs(boolean val) {
            this.manageNameDfsSharedDirs = val;
            return this;
        }

        public Builder enableManagedDfsDirsRedundancy(boolean val) {
            this.enableManagedDfsDirsRedundancy = val;
            return this;
        }

        public Builder manageDataDfsDirs(boolean val) {
            this.manageDataDfsDirs = val;
            return this;
        }

        public Builder startupOption(HdfsServerConstants.StartupOption val) {
            this.option = val;
            return this;
        }

        public Builder racks(String[] val) {
            this.racks = val;
            return this;
        }

        public Builder hosts(String[] val) {
            this.hosts = val;
            return this;
        }

        public Builder simulatedCapacities(long[] val) {
            this.simulatedCapacities = val;
            return this;
        }

        public Builder waitSafeMode(boolean val) {
            this.waitSafeMode = val;
            return this;
        }

        public Builder checkExitOnShutdown(boolean val) {
            this.checkExitOnShutdown = val;
            return this;
        }

        public Builder checkDataNodeAddrConfig(boolean val) {
            this.checkDataNodeAddrConfig = val;
            return this;
        }

        public Builder checkDataNodeHostConfig(boolean val) {
            this.checkDataNodeHostConfig = val;
            return this;
        }

        public Builder clusterId(String cid) {
            this.clusterId = cid;
            return this;
        }

        public Builder setupHostsFile(boolean val) {
            this.setupHostsFile = val;
            return this;
        }

        public Builder nnTopology(MiniDFSNNTopology topology) {
            this.nnTopology = topology;
            return this;
        }

        public MiniDFSCluster build() throws IOException {
            String implClassName = System.getProperty(MiniDFSCluster.CLUSTER_IMPL);
            Class clazz = MiniHDFSCluster.class;
            if (implClassName != null && !implClassName.isEmpty()) {
                try {
                    clazz = this.getClass().getClassLoader().loadClass(implClassName).asSubclass(MiniDFSCluster.class);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return this.build(clazz);
        }

        public MiniHDFSCluster buildHDFS() throws IOException {
            return this.build(MiniHDFSCluster.class);
        }

        public <T extends MiniDFSCluster> T build(Class<T> clazz) throws IOException {
            if (runningInstance != null) {
                LOG.info((Object)"Old cluster instance found ... terminating it");
                runningInstance.shutdown();
            }
            try {
                MiniDFSCluster t = (MiniDFSCluster)clazz.getDeclaredConstructor(Builder.class).newInstance(this);
                LOG.info((Object)("Created cluster: " + t.getClass().getName()));
                runningInstance = t;
                return (T)t;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

