/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.Time;

public class DataNodeCluster {
    static final String DATANODE_DIRS = "/tmp/DataNodeCluster";
    static String dataNodeDirs = "/tmp/DataNodeCluster";
    static final String USAGE = "Usage: datanodecluster  -n <numDataNodes>  [-racks <numRacks>]  [-simulated]  [-inject startingBlockId numBlocksPerDN] [-r replicationFactorForInjectedBlocks] [-d dataNodeDirs]\n [-checkDataNodeAddrConfig]\n      Default datanode direcory is /tmp/DataNodeCluster\n      Default replication factor for injected blocks is 1\n      Defaul rack is used if -racks is not specified\n      Data nodes are simulated if -simulated OR conf file specifies simulated\n      -checkDataNodeAddrConfig tells DataNodeConf to use data node addresses from conf file, if it is set. If not set, use .localhost'.";

    static void printUsageExit() {
        System.out.println(USAGE);
        System.exit(-1);
    }

    static void printUsageExit(String err) {
        System.out.println(err);
        DataNodeCluster.printUsageExit();
    }

    public static void main(String[] args) {
        String nameNodeAdr;
        int numDataNodes = 0;
        int numRacks = 0;
        boolean inject = false;
        long startingBlockId = 1L;
        int numBlocksPerDNtoInject = 0;
        int replication = 1;
        boolean checkDataNodeAddrConfig = false;
        HdfsConfiguration conf = new HdfsConfiguration();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-n")) {
                if (++i >= args.length || args[i].startsWith("-")) {
                    DataNodeCluster.printUsageExit("missing number of nodes");
                }
                numDataNodes = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-racks")) {
                if (++i >= args.length || args[i].startsWith("-")) {
                    DataNodeCluster.printUsageExit("Missing number of racks");
                }
                numRacks = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-r")) {
                if (++i >= args.length || args[i].startsWith("-")) {
                    DataNodeCluster.printUsageExit("Missing replicaiton factor");
                }
                replication = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-d")) {
                if (++i >= args.length || args[i].startsWith("-")) {
                    DataNodeCluster.printUsageExit("Missing datanode dirs parameter");
                }
                dataNodeDirs = args[i];
                continue;
            }
            if (args[i].equals("-simulated")) {
                SimulatedFSDataset.setFactory((Configuration)conf);
                continue;
            }
            if (args[i].equals("-inject")) {
                if (!FsDatasetSpi.Factory.getFactory((Configuration)conf).isSimulated()) {
                    System.out.print("-inject is valid only for simulated");
                    DataNodeCluster.printUsageExit();
                }
                inject = true;
                if (++i >= args.length || args[i].startsWith("-")) {
                    DataNodeCluster.printUsageExit("Missing starting block and number of blocks per DN to inject");
                }
                startingBlockId = Integer.parseInt(args[i]);
                if (++i >= args.length || args[i].startsWith("-")) {
                    DataNodeCluster.printUsageExit("Missing number of blocks to inject");
                }
                numBlocksPerDNtoInject = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-checkDataNodeAddrConfig")) {
                checkDataNodeAddrConfig = true;
                continue;
            }
            DataNodeCluster.printUsageExit();
        }
        if (numDataNodes <= 0 || replication <= 0) {
            DataNodeCluster.printUsageExit("numDataNodes and replication have to be greater than zero");
        }
        if (replication > numDataNodes) {
            DataNodeCluster.printUsageExit("Replication must be less than or equal to numDataNodes");
        }
        if ((nameNodeAdr = FileSystem.getDefaultUri((Configuration)conf).getAuthority()) == null) {
            System.out.println("No name node address and port in config");
            System.exit(-1);
        }
        boolean simulated = FsDatasetSpi.Factory.getFactory((Configuration)conf).isSimulated();
        System.out.println("Starting " + numDataNodes + (simulated ? " Simulated " : " ") + " Data Nodes that will connect to Name Node at " + nameNodeAdr);
        System.setProperty("test.build.data", dataNodeDirs);
        MiniHDFSCluster mc = null;
        try {
            mc = new MiniDFSCluster.Builder((Configuration)conf).buildHDFS();
            mc.formatDataNodeDirs();
        }
        catch (IOException e) {
            System.out.println("Error formating data node dirs:" + e);
        }
        String[] rack4DataNode = null;
        if (numRacks > 0) {
            System.out.println("Using " + numRacks + " racks: ");
            String rackPrefix = DataNodeCluster.getUniqueRackPrefix();
            rack4DataNode = new String[numDataNodes];
            for (int i = 0; i < numDataNodes; ++i) {
                rack4DataNode[i] = rackPrefix + "-" + i % numRacks;
                System.out.println("Data Node " + i + " using " + rack4DataNode[i]);
            }
        }
        try {
            mc.startDataNodes((Configuration)conf, numDataNodes, true, HdfsServerConstants.StartupOption.REGULAR, rack4DataNode, null, null, false, checkDataNodeAddrConfig);
            if (inject) {
                long blockSize = 10L;
                System.out.println("Injecting " + numBlocksPerDNtoInject + " blocks in each DN starting at blockId " + startingBlockId + " with blocksize of " + blockSize);
                Block[] blocks = new Block[numBlocksPerDNtoInject];
                long blkid = startingBlockId;
                for (int i_dn = 0; i_dn < numDataNodes; ++i_dn) {
                    int i;
                    for (i = 0; i < blocks.length; ++i) {
                        blocks[i] = new Block(blkid++, blockSize, 1000L);
                    }
                    for (i = 1; i <= replication; ++i) {
                        mc.injectBlocks((i_dn + i - 1) % numDataNodes, Arrays.asList(blocks));
                        System.out.println("Injecting blocks of dn " + i_dn + " into dn" + (i_dn + i - 1) % numDataNodes);
                    }
                }
                System.out.println("Created blocks from Bids " + startingBlockId + " to " + (blkid - 1L));
            }
        }
        catch (IOException e) {
            System.out.println("Error creating data node:" + e);
        }
    }

    private static String getUniqueRackPrefix() {
        String ip = "unknownIP";
        try {
            ip = DNS.getDefaultIP((String)"default");
        }
        catch (UnknownHostException ignored) {
            System.out.println("Could not find ip address of \"default\" inteface.");
        }
        int rand = DFSUtil.getSecureRandom().nextInt(Integer.MAX_VALUE);
        return "/Rack-" + rand + "-" + ip + "-" + Time.now();
    }
}

