/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.BlockReaderFactory;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.net.TcpPeerServer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;

public class BlockReaderTestUtil {
    private HdfsConfiguration conf = null;
    private MiniHDFSCluster cluster = null;

    public BlockReaderTestUtil(int replicationFactor) throws Exception {
        this(replicationFactor, new HdfsConfiguration());
    }

    public BlockReaderTestUtil(int replicationFactor, HdfsConfiguration config) throws Exception {
        this.conf = config;
        this.conf.setInt("dfs.replication", replicationFactor);
        this.cluster = new MiniDFSCluster.Builder((Configuration)this.conf).format(true).buildHDFS();
        this.cluster.waitActive();
    }

    public void shutdown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    public MiniHDFSCluster getCluster() {
        return this.cluster;
    }

    public HdfsConfiguration getConf() {
        return this.conf;
    }

    public byte[] writeFile(Path filepath, int sizeKB) throws IOException {
        DistributedFileSystem fs = this.cluster.getFileSystem();
        FSDataOutputStream os = fs.create(filepath);
        byte[] data = new byte[1024 * sizeKB];
        new Random().nextBytes(data);
        os.write(data);
        os.close();
        return data;
    }

    public List<LocatedBlock> getFileBlocks(Path filepath, int sizeKB) throws IOException {
        DFSClient dfsclient = this.getDFSClient();
        return dfsclient.getNamenode().getBlockLocations(filepath.toString(), 0L, (long)(sizeKB * 1024)).getLocatedBlocks();
    }

    public DFSClient getDFSClient() throws IOException {
        InetSocketAddress nnAddr = new InetSocketAddress("localhost", this.cluster.getNameNodePort());
        return new DFSClient(nnAddr, (Configuration)this.conf);
    }

    public void readAndCheckEOS(BlockReader reader, int length, boolean expectEof) throws IOException {
        int n;
        byte[] buf = new byte[1024];
        for (int nRead = 0; nRead < length; nRead += n) {
            DFSClient.LOG.info((Object)("So far read " + nRead + " - going to read more."));
            n = reader.read(buf, 0, buf.length);
            Assert.assertTrue((n > 0 ? 1 : 0) != 0);
        }
        if (expectEof) {
            DFSClient.LOG.info((Object)"Done reading, expect EOF for next read.");
            Assert.assertEquals((long)-1L, (long)reader.read(buf, 0, buf.length));
        }
    }

    public BlockReader getBlockReader(LocatedBlock testBlock, int offset, int lenToRead) throws IOException {
        InetSocketAddress targetAddr = null;
        Socket sock = null;
        ExtendedBlock block = testBlock.getBlock();
        DatanodeInfo[] nodes = testBlock.getLocations();
        targetAddr = NetUtils.createSocketAddr((String)nodes[0].getXferAddr());
        sock = NetUtils.getDefaultSocketFactory((Configuration)this.conf).createSocket();
        sock.connect(targetAddr, HdfsServerConstants.READ_TIMEOUT);
        sock.setSoTimeout(HdfsServerConstants.READ_TIMEOUT);
        return BlockReaderFactory.newBlockReader((DFSClient.Conf)new DFSClient.Conf((Configuration)this.conf), (String)(targetAddr.toString() + ":" + block.getBlockId()), (ExtendedBlock)block, (Token)testBlock.getBlockToken(), (long)offset, (long)lenToRead, (boolean)true, (String)"BlockReaderTestUtil", (Peer)TcpPeerServer.peerFromSocket((Socket)sock), (DatanodeID)nodes[0], null, null, null, (boolean)false, (CachingStrategy)CachingStrategy.newDefaultStrategy());
    }

    public DataNode getDataNode(LocatedBlock testBlock) {
        DatanodeInfo[] nodes = testBlock.getLocations();
        int ipcport = nodes[0].getIpcPort();
        return this.cluster.getDataNode(ipcport);
    }
}

