/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.viewfs.ViewFsBaseTest;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public class TestViewFsAtHdfsRoot
extends ViewFsBaseTest {
    private static MiniHDFSCluster cluster;
    private static HdfsConfiguration CONF;
    private static FileContext fc;

    protected FileContextTestHelper createFileContextHelper() {
        return new FileContextTestHelper("/tmp/TestViewFsAtHdfsRoot");
    }

    @BeforeClass
    public static void clusterSetupAtBegining() throws IOException, LoginException, URISyntaxException {
        SupportsBlocks = true;
        CONF.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder((Configuration)CONF).numDataNodes(2).buildHDFS();
        cluster.waitClusterUp();
        fc = FileContext.getFileContext((URI)cluster.getURI(0), (Configuration)CONF);
    }

    @AfterClass
    public static void ClusterShutdownAtEnd() throws Exception {
        cluster.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        this.fcTarget = fc;
        super.setUp();
    }

    void initializeTargetTestRoot() throws IOException {
        this.targetTestRoot = fc.makeQualified(new Path("/"));
        RemoteIterator dirContents = fc.listStatus(this.targetTestRoot);
        while (dirContents.hasNext()) {
            fc.delete(((FileStatus)dirContents.next()).getPath(), true);
        }
    }

    int getExpectedDelegationTokenCount() {
        return 8;
    }

    static {
        CONF = new HdfsConfiguration();
    }
}

