/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniHDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFcHdfsSetUMask {
    private static FileContextTestHelper fileContextTestHelper = new FileContextTestHelper("/tmp/TestFcHdfsSetUMask");
    private static MiniHDFSCluster cluster;
    private static Path defaultWorkingDirectory;
    private static FileContext fc;
    private static final FsPermission USER_GROUP_OPEN_PERMISSIONS;
    private static final FsPermission USER_GROUP_OPEN_FILE_PERMISSIONS;
    private static final FsPermission USER_GROUP_OPEN_TEST_UMASK;
    private static final FsPermission BLANK_PERMISSIONS;
    private static final FsPermission PARENT_PERMS_FOR_BLANK_PERMISSIONS;
    private static final FsPermission BLANK_TEST_UMASK;
    private static final FsPermission WIDE_OPEN_PERMISSIONS;
    private static final FsPermission WIDE_OPEN_FILE_PERMISSIONS;
    private static final FsPermission WIDE_OPEN_TEST_UMASK;

    public TestFcHdfsSetUMask() {
        try {
            ((Log4JLogger)FileSystem.LOG).getLogger().setLevel(Level.DEBUG);
        }
        catch (Exception e) {
            System.out.println("Cannot change log level\n" + StringUtils.stringifyException((Throwable)e));
        }
    }

    @BeforeClass
    public static void clusterSetupAtBegining() throws IOException, LoginException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.permissions.umask-mode", "077");
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).buildHDFS();
        fc = FileContext.getFileContext((URI)cluster.getURI(0), (Configuration)conf);
        defaultWorkingDirectory = fc.makeQualified(new Path("/user/" + UserGroupInformation.getCurrentUser().getShortUserName()));
        fc.mkdir(defaultWorkingDirectory, FileContext.DEFAULT_PERM, true);
    }

    @AfterClass
    public static void ClusterShutdownAtEnd() throws Exception {
        cluster.shutdown();
    }

    @Before
    public void setUp() throws Exception {
        fc.setUMask(WIDE_OPEN_TEST_UMASK);
        fc.mkdir(fileContextTestHelper.getTestRootPath(fc), FileContext.DEFAULT_PERM, true);
    }

    @After
    public void tearDown() throws Exception {
        fc.delete(fileContextTestHelper.getTestRootPath(fc), true);
    }

    @Test
    public void testMkdirWithExistingDirClear() throws IOException {
        this.testMkdirWithExistingDir(BLANK_TEST_UMASK, BLANK_PERMISSIONS);
    }

    @Test
    public void testMkdirWithExistingDirOpen() throws IOException {
        this.testMkdirWithExistingDir(WIDE_OPEN_TEST_UMASK, WIDE_OPEN_PERMISSIONS);
    }

    @Test
    public void testMkdirWithExistingDirMiddle() throws IOException {
        this.testMkdirWithExistingDir(USER_GROUP_OPEN_TEST_UMASK, USER_GROUP_OPEN_PERMISSIONS);
    }

    @Test
    public void testMkdirRecursiveWithNonExistingDirClear() throws IOException {
        this.testMkdirRecursiveWithNonExistingDir(BLANK_TEST_UMASK, BLANK_PERMISSIONS, PARENT_PERMS_FOR_BLANK_PERMISSIONS);
    }

    @Test
    public void testMkdirRecursiveWithNonExistingDirOpen() throws IOException {
        this.testMkdirRecursiveWithNonExistingDir(WIDE_OPEN_TEST_UMASK, WIDE_OPEN_PERMISSIONS, WIDE_OPEN_PERMISSIONS);
    }

    @Test
    public void testMkdirRecursiveWithNonExistingDirMiddle() throws IOException {
        this.testMkdirRecursiveWithNonExistingDir(USER_GROUP_OPEN_TEST_UMASK, USER_GROUP_OPEN_PERMISSIONS, USER_GROUP_OPEN_PERMISSIONS);
    }

    @Test
    public void testCreateRecursiveWithExistingDirClear() throws IOException {
        this.testCreateRecursiveWithExistingDir(BLANK_TEST_UMASK, BLANK_PERMISSIONS);
    }

    @Test
    public void testCreateRecursiveWithExistingDirOpen() throws IOException {
        this.testCreateRecursiveWithExistingDir(WIDE_OPEN_TEST_UMASK, WIDE_OPEN_FILE_PERMISSIONS);
    }

    @Test
    public void testCreateRecursiveWithExistingDirMiddle() throws IOException {
        this.testCreateRecursiveWithExistingDir(USER_GROUP_OPEN_TEST_UMASK, USER_GROUP_OPEN_FILE_PERMISSIONS);
    }

    @Test
    public void testCreateRecursiveWithNonExistingDirClear() throws IOException {
        this.testCreateRecursiveWithNonExistingDir(BLANK_TEST_UMASK, WIDE_OPEN_PERMISSIONS, BLANK_PERMISSIONS);
    }

    @Test
    public void testCreateRecursiveWithNonExistingDirOpen() throws IOException {
        this.testCreateRecursiveWithNonExistingDir(WIDE_OPEN_TEST_UMASK, WIDE_OPEN_PERMISSIONS, WIDE_OPEN_FILE_PERMISSIONS);
    }

    @Test
    public void testCreateRecursiveWithNonExistingDirMiddle() throws IOException {
        this.testCreateRecursiveWithNonExistingDir(USER_GROUP_OPEN_TEST_UMASK, WIDE_OPEN_PERMISSIONS, USER_GROUP_OPEN_FILE_PERMISSIONS);
    }

    public void testMkdirWithExistingDir(FsPermission umask, FsPermission expectedPerms) throws IOException {
        Path f = fileContextTestHelper.getTestRootPath(fc, "aDir");
        fc.setUMask(umask);
        fc.mkdir(f, FileContext.DEFAULT_PERM, true);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir((FileContext)fc, (Path)f));
        Assert.assertEquals((String)"permissions on directory are wrong", (Object)expectedPerms, (Object)fc.getFileStatus(f).getPermission());
    }

    public void testMkdirRecursiveWithNonExistingDir(FsPermission umask, FsPermission expectedPerms, FsPermission expectedParentPerms) throws IOException {
        Path f = fileContextTestHelper.getTestRootPath(fc, "NonExistant2/aDir");
        fc.setUMask(umask);
        fc.mkdir(f, FileContext.DEFAULT_PERM, true);
        Assert.assertTrue((boolean)FileContextTestHelper.isDir((FileContext)fc, (Path)f));
        Assert.assertEquals((String)"permissions on directory are wrong", (Object)expectedPerms, (Object)fc.getFileStatus(f).getPermission());
        Path fParent = fileContextTestHelper.getTestRootPath(fc, "NonExistant2");
        Assert.assertEquals((String)"permissions on parent directory are wrong", (Object)expectedParentPerms, (Object)fc.getFileStatus(fParent).getPermission());
    }

    public void testCreateRecursiveWithExistingDir(FsPermission umask, FsPermission expectedPerms) throws IOException {
        Path f = fileContextTestHelper.getTestRootPath(fc, "foo");
        fc.setUMask(umask);
        FileContextTestHelper.createFile((FileContext)fc, (Path)f);
        Assert.assertTrue((boolean)FileContextTestHelper.isFile((FileContext)fc, (Path)f));
        Assert.assertEquals((String)"permissions on file are wrong", (Object)expectedPerms, (Object)fc.getFileStatus(f).getPermission());
    }

    public void testCreateRecursiveWithNonExistingDir(FsPermission umask, FsPermission expectedDirPerms, FsPermission expectedFilePerms) throws IOException {
        Path f = fileContextTestHelper.getTestRootPath(fc, "NonExisting/foo");
        Path fParent = fileContextTestHelper.getTestRootPath(fc, "NonExisting");
        Assert.assertFalse((boolean)FileContextTestHelper.exists((FileContext)fc, (Path)fParent));
        fc.setUMask(umask);
        FileContextTestHelper.createFile((FileContext)fc, (Path)f);
        Assert.assertTrue((boolean)FileContextTestHelper.isFile((FileContext)fc, (Path)f));
        Assert.assertEquals((String)"permissions on file are wrong", (Object)expectedFilePerms, (Object)fc.getFileStatus(f).getPermission());
        Assert.assertEquals((String)"permissions on parent directory are wrong", (Object)expectedDirPerms, (Object)fc.getFileStatus(fParent).getPermission());
    }

    static {
        USER_GROUP_OPEN_PERMISSIONS = FsPermission.createImmutable((short)504);
        USER_GROUP_OPEN_FILE_PERMISSIONS = FsPermission.createImmutable((short)432);
        USER_GROUP_OPEN_TEST_UMASK = FsPermission.createImmutable((short)7);
        BLANK_PERMISSIONS = FsPermission.createImmutable((short)0);
        PARENT_PERMS_FOR_BLANK_PERMISSIONS = FsPermission.createImmutable((short)192);
        BLANK_TEST_UMASK = FsPermission.createImmutable((short)511);
        WIDE_OPEN_PERMISSIONS = FsPermission.createImmutable((short)511);
        WIDE_OPEN_FILE_PERMISSIONS = FsPermission.createImmutable((short)438);
        WIDE_OPEN_TEST_UMASK = FsPermission.createImmutable((short)0);
    }
}

