/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3;
import org.apache.hadoop.hdfs.nfs.nfs3.RpcProgramNfs3;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3Constant;
import org.apache.hadoop.nfs.nfs3.request.ACCESS3Request;
import org.apache.hadoop.nfs.nfs3.request.COMMIT3Request;
import org.apache.hadoop.nfs.nfs3.request.CREATE3Request;
import org.apache.hadoop.nfs.nfs3.request.FSINFO3Request;
import org.apache.hadoop.nfs.nfs3.request.FSSTAT3Request;
import org.apache.hadoop.nfs.nfs3.request.GETATTR3Request;
import org.apache.hadoop.nfs.nfs3.request.LOOKUP3Request;
import org.apache.hadoop.nfs.nfs3.request.MKDIR3Request;
import org.apache.hadoop.nfs.nfs3.request.PATHCONF3Request;
import org.apache.hadoop.nfs.nfs3.request.READ3Request;
import org.apache.hadoop.nfs.nfs3.request.READDIR3Request;
import org.apache.hadoop.nfs.nfs3.request.READDIRPLUS3Request;
import org.apache.hadoop.nfs.nfs3.request.READLINK3Request;
import org.apache.hadoop.nfs.nfs3.request.REMOVE3Request;
import org.apache.hadoop.nfs.nfs3.request.RENAME3Request;
import org.apache.hadoop.nfs.nfs3.request.RMDIR3Request;
import org.apache.hadoop.nfs.nfs3.request.SETATTR3Request;
import org.apache.hadoop.nfs.nfs3.request.SYMLINK3Request;
import org.apache.hadoop.nfs.nfs3.request.SetAttr3;
import org.apache.hadoop.nfs.nfs3.request.WRITE3Request;
import org.apache.hadoop.nfs.nfs3.response.ACCESS3Response;
import org.apache.hadoop.nfs.nfs3.response.COMMIT3Response;
import org.apache.hadoop.nfs.nfs3.response.CREATE3Response;
import org.apache.hadoop.nfs.nfs3.response.FSINFO3Response;
import org.apache.hadoop.nfs.nfs3.response.FSSTAT3Response;
import org.apache.hadoop.nfs.nfs3.response.GETATTR3Response;
import org.apache.hadoop.nfs.nfs3.response.LOOKUP3Response;
import org.apache.hadoop.nfs.nfs3.response.MKDIR3Response;
import org.apache.hadoop.nfs.nfs3.response.PATHCONF3Response;
import org.apache.hadoop.nfs.nfs3.response.READ3Response;
import org.apache.hadoop.nfs.nfs3.response.READDIR3Response;
import org.apache.hadoop.nfs.nfs3.response.READDIRPLUS3Response;
import org.apache.hadoop.nfs.nfs3.response.READLINK3Response;
import org.apache.hadoop.nfs.nfs3.response.REMOVE3Response;
import org.apache.hadoop.nfs.nfs3.response.RENAME3Response;
import org.apache.hadoop.nfs.nfs3.response.RMDIR3Response;
import org.apache.hadoop.nfs.nfs3.response.SETATTR3Response;
import org.apache.hadoop.nfs.nfs3.response.SYMLINK3Response;
import org.apache.hadoop.nfs.nfs3.response.WRITE3Response;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.SecurityHandler;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.jboss.netty.channel.Channel;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRpcProgramNfs3 {
    static DistributedFileSystem hdfs;
    static MiniDFSCluster cluster;
    static NfsConfiguration config;
    static HdfsAdmin dfsAdmin;
    static NameNode nn;
    static Nfs3 nfs;
    static RpcProgramNfs3 nfsd;
    static SecurityHandler securityHandler;
    static SecurityHandler securityHandlerUnpriviledged;
    static String testdir;
    private static final String TEST_KEY = "test_key";
    private static FileSystemTestHelper fsHelper;
    private static File testRootDir;

    @BeforeClass
    public static void setup() throws Exception {
        String currentUser = System.getProperty("user.name");
        config.set("fs.permissions.umask-mode", "u=rwx,g=,o=");
        config.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(currentUser), "*");
        config.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(currentUser), "*");
        fsHelper = new FileSystemTestHelper();
        String testRoot = fsHelper.getTestRootDir();
        testRootDir = new File(testRoot).getAbsoluteFile();
        Path jksPath = new Path(testRootDir.toString(), "test.jks");
        config.set("dfs.encryption.key.provider.uri", "jceks://file" + jksPath.toUri());
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)config);
        cluster = new MiniDFSCluster.Builder((Configuration)config).numDataNodes(1).build();
        cluster.waitActive();
        hdfs = cluster.getFileSystem();
        nn = cluster.getNameNode();
        dfsAdmin = new HdfsAdmin(cluster.getURI(), (Configuration)config);
        config.setInt("nfs3.mountd.port", 0);
        config.setInt("nfs3.server.port", 0);
        config.set("dfs.nfs.exports.allowed.hosts", "* rw");
        nfs = new Nfs3(config);
        nfs.startServiceInternal(false);
        nfsd = (RpcProgramNfs3)nfs.getRpcProgram();
        hdfs.getClient().setKeyProvider((KeyProvider)nn.getNamesystem().getProvider());
        DFSTestUtil.createKey((String)TEST_KEY, (MiniDFSCluster)cluster, (Configuration)config);
        securityHandler = (SecurityHandler)Mockito.mock(SecurityHandler.class);
        Mockito.when((Object)securityHandler.getUser()).thenReturn((Object)currentUser);
        securityHandlerUnpriviledged = (SecurityHandler)Mockito.mock(SecurityHandler.class);
        Mockito.when((Object)securityHandlerUnpriviledged.getUser()).thenReturn((Object)"harry");
    }

    @AfterClass
    public static void shutdown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void createFiles() throws IllegalArgumentException, IOException {
        hdfs.delete(new Path(testdir), true);
        hdfs.mkdirs(new Path(testdir));
        hdfs.mkdirs(new Path(testdir + "/foo"));
        DFSTestUtil.createFile((FileSystem)hdfs, (Path)new Path(testdir + "/bar"), (long)0L, (short)1, (long)0L);
    }

    @Test(timeout=60000L)
    public void testGetattr() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo("/tmp/bar");
        long dirId = status.getFileId();
        FileHandle handle = new FileHandle(dirId);
        XDR xdr_req = new XDR();
        GETATTR3Request req = new GETATTR3Request(handle);
        req.serialize(xdr_req);
        GETATTR3Response response1 = nfsd.getattr(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code", (long)13L, (long)response1.getStatus());
        GETATTR3Response response2 = nfsd.getattr(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testSetattr() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(testdir);
        long dirId = status.getFileId();
        XDR xdr_req = new XDR();
        FileHandle handle = new FileHandle(dirId);
        SetAttr3 symAttr = new SetAttr3(0, 1, 0, 0L, null, null, EnumSet.of(SetAttr3.SetAttrField.UID));
        SETATTR3Request req = new SETATTR3Request(handle, symAttr, false, null);
        req.serialize(xdr_req);
        SETATTR3Response response1 = nfsd.setattr(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code", (long)13L, (long)response1.getStatus());
        SETATTR3Response response2 = nfsd.setattr(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testLookup() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(testdir);
        long dirId = status.getFileId();
        FileHandle handle = new FileHandle(dirId);
        LOOKUP3Request lookupReq = new LOOKUP3Request(handle, "bar");
        XDR xdr_req = new XDR();
        lookupReq.serialize(xdr_req);
        LOOKUP3Response response1 = nfsd.lookup(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code", (long)13L, (long)response1.getStatus());
        LOOKUP3Response response2 = nfsd.lookup(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testAccess() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo("/tmp/bar");
        long dirId = status.getFileId();
        FileHandle handle = new FileHandle(dirId);
        XDR xdr_req = new XDR();
        ACCESS3Request req = new ACCESS3Request(handle);
        req.serialize(xdr_req);
        ACCESS3Response response1 = nfsd.access(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code", (long)13L, (long)response1.getStatus());
        ACCESS3Response response2 = nfsd.access(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testReadlink() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(testdir);
        long dirId = status.getFileId();
        XDR xdr_req = new XDR();
        FileHandle handle = new FileHandle(dirId);
        SYMLINK3Request req = new SYMLINK3Request(handle, "fubar", new SetAttr3(), "bar");
        req.serialize(xdr_req);
        SYMLINK3Response response = nfsd.symlink(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)0L, (long)response.getStatus());
        FileHandle handle2 = response.getObjFileHandle();
        XDR xdr_req2 = new XDR();
        READLINK3Request req2 = new READLINK3Request(handle2);
        req2.serialize(xdr_req2);
        READLINK3Response response1 = nfsd.readlink(xdr_req2.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)13L, (long)response1.getStatus());
        READLINK3Response response2 = nfsd.readlink(xdr_req2.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testRead() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo("/tmp/bar");
        long dirId = status.getFileId();
        FileHandle handle = new FileHandle(dirId);
        READ3Request readReq = new READ3Request(handle, 0L, 5);
        XDR xdr_req = new XDR();
        readReq.serialize(xdr_req);
        READ3Response response1 = nfsd.read(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)13L, (long)response1.getStatus());
        READ3Response response2 = nfsd.read(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=120000L)
    public void testEncryptedReadWrite() throws Exception {
        int len = 8192;
        Path zone = new Path("/zone");
        hdfs.mkdirs(zone);
        dfsAdmin.createEncryptionZone(zone, TEST_KEY);
        byte[] buffer = new byte[8192];
        for (int i = 0; i < 8192; ++i) {
            buffer[i] = (byte)i;
        }
        String encFile1 = "/zone/myfile";
        this.createFileUsingNfs("/zone/myfile", buffer);
        this.commit("/zone/myfile", 8192);
        Assert.assertArrayEquals((String)"encFile1 not equal", (byte[])this.getFileContentsUsingNfs("/zone/myfile", 8192), (byte[])this.getFileContentsUsingDfs("/zone/myfile", 8192));
        String encFile2 = "/zone/myfile2";
        Path encFile2Path = new Path("/zone/myfile2");
        DFSTestUtil.createFile((FileSystem)hdfs, (Path)encFile2Path, (long)8192L, (short)1, (long)65261L);
        Assert.assertArrayEquals((String)"encFile2 not equal", (byte[])this.getFileContentsUsingNfs("/zone/myfile2", 8192), (byte[])this.getFileContentsUsingDfs("/zone/myfile2", 8192));
    }

    private void createFileUsingNfs(String fileName, byte[] buffer) throws Exception {
        DFSTestUtil.createFile((FileSystem)hdfs, (Path)new Path(fileName), (long)0L, (short)1, (long)0L);
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(fileName);
        long dirId = status.getFileId();
        FileHandle handle = new FileHandle(dirId);
        WRITE3Request writeReq = new WRITE3Request(handle, 0L, buffer.length, Nfs3Constant.WriteStableHow.DATA_SYNC, ByteBuffer.wrap(buffer));
        XDR xdr_req = new XDR();
        writeReq.serialize(xdr_req);
        WRITE3Response response = nfsd.write(xdr_req.asReadOnlyWrap(), null, 1, securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect response: ", null, (Object)response);
    }

    private byte[] getFileContentsUsingNfs(String fileName, int len) throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(fileName);
        long dirId = status.getFileId();
        FileHandle handle = new FileHandle(dirId);
        READ3Request readReq = new READ3Request(handle, 0L, len);
        XDR xdr_req = new XDR();
        readReq.serialize(xdr_req);
        READ3Response response = nfsd.read(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code: ", (long)0L, (long)response.getStatus());
        Assert.assertTrue((String)"expected full read", (boolean)response.isEof());
        return response.getData().array();
    }

    private byte[] getFileContentsUsingDfs(String fileName, int len) throws Exception {
        FSDataInputStream in = hdfs.open(new Path(fileName));
        byte[] ret = new byte[len];
        in.readFully(ret);
        try {
            in.readByte();
            Assert.fail((String)"expected end of file");
        }
        catch (EOFException e) {
            // empty catch block
        }
        in.close();
        return ret;
    }

    private void commit(String fileName, int len) throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(fileName);
        long dirId = status.getFileId();
        FileHandle handle = new FileHandle(dirId);
        XDR xdr_req = new XDR();
        COMMIT3Request req = new COMMIT3Request(handle, 0L, len);
        req.serialize(xdr_req);
        Channel ch = (Channel)Mockito.mock(Channel.class);
        COMMIT3Response response2 = nfsd.commit(xdr_req.asReadOnlyWrap(), ch, 1, securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect COMMIT3Response:", null, (Object)response2);
    }

    @Test(timeout=60000L)
    public void testWrite() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo("/tmp/bar");
        long dirId = status.getFileId();
        FileHandle handle = new FileHandle(dirId);
        byte[] buffer = new byte[10];
        for (int i = 0; i < 10; ++i) {
            buffer[i] = (byte)i;
        }
        WRITE3Request writeReq = new WRITE3Request(handle, 0L, 10, Nfs3Constant.WriteStableHow.DATA_SYNC, ByteBuffer.wrap(buffer));
        XDR xdr_req = new XDR();
        writeReq.serialize(xdr_req);
        WRITE3Response response1 = nfsd.write(xdr_req.asReadOnlyWrap(), null, 1, securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)13L, (long)response1.getStatus());
        WRITE3Response response2 = nfsd.write(xdr_req.asReadOnlyWrap(), null, 1, securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect response:", null, (Object)response2);
    }

    @Test(timeout=60000L)
    public void testCreate() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(testdir);
        long dirId = status.getFileId();
        XDR xdr_req = new XDR();
        FileHandle handle = new FileHandle(dirId);
        CREATE3Request req = new CREATE3Request(handle, "fubar", 0, new SetAttr3(), 0L);
        req.serialize(xdr_req);
        CREATE3Response response1 = nfsd.create(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)13L, (long)response1.getStatus());
        CREATE3Response response2 = nfsd.create(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testMkdir() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(testdir);
        long dirId = status.getFileId();
        XDR xdr_req = new XDR();
        FileHandle handle = new FileHandle(dirId);
        MKDIR3Request req = new MKDIR3Request(handle, "fubar1", new SetAttr3());
        req.serialize(xdr_req);
        MKDIR3Response response1 = nfsd.mkdir(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)13L, (long)response1.getStatus());
        XDR xdr_req2 = new XDR();
        MKDIR3Request req2 = new MKDIR3Request(handle, "fubar2", new SetAttr3());
        req2.serialize(xdr_req2);
        MKDIR3Response response2 = nfsd.mkdir(xdr_req2.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testSymlink() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(testdir);
        long dirId = status.getFileId();
        XDR xdr_req = new XDR();
        FileHandle handle = new FileHandle(dirId);
        SYMLINK3Request req = new SYMLINK3Request(handle, "fubar", new SetAttr3(), "bar");
        req.serialize(xdr_req);
        SYMLINK3Response response1 = nfsd.symlink(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)13L, (long)response1.getStatus());
        SYMLINK3Response response2 = nfsd.symlink(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testRemove() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(testdir);
        long dirId = status.getFileId();
        XDR xdr_req = new XDR();
        FileHandle handle = new FileHandle(dirId);
        REMOVE3Request req = new REMOVE3Request(handle, "bar");
        req.serialize(xdr_req);
        REMOVE3Response response1 = nfsd.remove(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)13L, (long)response1.getStatus());
        REMOVE3Response response2 = nfsd.remove(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testRmdir() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(testdir);
        long dirId = status.getFileId();
        XDR xdr_req = new XDR();
        FileHandle handle = new FileHandle(dirId);
        RMDIR3Request req = new RMDIR3Request(handle, "foo");
        req.serialize(xdr_req);
        RMDIR3Response response1 = nfsd.rmdir(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)13L, (long)response1.getStatus());
        RMDIR3Response response2 = nfsd.rmdir(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testRename() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(testdir);
        long dirId = status.getFileId();
        XDR xdr_req = new XDR();
        FileHandle handle = new FileHandle(dirId);
        RENAME3Request req = new RENAME3Request(handle, "bar", handle, "fubar");
        req.serialize(xdr_req);
        RENAME3Response response1 = nfsd.rename(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)13L, (long)response1.getStatus());
        RENAME3Response response2 = nfsd.rename(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testReaddir() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(testdir);
        long dirId = status.getFileId();
        FileHandle handle = new FileHandle(dirId);
        XDR xdr_req = new XDR();
        READDIR3Request req = new READDIR3Request(handle, 0L, 0L, 100);
        req.serialize(xdr_req);
        READDIR3Response response1 = nfsd.readdir(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)13L, (long)response1.getStatus());
        READDIR3Response response2 = nfsd.readdir(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testReaddirplus() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(testdir);
        long dirId = status.getFileId();
        FileHandle handle = new FileHandle(dirId);
        XDR xdr_req = new XDR();
        READDIRPLUS3Request req = new READDIRPLUS3Request(handle, 0L, 0L, 3, 2);
        req.serialize(xdr_req);
        READDIRPLUS3Response response1 = nfsd.readdirplus(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)13L, (long)response1.getStatus());
        READDIRPLUS3Response response2 = nfsd.readdirplus(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testFsstat() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo("/tmp/bar");
        long dirId = status.getFileId();
        FileHandle handle = new FileHandle(dirId);
        XDR xdr_req = new XDR();
        FSSTAT3Request req = new FSSTAT3Request(handle);
        req.serialize(xdr_req);
        FSSTAT3Response response1 = nfsd.fsstat(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)13L, (long)response1.getStatus());
        FSSTAT3Response response2 = nfsd.fsstat(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testFsinfo() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo("/tmp/bar");
        long dirId = status.getFileId();
        FileHandle handle = new FileHandle(dirId);
        XDR xdr_req = new XDR();
        FSINFO3Request req = new FSINFO3Request(handle);
        req.serialize(xdr_req);
        FSINFO3Response response1 = nfsd.fsinfo(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)13L, (long)response1.getStatus());
        FSINFO3Response response2 = nfsd.fsinfo(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testPathconf() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo("/tmp/bar");
        long dirId = status.getFileId();
        FileHandle handle = new FileHandle(dirId);
        XDR xdr_req = new XDR();
        PATHCONF3Request req = new PATHCONF3Request(handle);
        req.serialize(xdr_req);
        PATHCONF3Response response1 = nfsd.pathconf(xdr_req.asReadOnlyWrap(), securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)13L, (long)response1.getStatus());
        PATHCONF3Response response2 = nfsd.pathconf(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)0L, (long)response2.getStatus());
    }

    @Test(timeout=60000L)
    public void testCommit() throws Exception {
        HdfsFileStatus status = nn.getRpcServer().getFileInfo("/tmp/bar");
        long dirId = status.getFileId();
        FileHandle handle = new FileHandle(dirId);
        XDR xdr_req = new XDR();
        COMMIT3Request req = new COMMIT3Request(handle, 0L, 5);
        req.serialize(xdr_req);
        Channel ch = (Channel)Mockito.mock(Channel.class);
        COMMIT3Response response1 = nfsd.commit(xdr_req.asReadOnlyWrap(), ch, 1, securityHandlerUnpriviledged, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code:", (long)13L, (long)response1.getStatus());
        COMMIT3Response response2 = nfsd.commit(xdr_req.asReadOnlyWrap(), ch, 1, securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect COMMIT3Response:", null, (Object)response2);
    }

    @Test(timeout=1000L)
    public void testIdempotent() {
        Object[][] procedures;
        for (Object[] procedure : procedures = new Object[][]{{Nfs3Constant.NFSPROC3.NULL, 1}, {Nfs3Constant.NFSPROC3.GETATTR, 1}, {Nfs3Constant.NFSPROC3.SETATTR, 1}, {Nfs3Constant.NFSPROC3.LOOKUP, 1}, {Nfs3Constant.NFSPROC3.ACCESS, 1}, {Nfs3Constant.NFSPROC3.READLINK, 1}, {Nfs3Constant.NFSPROC3.READ, 1}, {Nfs3Constant.NFSPROC3.WRITE, 1}, {Nfs3Constant.NFSPROC3.CREATE, 0}, {Nfs3Constant.NFSPROC3.MKDIR, 0}, {Nfs3Constant.NFSPROC3.SYMLINK, 0}, {Nfs3Constant.NFSPROC3.MKNOD, 0}, {Nfs3Constant.NFSPROC3.REMOVE, 0}, {Nfs3Constant.NFSPROC3.RMDIR, 0}, {Nfs3Constant.NFSPROC3.RENAME, 0}, {Nfs3Constant.NFSPROC3.LINK, 0}, {Nfs3Constant.NFSPROC3.READDIR, 1}, {Nfs3Constant.NFSPROC3.READDIRPLUS, 1}, {Nfs3Constant.NFSPROC3.FSSTAT, 1}, {Nfs3Constant.NFSPROC3.FSINFO, 1}, {Nfs3Constant.NFSPROC3.PATHCONF, 1}, {Nfs3Constant.NFSPROC3.COMMIT, 1}}) {
            boolean idempotent = procedure[1].equals(1);
            Nfs3Constant.NFSPROC3 proc = (Nfs3Constant.NFSPROC3)procedure[0];
            if (idempotent) {
                Assert.assertTrue((String)("Procedure " + proc + " should be idempotent"), (boolean)proc.isIdempotent());
                continue;
            }
            Assert.assertFalse((String)("Procedure " + proc + " should be non-idempotent"), (boolean)proc.isIdempotent());
        }
    }

    @Test
    public void testDeprecatedKeys() {
        NfsConfiguration conf = new NfsConfiguration();
        conf.setInt("nfs3.server.port", 998);
        Assert.assertTrue((conf.getInt("nfs.server.port", 0) == 998 ? 1 : 0) != 0);
        conf.setInt("nfs3.mountd.port", 999);
        Assert.assertTrue((conf.getInt("nfs.mountd.port", 0) == 999 ? 1 : 0) != 0);
        conf.set("dfs.nfs.exports.allowed.hosts", "host1");
        Assert.assertTrue((boolean)conf.get("nfs.exports.allowed.hosts").equals("host1"));
        conf.setInt("dfs.nfs.exports.cache.expirytime.millis", 1000);
        Assert.assertTrue((conf.getInt("nfs.exports.cache.expirytime.millis", 0) == 1000 ? 1 : 0) != 0);
        conf.setInt("hadoop.nfs.userupdate.milly", 10);
        Assert.assertTrue((conf.getInt("usergroupid.update.millis", 0) == 10 ? 1 : 0) != 0);
        conf.set("dfs.nfs3.dump.dir", "/nfs/tmp");
        Assert.assertTrue((boolean)conf.get("nfs.file.dump.dir").equals("/nfs/tmp"));
        conf.setBoolean("dfs.nfs3.enableDump", false);
        Assert.assertTrue((!conf.getBoolean("nfs.file.dump", true) ? 1 : 0) != 0);
        conf.setInt("dfs.nfs3.max.open.files", 500);
        Assert.assertTrue((conf.getInt("nfs.max.open.files", 0) == 500 ? 1 : 0) != 0);
        conf.setInt("dfs.nfs3.stream.timeout", 6000);
        Assert.assertTrue((conf.getInt("nfs.stream.timeout", 0) == 6000 ? 1 : 0) != 0);
        conf.set("dfs.nfs3.export.point", "/dir1");
        Assert.assertTrue((boolean)conf.get("nfs.export.point").equals("/dir1"));
    }

    static {
        cluster = null;
        config = new NfsConfiguration();
        testdir = "/tmp";
    }
}

