/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3;
import org.apache.hadoop.hdfs.nfs.nfs3.RpcProgramNfs3;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.response.REMOVE3Response;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.SecurityHandler;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestClientAccessPrivilege {
    static MiniDFSCluster cluster = null;
    static NfsConfiguration config = new NfsConfiguration();
    static DistributedFileSystem hdfs;
    static NameNode nn;
    static String testdir;
    static SecurityHandler securityHandler;

    @BeforeClass
    public static void setup() throws Exception {
        String currentUser = System.getProperty("user.name");
        config.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserGroupConfKey(currentUser), "*");
        config.set(DefaultImpersonationProvider.getTestProvider().getProxySuperuserIpConfKey(currentUser), "*");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)config);
        cluster = new MiniDFSCluster.Builder((Configuration)config).numDataNodes(1).build();
        cluster.waitActive();
        hdfs = cluster.getFileSystem();
        nn = cluster.getNameNode();
        config.setInt("nfs3.mountd.port", 0);
        config.setInt("nfs3.server.port", 0);
        securityHandler = (SecurityHandler)Mockito.mock(SecurityHandler.class);
        Mockito.when((Object)securityHandler.getUser()).thenReturn((Object)System.getProperty("user.name"));
    }

    @AfterClass
    public static void shutdown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void createFiles() throws IllegalArgumentException, IOException {
        hdfs.delete(new Path(testdir), true);
        hdfs.mkdirs(new Path(testdir));
        DFSTestUtil.createFile((FileSystem)hdfs, (Path)new Path(testdir + "/f1"), (long)0L, (short)1, (long)0L);
    }

    @Test(timeout=60000L)
    public void testClientAccessPrivilegeForRemove() throws Exception {
        config.set("dfs.nfs.exports.allowed.hosts", "* ro");
        Nfs3 nfs = new Nfs3(config);
        nfs.startServiceInternal(false);
        RpcProgramNfs3 nfsd = (RpcProgramNfs3)nfs.getRpcProgram();
        HdfsFileStatus status = nn.getRpcServer().getFileInfo(testdir);
        long dirId = status.getFileId();
        XDR xdr_req = new XDR();
        FileHandle handle = new FileHandle(dirId);
        handle.serialize(xdr_req);
        xdr_req.writeString("f1");
        REMOVE3Response response = nfsd.remove(xdr_req.asReadOnlyWrap(), securityHandler, (SocketAddress)new InetSocketAddress("localhost", 1234));
        Assert.assertEquals((String)"Incorrect return code", (long)13L, (long)response.getStatus());
    }

    static {
        testdir = "/tmp";
    }
}

