/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.IOException;
import org.apache.hadoop.hdfs.nfs.nfs3.Nfs3Utils;
import org.apache.hadoop.nfs.NfsFileType;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestNfs3Utils {
    @Test
    public void testGetAccessRightsForUserGroup() throws IOException {
        Nfs3FileAttributes attr = (Nfs3FileAttributes)Mockito.mock(Nfs3FileAttributes.class);
        Mockito.when((Object)attr.getUid()).thenReturn((Object)2);
        Mockito.when((Object)attr.getGid()).thenReturn((Object)3);
        Mockito.when((Object)attr.getMode()).thenReturn((Object)448);
        Mockito.when((Object)attr.getType()).thenReturn((Object)NfsFileType.NFSREG.toValue());
        Assert.assertEquals((String)"No access should be allowed as UID does not match attribute over mode 700", (long)0L, (long)Nfs3Utils.getAccessRightsForUserGroup((int)3, (int)3, null, (Nfs3FileAttributes)attr));
        Mockito.when((Object)attr.getUid()).thenReturn((Object)2);
        Mockito.when((Object)attr.getGid()).thenReturn((Object)3);
        Mockito.when((Object)attr.getMode()).thenReturn((Object)56);
        Mockito.when((Object)attr.getType()).thenReturn((Object)NfsFileType.NFSREG.toValue());
        Assert.assertEquals((String)"No access should be allowed as GID does not match attribute over mode 070", (long)0L, (long)Nfs3Utils.getAccessRightsForUserGroup((int)2, (int)4, null, (Nfs3FileAttributes)attr));
        Mockito.when((Object)attr.getUid()).thenReturn((Object)2);
        Mockito.when((Object)attr.getGid()).thenReturn((Object)3);
        Mockito.when((Object)attr.getMode()).thenReturn((Object)7);
        Mockito.when((Object)attr.getType()).thenReturn((Object)NfsFileType.NFSREG.toValue());
        Assert.assertEquals((String)"Access should be allowed as mode is 007 and UID/GID do not match", (long)61L, (long)Nfs3Utils.getAccessRightsForUserGroup((int)1, (int)4, (int[])new int[]{5, 6}, (Nfs3FileAttributes)attr));
        Mockito.when((Object)attr.getUid()).thenReturn((Object)2);
        Mockito.when((Object)attr.getGid()).thenReturn((Object)10);
        Mockito.when((Object)attr.getMode()).thenReturn((Object)288);
        Mockito.when((Object)attr.getType()).thenReturn((Object)NfsFileType.NFSREG.toValue());
        Assert.assertEquals((String)"Access should be allowed as mode is 440 and Aux GID does match", (long)1L, (long)Nfs3Utils.getAccessRightsForUserGroup((int)3, (int)4, (int[])new int[]{5, 16, 10}, (Nfs3FileAttributes)attr));
        Mockito.when((Object)attr.getUid()).thenReturn((Object)2);
        Mockito.when((Object)attr.getGid()).thenReturn((Object)10);
        Mockito.when((Object)attr.getMode()).thenReturn((Object)448);
        Mockito.when((Object)attr.getType()).thenReturn((Object)NfsFileType.NFSDIR.toValue());
        Assert.assertEquals((String)"Access should be allowed for dir as mode is 700 and UID does match", (long)31L, (long)Nfs3Utils.getAccessRightsForUserGroup((int)2, (int)4, (int[])new int[]{5, 16, 10}, (Nfs3FileAttributes)attr));
        Assert.assertEquals((String)"No access should be allowed for dir as mode is 700 even though GID does match", (long)0L, (long)Nfs3Utils.getAccessRightsForUserGroup((int)3, (int)10, (int[])new int[]{5, 16, 4}, (Nfs3FileAttributes)attr));
        Assert.assertEquals((String)"No access should be allowed for dir as mode is 700 even though AuxGID does match", (long)0L, (long)Nfs3Utils.getAccessRightsForUserGroup((int)3, (int)20, (int[])new int[]{5, 10}, (Nfs3FileAttributes)attr));
    }
}

