/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.nfs.nfs3.Nfs3Constant;
import org.junit.Assert;
import org.junit.Test;

public class TestRpcProgramNfs3 {
    @Test(timeout=1000L)
    public void testIdempotent() {
        Object[][] procedures;
        for (Object[] procedure : procedures = new Object[][]{{Nfs3Constant.NFSPROC3.NULL, 1}, {Nfs3Constant.NFSPROC3.GETATTR, 1}, {Nfs3Constant.NFSPROC3.SETATTR, 1}, {Nfs3Constant.NFSPROC3.LOOKUP, 1}, {Nfs3Constant.NFSPROC3.ACCESS, 1}, {Nfs3Constant.NFSPROC3.READLINK, 1}, {Nfs3Constant.NFSPROC3.READ, 1}, {Nfs3Constant.NFSPROC3.WRITE, 1}, {Nfs3Constant.NFSPROC3.CREATE, 0}, {Nfs3Constant.NFSPROC3.MKDIR, 0}, {Nfs3Constant.NFSPROC3.SYMLINK, 0}, {Nfs3Constant.NFSPROC3.MKNOD, 0}, {Nfs3Constant.NFSPROC3.REMOVE, 0}, {Nfs3Constant.NFSPROC3.RMDIR, 0}, {Nfs3Constant.NFSPROC3.RENAME, 0}, {Nfs3Constant.NFSPROC3.LINK, 0}, {Nfs3Constant.NFSPROC3.READDIR, 1}, {Nfs3Constant.NFSPROC3.READDIRPLUS, 1}, {Nfs3Constant.NFSPROC3.FSSTAT, 1}, {Nfs3Constant.NFSPROC3.FSINFO, 1}, {Nfs3Constant.NFSPROC3.PATHCONF, 1}, {Nfs3Constant.NFSPROC3.COMMIT, 1}}) {
            boolean idempotent = procedure[1].equals(1);
            Nfs3Constant.NFSPROC3 proc = (Nfs3Constant.NFSPROC3)procedure[0];
            if (idempotent) {
                Assert.assertTrue((String)("Procedure " + proc + " should be idempotent"), (boolean)proc.isIdempotent());
                continue;
            }
            Assert.assertFalse((String)("Procedure " + proc + " should be non-idempotent"), (boolean)proc.isIdempotent());
        }
    }

    @Test
    public void testDeprecatedKeys() {
        NfsConfiguration conf = new NfsConfiguration();
        conf.setInt("nfs3.server.port", 998);
        Assert.assertTrue((conf.getInt("nfs.server.port", 0) == 998 ? 1 : 0) != 0);
        conf.setInt("nfs3.mountd.port", 999);
        Assert.assertTrue((conf.getInt("nfs.mountd.port", 0) == 999 ? 1 : 0) != 0);
        conf.set("dfs.nfs.exports.allowed.hosts", "host1");
        Assert.assertTrue((boolean)conf.get("nfs.exports.allowed.hosts").equals("host1"));
        conf.setInt("dfs.nfs.exports.cache.expirytime.millis", 1000);
        Assert.assertTrue((conf.getInt("nfs.exports.cache.expirytime.millis", 0) == 1000 ? 1 : 0) != 0);
        conf.setInt("hadoop.nfs.userupdate.milly", 10);
        Assert.assertTrue((conf.getInt("nfs.usergroup.update.millis", 0) == 10 ? 1 : 0) != 0);
        conf.set("dfs.nfs3.dump.dir", "/nfs/tmp");
        Assert.assertTrue((boolean)conf.get("nfs.file.dump.dir").equals("/nfs/tmp"));
        conf.setBoolean("dfs.nfs3.enableDump", false);
        Assert.assertTrue((!conf.getBoolean("nfs.file.dump", true) ? 1 : 0) != 0);
        conf.setInt("dfs.nfs3.max.open.files", 500);
        Assert.assertTrue((conf.getInt("nfs.max.open.files", 0) == 500 ? 1 : 0) != 0);
        conf.setInt("dfs.nfs3.stream.timeout", 6000);
        Assert.assertTrue((conf.getInt("nfs.stream.timeout", 0) == 6000 ? 1 : 0) != 0);
        conf.set("dfs.nfs3.export.point", "/dir1");
        Assert.assertTrue((boolean)conf.get("nfs.export.point").equals("/dir1"));
    }
}

