/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.hdfs.nfs.nfs3.OffsetRange;
import org.apache.hadoop.hdfs.nfs.nfs3.OpenFileCtx;
import org.apache.hadoop.hdfs.nfs.nfs3.OpenFileCtxCache;
import org.apache.hadoop.hdfs.nfs.nfs3.WriteCtx;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.IdUserGroup;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestOpenFileCtxCache {
    static boolean cleaned = false;

    @Test
    public void testEviction() throws IOException, InterruptedException {
        NfsConfiguration conf = new NfsConfiguration();
        conf.setInt("nfs.max.open.files", 2);
        DFSClient dfsClient = (DFSClient)Mockito.mock(DFSClient.class);
        Nfs3FileAttributes attr = new Nfs3FileAttributes();
        HdfsDataOutputStream fos = (HdfsDataOutputStream)Mockito.mock(HdfsDataOutputStream.class);
        Mockito.when((Object)fos.getPos()).thenReturn((Object)0L);
        OpenFileCtx context1 = new OpenFileCtx(fos, attr, "/dumpFilePath", dfsClient, new IdUserGroup((Configuration)new NfsConfiguration()));
        OpenFileCtx context2 = new OpenFileCtx(fos, attr, "/dumpFilePath", dfsClient, new IdUserGroup((Configuration)new NfsConfiguration()));
        OpenFileCtx context3 = new OpenFileCtx(fos, attr, "/dumpFilePath", dfsClient, new IdUserGroup((Configuration)new NfsConfiguration()));
        OpenFileCtx context4 = new OpenFileCtx(fos, attr, "/dumpFilePath", dfsClient, new IdUserGroup((Configuration)new NfsConfiguration()));
        OpenFileCtx context5 = new OpenFileCtx(fos, attr, "/dumpFilePath", dfsClient, new IdUserGroup((Configuration)new NfsConfiguration()));
        OpenFileCtxCache cache = new OpenFileCtxCache(conf, 60000L);
        boolean ret = cache.put(new FileHandle(1L), context1);
        Assert.assertTrue((boolean)ret);
        Thread.sleep(1000L);
        ret = cache.put(new FileHandle(2L), context2);
        Assert.assertTrue((boolean)ret);
        ret = cache.put(new FileHandle(3L), context3);
        Assert.assertFalse((boolean)ret);
        Assert.assertTrue((cache.size() == 2 ? 1 : 0) != 0);
        Thread.sleep(10000L);
        Assert.assertTrue((cache.size() == 2 ? 1 : 0) != 0);
        ret = cache.put(new FileHandle(3L), context3);
        Assert.assertTrue((boolean)ret);
        Assert.assertTrue((cache.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((cache.get(new FileHandle(1L)) == null ? 1 : 0) != 0);
        context3.setActiveStatusForTest(false);
        ret = cache.put(new FileHandle(4L), context4);
        Assert.assertTrue((boolean)ret);
        context2.getPendingWritesForTest().put(new OffsetRange(0L, 100L), new WriteCtx(null, 0L, 0, 0, null, null, null, 0, false, null));
        context4.getPendingCommitsForTest().put(new Long(100L), new OpenFileCtx.CommitCtx(0L, null, 0, attr));
        Thread.sleep(10000L);
        ret = cache.put(new FileHandle(5L), context5);
        Assert.assertFalse((boolean)ret);
    }

    @Test
    public void testScan() throws IOException, InterruptedException {
        NfsConfiguration conf = new NfsConfiguration();
        conf.setInt("nfs.max.open.files", 2);
        DFSClient dfsClient = (DFSClient)Mockito.mock(DFSClient.class);
        Nfs3FileAttributes attr = new Nfs3FileAttributes();
        HdfsDataOutputStream fos = (HdfsDataOutputStream)Mockito.mock(HdfsDataOutputStream.class);
        Mockito.when((Object)fos.getPos()).thenReturn((Object)0L);
        OpenFileCtx context1 = new OpenFileCtx(fos, attr, "/dumpFilePath", dfsClient, new IdUserGroup((Configuration)new NfsConfiguration()));
        OpenFileCtx context2 = new OpenFileCtx(fos, attr, "/dumpFilePath", dfsClient, new IdUserGroup((Configuration)new NfsConfiguration()));
        OpenFileCtx context3 = new OpenFileCtx(fos, attr, "/dumpFilePath", dfsClient, new IdUserGroup((Configuration)new NfsConfiguration()));
        OpenFileCtx context4 = new OpenFileCtx(fos, attr, "/dumpFilePath", dfsClient, new IdUserGroup((Configuration)new NfsConfiguration()));
        OpenFileCtxCache cache = new OpenFileCtxCache(conf, 60000L);
        boolean ret = cache.put(new FileHandle(1L), context1);
        Assert.assertTrue((boolean)ret);
        ret = cache.put(new FileHandle(2L), context2);
        Assert.assertTrue((boolean)ret);
        Thread.sleep(10001L);
        cache.scan(10000L);
        Assert.assertTrue((cache.size() == 0 ? 1 : 0) != 0);
        ret = cache.put(new FileHandle(3L), context3);
        Assert.assertTrue((boolean)ret);
        ret = cache.put(new FileHandle(4L), context4);
        Assert.assertTrue((boolean)ret);
        context3.setActiveStatusForTest(false);
        cache.scan(600000L);
        Assert.assertTrue((cache.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((cache.get(new FileHandle(3L)) == null ? 1 : 0) != 0);
        Assert.assertTrue((cache.get(new FileHandle(4L)) != null ? 1 : 0) != 0);
    }
}

