/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.service.scheduler;

import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.lib.lang.RunnableCallable;
import org.apache.hadoop.lib.server.BaseService;
import org.apache.hadoop.lib.server.Server;
import org.apache.hadoop.lib.server.ServiceException;
import org.apache.hadoop.lib.service.Instrumentation;
import org.apache.hadoop.lib.service.Scheduler;
import org.apache.hadoop.lib.service.scheduler.SchedulerService;
import org.apache.hadoop.lib.util.Check;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SchedulerService
extends BaseService
implements Scheduler {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerService.class);
    private static final String INST_GROUP = "scheduler";
    public static final String PREFIX = "scheduler";
    public static final String CONF_THREADS = "threads";
    private ScheduledExecutorService scheduler;

    public SchedulerService() {
        super("scheduler");
    }

    public void init() throws ServiceException {
        int threads = this.getServiceConfig().getInt(CONF_THREADS, 5);
        this.scheduler = new ScheduledThreadPoolExecutor(threads);
        LOG.debug("Scheduler started");
    }

    public void destroy() {
        try {
            long limit = Time.now() + 30000L;
            this.scheduler.shutdownNow();
            while (!this.scheduler.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                LOG.debug("Waiting for scheduler to shutdown");
                if (Time.now() <= limit) continue;
                LOG.warn("Gave up waiting for scheduler to shutdown");
                break;
            }
            if (this.scheduler.isTerminated()) {
                LOG.debug("Scheduler shutdown");
            }
        }
        catch (InterruptedException ex) {
            LOG.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    public Class[] getServiceDependencies() {
        return new Class[]{Instrumentation.class};
    }

    public Class getInterface() {
        return Scheduler.class;
    }

    public void schedule(Callable<?> callable, long delay, long interval, TimeUnit unit) {
        Check.notNull(callable, (String)"callable");
        if (this.scheduler.isShutdown()) {
            throw new IllegalStateException(MessageFormat.format("Scheduler shutting down, ignoring scheduling of [{}]", callable));
        }
        LOG.debug("Scheduling callable [{}], interval [{}] seconds, delay [{}] in [{}]", new Object[]{callable, delay, interval, unit});
        1 r = new /* Unavailable Anonymous Inner Class!! */;
        this.scheduler.scheduleWithFixedDelay((Runnable)r, delay, interval, unit);
    }

    public void schedule(Runnable runnable, long delay, long interval, TimeUnit unit) {
        this.schedule((Callable)new RunnableCallable(runnable), delay, interval, unit);
    }

    static /* synthetic */ Server access$000(SchedulerService x0) {
        return x0.getServer();
    }

    static /* synthetic */ Server access$100(SchedulerService x0) {
        return x0.getServer();
    }

    static /* synthetic */ Server access$200(SchedulerService x0) {
        return x0.getServer();
    }

    static /* synthetic */ Logger access$300() {
        return LOG;
    }
}

