/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.client;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.http.client.BaseTestHttpFSWith;
import org.apache.hadoop.fs.http.client.HttpFSFileSystem;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.HFSTestCase;
import org.apache.hadoop.test.HadoopUsersConfTestHelper;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.test.TestHdfs;
import org.apache.hadoop.test.TestJetty;
import org.apache.hadoop.test.TestJettyHelper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;

/*
 * Exception performing whole class analysis ignored.
 */
@RunWith(value=Parameterized.class)
public abstract class BaseTestHttpFSWith
extends HFSTestCase {
    private Operation operation;

    protected abstract Path getProxiedFSTestDir();

    protected abstract String getProxiedFSURI();

    protected abstract Configuration getProxiedFSConf();

    protected boolean isLocalFS() {
        return this.getProxiedFSURI().startsWith("file://");
    }

    private void createHttpFSServer() throws Exception {
        File homeDir = TestDirHelper.getTestDir();
        Assert.assertTrue((boolean)new File(homeDir, "conf").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "log").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "temp").mkdir());
        HttpFSServerWebApp.setHomeDirForCurrentThread((String)homeDir.getAbsolutePath());
        File secretFile = new File(new File(homeDir, "conf"), "secret");
        FileWriter w = new FileWriter(secretFile);
        w.write("secret");
        ((Writer)w).close();
        String fsDefaultName = this.getProxiedFSURI();
        Configuration conf = new Configuration(false);
        conf.set("fs.defaultFS", fsDefaultName);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        File hdfsSite = new File(new File(homeDir, "conf"), "hdfs-site.xml");
        FileOutputStream os = new FileOutputStream(hdfsSite);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        conf = new Configuration(false);
        conf.set("httpfs.proxyuser." + HadoopUsersConfTestHelper.getHadoopProxyUser() + ".groups", HadoopUsersConfTestHelper.getHadoopProxyUserGroups());
        conf.set("httpfs.proxyuser." + HadoopUsersConfTestHelper.getHadoopProxyUser() + ".hosts", HadoopUsersConfTestHelper.getHadoopProxyUserHosts());
        conf.set("httpfs.authentication.signature.secret.file", secretFile.getAbsolutePath());
        File httpfsSite = new File(new File(homeDir, "conf"), "httpfs-site.xml");
        os = new FileOutputStream(httpfsSite);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource("webapp");
        WebAppContext context = new WebAppContext(url.getPath(), "/webhdfs");
        Server server = TestJettyHelper.getJettyServer();
        server.addHandler((Handler)context);
        server.start();
    }

    protected Class getFileSystemClass() {
        return HttpFSFileSystem.class;
    }

    protected String getScheme() {
        return "webhdfs";
    }

    protected FileSystem getHttpFSFileSystem() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.webhdfs.impl", this.getFileSystemClass().getName());
        URI uri = new URI(this.getScheme() + "://" + TestJettyHelper.getJettyURL().toURI().getAuthority());
        return FileSystem.get((URI)uri, (Configuration)conf);
    }

    protected void testGet() throws Exception {
        FileSystem fs = this.getHttpFSFileSystem();
        Assert.assertNotNull((Object)fs);
        URI uri = new URI(this.getScheme() + "://" + TestJettyHelper.getJettyURL().toURI().getAuthority());
        Assert.assertEquals((Object)fs.getUri(), (Object)uri);
        fs.close();
    }

    private void testOpen() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
        FSDataOutputStream os = fs.create(path);
        os.write(1);
        os.close();
        fs.close();
        fs = this.getHttpFSFileSystem();
        FSDataInputStream is = fs.open(new Path(path.toUri().getPath()));
        Assert.assertEquals((long)is.read(), (long)1L);
        is.close();
        fs.close();
    }

    private void testCreate(Path path, boolean override) throws Exception {
        FileSystem fs = this.getHttpFSFileSystem();
        FsPermission permission = new FsPermission(FsAction.READ_WRITE, FsAction.NONE, FsAction.NONE);
        FSDataOutputStream os = fs.create(new Path(path.toUri().getPath()), permission, override, 1024, (short)2, 0x6400000L, null);
        os.write(1);
        os.close();
        fs.close();
        fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        FileStatus status = fs.getFileStatus(path);
        if (!this.isLocalFS()) {
            Assert.assertEquals((long)status.getReplication(), (long)2L);
            Assert.assertEquals((long)status.getBlockSize(), (long)0x6400000L);
        }
        Assert.assertEquals((Object)status.getPermission(), (Object)permission);
        FSDataInputStream is = fs.open(path);
        Assert.assertEquals((long)is.read(), (long)1L);
        is.close();
        fs.close();
    }

    private void testCreate() throws Exception {
        Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        fs.delete(path, true);
        this.testCreate(path, false);
        this.testCreate(path, true);
        try {
            this.testCreate(path, false);
            Assert.fail((String)"the create should have failed because the file exists and override is FALSE");
        }
        catch (IOException ex) {
            System.out.println("#");
        }
        catch (Exception ex) {
            Assert.fail((String)ex.toString());
        }
    }

    private void testAppend() throws Exception {
        if (!this.isLocalFS()) {
            FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            fs.mkdirs(this.getProxiedFSTestDir());
            Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
            FSDataOutputStream os = fs.create(path);
            os.write(1);
            os.close();
            fs.close();
            fs = this.getHttpFSFileSystem();
            os = fs.append(new Path(path.toUri().getPath()));
            os.write(2);
            os.close();
            fs.close();
            fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            FSDataInputStream is = fs.open(path);
            Assert.assertEquals((long)is.read(), (long)1L);
            Assert.assertEquals((long)is.read(), (long)2L);
            Assert.assertEquals((long)is.read(), (long)-1L);
            is.close();
            fs.close();
        }
    }

    private void testTruncate() throws Exception {
        if (!this.isLocalFS()) {
            int repl = 3;
            int blockSize = 1024;
            int numOfBlocks = 2;
            FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            fs.mkdirs(this.getProxiedFSTestDir());
            Path file = new Path(this.getProxiedFSTestDir(), "foo.txt");
            byte[] data = FileSystemTestHelper.getFileData((int)2, (long)1024L);
            FileSystemTestHelper.createFile((FileSystem)fs, (Path)file, (byte[])data, (int)1024, (short)3);
            int newLength = 1024;
            boolean isReady = fs.truncate(file, 1024L);
            Assert.assertTrue((String)"Recovery is not expected.", (boolean)isReady);
            FileStatus fileStatus = fs.getFileStatus(file);
            Assert.assertEquals((long)fileStatus.getLen(), (long)1024L);
            AppendTestUtil.checkFullFile((FileSystem)fs, (Path)file, (int)1024, (byte[])data, (String)file.toString());
            fs.close();
        }
    }

    private void testConcat() throws Exception {
        Configuration config = this.getProxiedFSConf();
        config.setLong("dfs.blocksize", 1024L);
        if (!this.isLocalFS()) {
            FileSystem fs = FileSystem.get((Configuration)config);
            fs.mkdirs(this.getProxiedFSTestDir());
            Path path1 = new Path("/test/foo.txt");
            Path path2 = new Path("/test/bar.txt");
            Path path3 = new Path("/test/derp.txt");
            DFSTestUtil.createFile((FileSystem)fs, (Path)path1, (long)1024L, (short)3, (long)0L);
            DFSTestUtil.createFile((FileSystem)fs, (Path)path2, (long)1024L, (short)3, (long)0L);
            DFSTestUtil.createFile((FileSystem)fs, (Path)path3, (long)1024L, (short)3, (long)0L);
            fs.close();
            fs = this.getHttpFSFileSystem();
            fs.concat(path1, new Path[]{path2, path3});
            fs.close();
            fs = FileSystem.get((Configuration)config);
            Assert.assertTrue((boolean)fs.exists(path1));
            Assert.assertFalse((boolean)fs.exists(path2));
            Assert.assertFalse((boolean)fs.exists(path3));
            fs.close();
        }
    }

    private void testRename() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Path path = new Path(this.getProxiedFSTestDir(), "foo");
        fs.mkdirs(path);
        fs.close();
        fs = this.getHttpFSFileSystem();
        Path oldPath = new Path(path.toUri().getPath());
        Path newPath = new Path(path.getParent(), "bar");
        fs.rename(oldPath, newPath);
        fs.close();
        fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Assert.assertFalse((boolean)fs.exists(oldPath));
        Assert.assertTrue((boolean)fs.exists(newPath));
        fs.close();
    }

    private void testDelete() throws Exception {
        Path foo = new Path(this.getProxiedFSTestDir(), "foo");
        Path bar = new Path(this.getProxiedFSTestDir(), "bar");
        Path foe = new Path(this.getProxiedFSTestDir(), "foe");
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        fs.mkdirs(foo);
        fs.mkdirs(new Path(bar, "a"));
        fs.mkdirs(foe);
        FileSystem hoopFs = this.getHttpFSFileSystem();
        Assert.assertTrue((boolean)hoopFs.delete(new Path(foo.toUri().getPath()), false));
        Assert.assertFalse((boolean)fs.exists(foo));
        try {
            hoopFs.delete(new Path(bar.toUri().getPath()), false);
            Assert.fail();
        }
        catch (IOException ex) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
        Assert.assertTrue((boolean)fs.exists(bar));
        Assert.assertTrue((boolean)hoopFs.delete(new Path(bar.toUri().getPath()), true));
        Assert.assertFalse((boolean)fs.exists(bar));
        Assert.assertTrue((boolean)fs.exists(foe));
        Assert.assertTrue((boolean)hoopFs.delete(foe, true));
        Assert.assertFalse((boolean)fs.exists(foe));
        hoopFs.close();
        fs.close();
    }

    private void testListStatus() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
        FSDataOutputStream os = fs.create(path);
        os.write(1);
        os.close();
        FileStatus status1 = fs.getFileStatus(path);
        fs.close();
        fs = this.getHttpFSFileSystem();
        FileStatus status2 = fs.getFileStatus(new Path(path.toUri().getPath()));
        fs.close();
        Assert.assertEquals((Object)status2.getPermission(), (Object)status1.getPermission());
        Assert.assertEquals((Object)status2.getPath().toUri().getPath(), (Object)status1.getPath().toUri().getPath());
        Assert.assertEquals((long)status2.getReplication(), (long)status1.getReplication());
        Assert.assertEquals((long)status2.getBlockSize(), (long)status1.getBlockSize());
        Assert.assertEquals((long)status2.getAccessTime(), (long)status1.getAccessTime());
        Assert.assertEquals((long)status2.getModificationTime(), (long)status1.getModificationTime());
        Assert.assertEquals((Object)status2.getOwner(), (Object)status1.getOwner());
        Assert.assertEquals((Object)status2.getGroup(), (Object)status1.getGroup());
        Assert.assertEquals((long)status2.getLen(), (long)status1.getLen());
        FileStatus[] stati = fs.listStatus(path.getParent());
        Assert.assertEquals((long)stati.length, (long)1L);
        Assert.assertEquals((Object)stati[0].getPath().getName(), (Object)path.getName());
    }

    private void testWorkingdirectory() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Path workingDir = fs.getWorkingDirectory();
        fs.close();
        fs = this.getHttpFSFileSystem();
        if (this.isLocalFS()) {
            fs.setWorkingDirectory(workingDir);
        }
        Path httpFSWorkingDir = fs.getWorkingDirectory();
        fs.close();
        Assert.assertEquals((Object)httpFSWorkingDir.toUri().getPath(), (Object)workingDir.toUri().getPath());
        fs = this.getHttpFSFileSystem();
        fs.setWorkingDirectory(new Path("/tmp"));
        workingDir = fs.getWorkingDirectory();
        fs.close();
        Assert.assertEquals((Object)workingDir.toUri().getPath(), (Object)new Path("/tmp").toUri().getPath());
    }

    private void testMkdirs() throws Exception {
        Path path = new Path(this.getProxiedFSTestDir(), "foo");
        FileSystem fs = this.getHttpFSFileSystem();
        fs.mkdirs(path);
        fs.close();
        fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Assert.assertTrue((boolean)fs.exists(path));
        fs.close();
    }

    private void testSetTimes() throws Exception {
        if (!this.isLocalFS()) {
            FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
            FSDataOutputStream os = fs.create(path);
            os.write(1);
            os.close();
            FileStatus status1 = fs.getFileStatus(path);
            fs.close();
            long at = status1.getAccessTime();
            long mt = status1.getModificationTime();
            fs = this.getHttpFSFileSystem();
            fs.setTimes(path, mt - 10L, at - 20L);
            fs.close();
            fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            status1 = fs.getFileStatus(path);
            fs.close();
            long atNew = status1.getAccessTime();
            long mtNew = status1.getModificationTime();
            Assert.assertEquals((long)mtNew, (long)(mt - 10L));
            Assert.assertEquals((long)atNew, (long)(at - 20L));
        }
    }

    protected void testSetPermission() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Path path = new Path(this.getProxiedFSTestDir(), "foodir");
        fs.mkdirs(path);
        fs = this.getHttpFSFileSystem();
        FsPermission permission1 = new FsPermission(FsAction.READ_WRITE, FsAction.NONE, FsAction.NONE);
        fs.setPermission(path, permission1);
        fs.close();
        fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        FileStatus status1 = fs.getFileStatus(path);
        fs.close();
        FsPermission permission2 = status1.getPermission();
        Assert.assertEquals((Object)permission2, (Object)permission1);
        fs = this.getHttpFSFileSystem();
        permission1 = new FsPermission(FsAction.READ_WRITE, FsAction.NONE, FsAction.NONE, true);
        fs.setPermission(path, permission1);
        fs.close();
        fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        status1 = fs.getFileStatus(path);
        fs.close();
        permission2 = status1.getPermission();
        Assert.assertTrue((boolean)permission2.getStickyBit());
        Assert.assertEquals((Object)permission2, (Object)permission1);
    }

    private void testSetOwner() throws Exception {
        if (!this.isLocalFS()) {
            FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            fs.mkdirs(this.getProxiedFSTestDir());
            Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
            FSDataOutputStream os = fs.create(path);
            os.write(1);
            os.close();
            fs.close();
            fs = this.getHttpFSFileSystem();
            String user = HadoopUsersConfTestHelper.getHadoopUsers()[1];
            String group = HadoopUsersConfTestHelper.getHadoopUserGroups((String)user)[0];
            fs.setOwner(path, user, group);
            fs.close();
            fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            FileStatus status1 = fs.getFileStatus(path);
            fs.close();
            Assert.assertEquals((Object)status1.getOwner(), (Object)user);
            Assert.assertEquals((Object)status1.getGroup(), (Object)group);
        }
    }

    private void testSetReplication() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
        FSDataOutputStream os = fs.create(path);
        os.write(1);
        os.close();
        fs.close();
        fs.setReplication(path, (short)2);
        fs = this.getHttpFSFileSystem();
        fs.setReplication(path, (short)1);
        fs.close();
        fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        FileStatus status1 = fs.getFileStatus(path);
        fs.close();
        Assert.assertEquals((long)status1.getReplication(), (long)1L);
    }

    private void testChecksum() throws Exception {
        if (!this.isLocalFS()) {
            FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            fs.mkdirs(this.getProxiedFSTestDir());
            Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
            FSDataOutputStream os = fs.create(path);
            os.write(1);
            os.close();
            FileChecksum hdfsChecksum = fs.getFileChecksum(path);
            fs.close();
            fs = this.getHttpFSFileSystem();
            FileChecksum httpChecksum = fs.getFileChecksum(path);
            fs.close();
            Assert.assertEquals((Object)httpChecksum.getAlgorithmName(), (Object)hdfsChecksum.getAlgorithmName());
            Assert.assertEquals((long)httpChecksum.getLength(), (long)hdfsChecksum.getLength());
            Assert.assertArrayEquals((byte[])httpChecksum.getBytes(), (byte[])hdfsChecksum.getBytes());
        }
    }

    private void testContentSummary() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
        FSDataOutputStream os = fs.create(path);
        os.write(1);
        os.close();
        ContentSummary hdfsContentSummary = fs.getContentSummary(path);
        fs.close();
        fs = this.getHttpFSFileSystem();
        ContentSummary httpContentSummary = fs.getContentSummary(path);
        fs.close();
        Assert.assertEquals((long)httpContentSummary.getDirectoryCount(), (long)hdfsContentSummary.getDirectoryCount());
        Assert.assertEquals((long)httpContentSummary.getFileCount(), (long)hdfsContentSummary.getFileCount());
        Assert.assertEquals((long)httpContentSummary.getLength(), (long)hdfsContentSummary.getLength());
        Assert.assertEquals((long)httpContentSummary.getQuota(), (long)hdfsContentSummary.getQuota());
        Assert.assertEquals((long)httpContentSummary.getSpaceConsumed(), (long)hdfsContentSummary.getSpaceConsumed());
        Assert.assertEquals((long)httpContentSummary.getSpaceQuota(), (long)hdfsContentSummary.getSpaceQuota());
    }

    private void testSetXAttr() throws Exception {
        if (!this.isLocalFS()) {
            FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            fs.mkdirs(this.getProxiedFSTestDir());
            Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
            FSDataOutputStream os = fs.create(path);
            os.write(1);
            os.close();
            fs.close();
            String name1 = "user.a1";
            byte[] value1 = new byte[]{49, 50, 51};
            String name2 = "user.a2";
            byte[] value2 = new byte[]{65, 66, 67};
            String name3 = "user.a3";
            byte[] value3 = null;
            String name4 = "trusted.a1";
            byte[] value4 = new byte[]{49, 50, 51};
            String name5 = "a1";
            fs = this.getHttpFSFileSystem();
            fs.setXAttr(path, "user.a1", value1);
            fs.setXAttr(path, "user.a2", value2);
            fs.setXAttr(path, "user.a3", value3);
            fs.setXAttr(path, "trusted.a1", value4);
            try {
                fs.setXAttr(path, "a1", value1);
                Assert.fail((String)"Set xAttr with incorrect name format should fail.");
            }
            catch (IOException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            fs.close();
            fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            Map xAttrs = fs.getXAttrs(path);
            fs.close();
            Assert.assertEquals((long)4L, (long)xAttrs.size());
            Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xAttrs.get("user.a1")));
            Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xAttrs.get("user.a2")));
            Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xAttrs.get("user.a3")));
            Assert.assertArrayEquals((byte[])value4, (byte[])((byte[])xAttrs.get("trusted.a1")));
        }
    }

    private void testGetXAttrs() throws Exception {
        if (!this.isLocalFS()) {
            FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            fs.mkdirs(this.getProxiedFSTestDir());
            Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
            FSDataOutputStream os = fs.create(path);
            os.write(1);
            os.close();
            fs.close();
            String name1 = "user.a1";
            byte[] value1 = new byte[]{49, 50, 51};
            String name2 = "user.a2";
            byte[] value2 = new byte[]{65, 66, 67};
            String name3 = "user.a3";
            byte[] value3 = null;
            String name4 = "trusted.a1";
            byte[] value4 = new byte[]{49, 50, 51};
            fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            fs.setXAttr(path, "user.a1", value1);
            fs.setXAttr(path, "user.a2", value2);
            fs.setXAttr(path, "user.a3", value3);
            fs.setXAttr(path, "trusted.a1", value4);
            fs.close();
            fs = this.getHttpFSFileSystem();
            ArrayList names = Lists.newArrayList();
            names.add("user.a1");
            names.add("user.a2");
            names.add("user.a3");
            names.add("trusted.a1");
            Map xAttrs = fs.getXAttrs(path, (List)names);
            fs.close();
            Assert.assertEquals((long)4L, (long)xAttrs.size());
            Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xAttrs.get("user.a1")));
            Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xAttrs.get("user.a2")));
            Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xAttrs.get("user.a3")));
            Assert.assertArrayEquals((byte[])value4, (byte[])((byte[])xAttrs.get("trusted.a1")));
            fs = this.getHttpFSFileSystem();
            byte[] value = fs.getXAttr(path, "user.a1");
            Assert.assertArrayEquals((byte[])value1, (byte[])value);
            String name5 = "a1";
            try {
                value = fs.getXAttr(path, "a1");
                Assert.fail((String)"Get xAttr with incorrect name format should fail.");
            }
            catch (IOException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            fs.close();
            fs = this.getHttpFSFileSystem();
            xAttrs = fs.getXAttrs(path);
            fs.close();
            Assert.assertEquals((long)4L, (long)xAttrs.size());
            Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xAttrs.get("user.a1")));
            Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xAttrs.get("user.a2")));
            Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xAttrs.get("user.a3")));
            Assert.assertArrayEquals((byte[])value4, (byte[])((byte[])xAttrs.get("trusted.a1")));
        }
    }

    private void testRemoveXAttr() throws Exception {
        if (!this.isLocalFS()) {
            FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            fs.mkdirs(this.getProxiedFSTestDir());
            Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
            FSDataOutputStream os = fs.create(path);
            os.write(1);
            os.close();
            fs.close();
            String name1 = "user.a1";
            byte[] value1 = new byte[]{49, 50, 51};
            String name2 = "user.a2";
            byte[] value2 = new byte[]{65, 66, 67};
            String name3 = "user.a3";
            byte[] value3 = null;
            String name4 = "trusted.a1";
            byte[] value4 = new byte[]{49, 50, 51};
            String name5 = "a1";
            fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            fs.setXAttr(path, "user.a1", value1);
            fs.setXAttr(path, "user.a2", value2);
            fs.setXAttr(path, "user.a3", value3);
            fs.setXAttr(path, "trusted.a1", value4);
            fs.close();
            fs = this.getHttpFSFileSystem();
            fs.removeXAttr(path, "user.a1");
            fs.removeXAttr(path, "user.a3");
            fs.removeXAttr(path, "trusted.a1");
            try {
                fs.removeXAttr(path, "a1");
                Assert.fail((String)"Remove xAttr with incorrect name format should fail.");
            }
            catch (IOException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            Map xAttrs = fs.getXAttrs(path);
            fs.close();
            Assert.assertEquals((long)1L, (long)xAttrs.size());
            Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xAttrs.get("user.a2")));
        }
    }

    private void testListXAttrs() throws Exception {
        if (!this.isLocalFS()) {
            FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            fs.mkdirs(this.getProxiedFSTestDir());
            Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
            FSDataOutputStream os = fs.create(path);
            os.write(1);
            os.close();
            fs.close();
            String name1 = "user.a1";
            byte[] value1 = new byte[]{49, 50, 51};
            String name2 = "user.a2";
            byte[] value2 = new byte[]{65, 66, 67};
            String name3 = "user.a3";
            byte[] value3 = null;
            String name4 = "trusted.a1";
            byte[] value4 = new byte[]{49, 50, 51};
            fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            fs.setXAttr(path, "user.a1", value1);
            fs.setXAttr(path, "user.a2", value2);
            fs.setXAttr(path, "user.a3", value3);
            fs.setXAttr(path, "trusted.a1", value4);
            fs.close();
            fs = this.getHttpFSFileSystem();
            List names = fs.listXAttrs(path);
            Assert.assertEquals((long)4L, (long)names.size());
            Assert.assertTrue((boolean)names.contains("user.a1"));
            Assert.assertTrue((boolean)names.contains("user.a2"));
            Assert.assertTrue((boolean)names.contains("user.a3"));
            Assert.assertTrue((boolean)names.contains("trusted.a1"));
        }
    }

    private void assertSameAcls(AclStatus a, AclStatus b) throws Exception {
        Assert.assertTrue((boolean)a.getOwner().equals(b.getOwner()));
        Assert.assertTrue((boolean)a.getGroup().equals(b.getGroup()));
        Assert.assertTrue((a.isStickyBit() == b.isStickyBit() ? 1 : 0) != 0);
        Assert.assertTrue((a.getEntries().size() == b.getEntries().size() ? 1 : 0) != 0);
        for (AclEntry e : a.getEntries()) {
            Assert.assertTrue((boolean)b.getEntries().contains(e));
        }
        for (AclEntry e : b.getEntries()) {
            Assert.assertTrue((boolean)a.getEntries().contains(e));
        }
    }

    private void testFileAcls() throws Exception {
        if (this.isLocalFS()) {
            return;
        }
        String aclUser1 = "user:foo:rw-";
        String aclUser2 = "user:bar:r--";
        String aclGroup1 = "group::r--";
        String aclSet = "user::rwx,user:foo:rw-,group::r--,other::---";
        FileSystem proxyFs = FileSystem.get((Configuration)this.getProxiedFSConf());
        FileSystem httpfs = this.getHttpFSFileSystem();
        Path path = new Path(this.getProxiedFSTestDir(), "testAclStatus.txt");
        FSDataOutputStream os = proxyFs.create(path);
        os.write(1);
        os.close();
        AclStatus proxyAclStat = proxyFs.getAclStatus(path);
        AclStatus httpfsAclStat = httpfs.getAclStatus(path);
        this.assertSameAcls(httpfsAclStat, proxyAclStat);
        httpfs.setAcl(path, AclEntry.parseAclSpec((String)"user::rwx,user:foo:rw-,group::r--,other::---", (boolean)true));
        proxyAclStat = proxyFs.getAclStatus(path);
        httpfsAclStat = httpfs.getAclStatus(path);
        this.assertSameAcls(httpfsAclStat, proxyAclStat);
        httpfs.modifyAclEntries(path, AclEntry.parseAclSpec((String)"user:bar:r--", (boolean)true));
        proxyAclStat = proxyFs.getAclStatus(path);
        httpfsAclStat = httpfs.getAclStatus(path);
        this.assertSameAcls(httpfsAclStat, proxyAclStat);
        httpfs.removeAclEntries(path, AclEntry.parseAclSpec((String)"user:foo:rw-", (boolean)true));
        proxyAclStat = proxyFs.getAclStatus(path);
        httpfsAclStat = httpfs.getAclStatus(path);
        this.assertSameAcls(httpfsAclStat, proxyAclStat);
        httpfs.removeAcl(path);
        proxyAclStat = proxyFs.getAclStatus(path);
        httpfsAclStat = httpfs.getAclStatus(path);
        this.assertSameAcls(httpfsAclStat, proxyAclStat);
    }

    private void testDirAcls() throws Exception {
        if (this.isLocalFS()) {
            return;
        }
        String defUser1 = "default:user:glarch:r-x";
        FileSystem proxyFs = FileSystem.get((Configuration)this.getProxiedFSConf());
        FileSystem httpfs = this.getHttpFSFileSystem();
        Path dir = this.getProxiedFSTestDir();
        AclStatus proxyAclStat = proxyFs.getAclStatus(dir);
        AclStatus httpfsAclStat = httpfs.getAclStatus(dir);
        this.assertSameAcls(httpfsAclStat, proxyAclStat);
        httpfs.setAcl(dir, AclEntry.parseAclSpec((String)"default:user:glarch:r-x", (boolean)true));
        proxyAclStat = proxyFs.getAclStatus(dir);
        httpfsAclStat = httpfs.getAclStatus(dir);
        this.assertSameAcls(httpfsAclStat, proxyAclStat);
        httpfs.removeDefaultAcl(dir);
        proxyAclStat = proxyFs.getAclStatus(dir);
        httpfsAclStat = httpfs.getAclStatus(dir);
        this.assertSameAcls(httpfsAclStat, proxyAclStat);
    }

    private void operation(Operation op) throws Exception {
        switch (2.$SwitchMap$org$apache$hadoop$fs$http$client$BaseTestHttpFSWith$Operation[op.ordinal()]) {
            case 1: {
                this.testGet();
                break;
            }
            case 2: {
                this.testOpen();
                break;
            }
            case 3: {
                this.testCreate();
                break;
            }
            case 4: {
                this.testAppend();
                break;
            }
            case 5: {
                this.testTruncate();
                break;
            }
            case 6: {
                this.testConcat();
                break;
            }
            case 7: {
                this.testRename();
                break;
            }
            case 8: {
                this.testDelete();
                break;
            }
            case 9: {
                this.testListStatus();
                break;
            }
            case 10: {
                this.testWorkingdirectory();
                break;
            }
            case 11: {
                this.testMkdirs();
                break;
            }
            case 12: {
                this.testSetTimes();
                break;
            }
            case 13: {
                this.testSetPermission();
                break;
            }
            case 14: {
                this.testSetOwner();
                break;
            }
            case 15: {
                this.testSetReplication();
                break;
            }
            case 16: {
                this.testChecksum();
                break;
            }
            case 17: {
                this.testContentSummary();
                break;
            }
            case 18: {
                this.testFileAcls();
                break;
            }
            case 19: {
                this.testDirAcls();
                break;
            }
            case 20: {
                this.testSetXAttr();
                break;
            }
            case 21: {
                this.testRemoveXAttr();
                break;
            }
            case 22: {
                this.testGetXAttrs();
                break;
            }
            case 23: {
                this.testListXAttrs();
            }
        }
    }

    @Parameterized.Parameters
    public static Collection operations() {
        Object[][] ops = new Object[Operation.values().length][];
        for (int i = 0; i < Operation.values().length; ++i) {
            ops[i] = new Object[]{Operation.values()[i]};
        }
        return Arrays.asList(ops);
    }

    public BaseTestHttpFSWith(Operation operation) {
        this.operation = operation;
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testOperation() throws Exception {
        this.createHttpFSServer();
        this.operation(this.operation);
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testOperationDoAs() throws Exception {
        this.createHttpFSServer();
        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)HadoopUsersConfTestHelper.getHadoopUsers()[0], (UserGroupInformation)UserGroupInformation.getCurrentUser());
        ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Operation access$000(BaseTestHttpFSWith x0) {
        return x0.operation;
    }

    static /* synthetic */ void access$100(BaseTestHttpFSWith x0, Operation x1) throws Exception {
        x0.operation(x1);
    }
}

