/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.wsrs;

import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.lib.wsrs.Param;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public abstract class EnumParam<E extends Enum<E>>
extends Param<E> {
    Class<E> klass;

    public EnumParam(String name, Class<E> e, E defaultValue) {
        super(name, defaultValue);
        this.klass = e;
    }

    protected E parse(String str) throws Exception {
        return (E)Enum.valueOf(this.klass, str.toUpperCase());
    }

    protected String getDomain() {
        return StringUtils.join((CharSequence)",", Arrays.asList(this.klass.getEnumConstants()));
    }
}

