/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.wsrs;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import java.security.Principal;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.lib.wsrs.UserProvider;
import org.apache.hadoop.test.TestException;
import org.apache.hadoop.test.TestExceptionHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;
import org.mockito.Mockito;
import org.slf4j.MDC;

public class TestUserProvider {
    @Rule
    public MethodRule exceptionHelper = new TestExceptionHelper();

    @Test
    public void noUser() {
        MDC.remove((String)"user");
        HttpRequestContext request = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        Mockito.when((Object)request.getUserPrincipal()).thenReturn(null);
        MultivaluedMap map = (MultivaluedMap)Mockito.mock(MultivaluedMap.class);
        Mockito.when((Object)map.getFirst((Object)"user.name")).thenReturn(null);
        Mockito.when((Object)request.getQueryParameters()).thenReturn((Object)map);
        HttpContext context = (HttpContext)Mockito.mock(HttpContext.class);
        Mockito.when((Object)context.getRequest()).thenReturn((Object)request);
        UserProvider up = new UserProvider();
        Assert.assertNull((Object)up.getValue(context));
        Assert.assertNull((Object)MDC.get((String)"user"));
    }

    @Test
    public void queryStringUser() {
        MDC.remove((String)"user");
        HttpRequestContext request = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        Mockito.when((Object)request.getUserPrincipal()).thenReturn(null);
        MultivaluedMap map = (MultivaluedMap)Mockito.mock(MultivaluedMap.class);
        Mockito.when((Object)map.getFirst((Object)"user.name")).thenReturn((Object)"foo");
        Mockito.when((Object)request.getQueryParameters()).thenReturn((Object)map);
        HttpContext context = (HttpContext)Mockito.mock(HttpContext.class);
        Mockito.when((Object)context.getRequest()).thenReturn((Object)request);
        UserProvider up = new UserProvider();
        Assert.assertEquals((Object)up.getValue(context).getName(), (Object)"foo");
        Assert.assertEquals((Object)MDC.get((String)"user"), (Object)"foo");
    }

    @Test
    public void principalUser() {
        MDC.remove((String)"user");
        HttpRequestContext request = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        Mockito.when((Object)request.getUserPrincipal()).thenReturn((Object)new /* Unavailable Anonymous Inner Class!! */);
        HttpContext context = (HttpContext)Mockito.mock(HttpContext.class);
        Mockito.when((Object)context.getRequest()).thenReturn((Object)request);
        UserProvider up = new UserProvider();
        Assert.assertEquals((Object)up.getValue(context).getName(), (Object)"bar");
        Assert.assertEquals((Object)MDC.get((String)"user"), (Object)"bar");
    }

    @Test
    public void getters() {
        UserProvider up = new UserProvider();
        Assert.assertEquals((Object)up.getScope(), (Object)ComponentScope.PerRequest);
        Assert.assertEquals((Object)up.getInjectable(null, null, Principal.class), (Object)up);
        Assert.assertNull((Object)up.getInjectable(null, null, String.class));
    }

    @Test
    @TestException(exception=IllegalArgumentException.class)
    public void userNameEmpty() {
        new UserProvider.UserParam("");
    }

    @Test
    @TestException(exception=IllegalArgumentException.class)
    public void userNameInvalidStart() {
        new UserProvider.UserParam("1x");
    }

    @Test
    @TestException(exception=IllegalArgumentException.class)
    public void userNameInvalidDollarSign() {
        new UserProvider.UserParam("1$x");
    }

    @Test
    public void userNameMinLength() {
        new UserProvider.UserParam("a");
    }

    @Test
    public void userNameValidDollarSign() {
        new UserProvider.UserParam("a$");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void customUserPattern() {
        try {
            UserProvider.setUserPattern((String)"1");
            new UserProvider.UserParam("1");
        }
        finally {
            UserProvider.setUserPattern((String)"^[A-Za-z_][A-Za-z0-9._-]*[$]?$");
        }
    }
}

