/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.http.server.HttpFSKerberosAuthenticationHandlerForTesting;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.fs.http.server.TestHttpFSServer;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.test.HFSTestCase;
import org.apache.hadoop.test.HadoopUsersConfTestHelper;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.test.TestHdfs;
import org.apache.hadoop.test.TestHdfsHelper;
import org.apache.hadoop.test.TestJetty;
import org.apache.hadoop.test.TestJettyHelper;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestHttpFSServer
extends HFSTestCase {
    @Test
    @TestDir
    @TestJetty
    public void server() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration httpfsConf = new Configuration(false);
        HttpFSServerWebApp server = new HttpFSServerWebApp(dir, dir, dir, dir, httpfsConf);
        server.init();
        server.destroy();
    }

    private void createHttpFSServer(boolean addDelegationTokenAuthHandler) throws Exception {
        File homeDir = TestDirHelper.getTestDir();
        Assert.assertTrue((boolean)new File(homeDir, "conf").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "log").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "temp").mkdir());
        HttpFSServerWebApp.setHomeDirForCurrentThread((String)homeDir.getAbsolutePath());
        File secretFile = new File(new File(homeDir, "conf"), "secret");
        FileWriter w = new FileWriter(secretFile);
        w.write("secret");
        ((Writer)w).close();
        File hadoopConfDir = new File(new File(homeDir, "conf"), "hadoop-conf");
        hadoopConfDir.mkdirs();
        String fsDefaultName = TestHdfsHelper.getHdfsConf().get("fs.defaultFS");
        Configuration conf = new Configuration(false);
        conf.set("fs.defaultFS", fsDefaultName);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        File hdfsSite = new File(hadoopConfDir, "hdfs-site.xml");
        FileOutputStream os = new FileOutputStream(hdfsSite);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        conf = new Configuration(false);
        if (addDelegationTokenAuthHandler) {
            conf.set("httpfs.authentication.type", HttpFSKerberosAuthenticationHandlerForTesting.class.getName());
        }
        conf.set("httpfs.services.ext", MockGroups.class.getName());
        conf.set("httpfs.admin.group", HadoopUsersConfTestHelper.getHadoopUserGroups((String)HadoopUsersConfTestHelper.getHadoopUsers()[0])[0]);
        conf.set("httpfs.proxyuser." + HadoopUsersConfTestHelper.getHadoopProxyUser() + ".groups", HadoopUsersConfTestHelper.getHadoopProxyUserGroups());
        conf.set("httpfs.proxyuser." + HadoopUsersConfTestHelper.getHadoopProxyUser() + ".hosts", HadoopUsersConfTestHelper.getHadoopProxyUserHosts());
        conf.set("httpfs.authentication.signature.secret.file", secretFile.getAbsolutePath());
        conf.set("httpfs.hadoop.config.dir", hadoopConfDir.toString());
        File httpfsSite = new File(new File(homeDir, "conf"), "httpfs-site.xml");
        os = new FileOutputStream(httpfsSite);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource("webapp");
        WebAppContext context = new WebAppContext(url.getPath(), "/webhdfs");
        Server server = TestJettyHelper.getJettyServer();
        server.addHandler((Handler)context);
        server.start();
        if (addDelegationTokenAuthHandler) {
            HttpFSServerWebApp.get().setAuthority(TestJettyHelper.getAuthority());
        }
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void instrumentation() throws Exception {
        this.createHttpFSServer(false);
        URL url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1?user.name={0}&op=instrumentation", "nobody"));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)conn.getResponseCode(), (long)401L);
        url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1?user.name={0}&op=instrumentation", HadoopUsersConfTestHelper.getHadoopUsers()[0]));
        conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)conn.getResponseCode(), (long)200L);
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String line = reader.readLine();
        reader.close();
        Assert.assertTrue((boolean)line.contains("\"counters\":{"));
        url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1/foo?user.name={0}&op=instrumentation", HadoopUsersConfTestHelper.getHadoopUsers()[0]));
        conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)conn.getResponseCode(), (long)400L);
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testHdfsAccess() throws Exception {
        this.createHttpFSServer(false);
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        URL url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1/?user.name={0}&op=liststatus", user));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)conn.getResponseCode(), (long)200L);
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        reader.readLine();
        reader.close();
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testGlobFilter() throws Exception {
        this.createHttpFSServer(false);
        FileSystem fs = FileSystem.get((Configuration)TestHdfsHelper.getHdfsConf());
        fs.mkdirs(new Path("/tmp"));
        fs.create(new Path("/tmp/foo.txt")).close();
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        URL url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1/tmp?user.name={0}&op=liststatus&filter=f*", user));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)conn.getResponseCode(), (long)200L);
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        reader.readLine();
        reader.close();
    }

    private void createWithHttp(String filename, String perms) throws Exception {
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        if (filename.charAt(0) == '/') {
            filename = filename.substring(1);
        }
        String pathOps = perms == null ? MessageFormat.format("/webhdfs/v1/{0}?user.name={1}&op=CREATE", filename, user) : MessageFormat.format("/webhdfs/v1/{0}?user.name={1}&permission={2}&op=CREATE", filename, user, perms);
        URL url = new URL(TestJettyHelper.getJettyURL(), pathOps);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.addRequestProperty("Content-Type", "application/octet-stream");
        conn.setRequestMethod("PUT");
        conn.connect();
        Assert.assertEquals((long)201L, (long)conn.getResponseCode());
    }

    private String getStatus(String filename, String command) throws Exception {
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        if (filename.charAt(0) == '/') {
            filename = filename.substring(1);
        }
        String pathOps = MessageFormat.format("/webhdfs/v1/{0}?user.name={1}&op={2}", filename, user, command);
        URL url = new URL(TestJettyHelper.getJettyURL(), pathOps);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        return reader.readLine();
    }

    private void putCmd(String filename, String command, String params) throws Exception {
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        if (filename.charAt(0) == '/') {
            filename = filename.substring(1);
        }
        String pathOps = MessageFormat.format("/webhdfs/v1/{0}?user.name={1}{2}{3}&op={4}", filename, user, params == null ? "" : "&", params == null ? "" : params, command);
        URL url = new URL(TestJettyHelper.getJettyURL(), pathOps);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("PUT");
        conn.connect();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
    }

    private String getPerms(String statusJson) throws Exception {
        JSONParser parser = new JSONParser();
        JSONObject jsonObject = (JSONObject)parser.parse(statusJson);
        JSONObject details = (JSONObject)jsonObject.get((Object)"FileStatus");
        return (String)details.get((Object)"permission");
    }

    private List<String> getAclEntries(String statusJson) throws Exception {
        ArrayList<String> entries = new ArrayList<String>();
        JSONParser parser = new JSONParser();
        JSONObject jsonObject = (JSONObject)parser.parse(statusJson);
        JSONObject details = (JSONObject)jsonObject.get((Object)"AclStatus");
        JSONArray jsonEntries = (JSONArray)details.get((Object)"entries");
        if (jsonEntries != null) {
            for (Object e : jsonEntries) {
                entries.add(e.toString());
            }
        }
        return entries;
    }

    private Map<String, byte[]> getXAttrs(String statusJson) throws Exception {
        HashMap xAttrs = Maps.newHashMap();
        JSONParser parser = new JSONParser();
        JSONObject jsonObject = (JSONObject)parser.parse(statusJson);
        JSONArray jsonXAttrs = (JSONArray)jsonObject.get((Object)"XAttrs");
        if (jsonXAttrs != null) {
            for (Object a : jsonXAttrs) {
                String name = (String)((JSONObject)a).get((Object)"name");
                String value = (String)((JSONObject)a).get((Object)"value");
                xAttrs.put(name, this.decodeXAttrValue(value));
            }
        }
        return xAttrs;
    }

    private byte[] decodeXAttrValue(String value) throws IOException {
        if (value != null) {
            return XAttrCodec.decodeValue((String)value);
        }
        return new byte[0];
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testPerms() throws Exception {
        this.createHttpFSServer(false);
        FileSystem fs = FileSystem.get((Configuration)TestHdfsHelper.getHdfsConf());
        fs.mkdirs(new Path("/perm"));
        this.createWithHttp("/perm/none", null);
        String statusJson = this.getStatus("/perm/none", "GETFILESTATUS");
        Assert.assertTrue((boolean)"755".equals(this.getPerms(statusJson)));
        this.createWithHttp("/perm/p-777", "777");
        statusJson = this.getStatus("/perm/p-777", "GETFILESTATUS");
        Assert.assertTrue((boolean)"777".equals(this.getPerms(statusJson)));
        this.createWithHttp("/perm/p-654", "654");
        statusJson = this.getStatus("/perm/p-654", "GETFILESTATUS");
        Assert.assertTrue((boolean)"654".equals(this.getPerms(statusJson)));
        this.createWithHttp("/perm/p-321", "321");
        statusJson = this.getStatus("/perm/p-321", "GETFILESTATUS");
        Assert.assertTrue((boolean)"321".equals(this.getPerms(statusJson)));
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testXAttrs() throws Exception {
        String name1 = "user.a1";
        byte[] value1 = new byte[]{49, 50, 51};
        String name2 = "user.a2";
        byte[] value2 = new byte[]{65, 66, 67};
        String dir = "/xattrTest";
        String path = "/xattrTest/file";
        this.createHttpFSServer(false);
        FileSystem fs = FileSystem.get((Configuration)TestHdfsHelper.getHdfsConf());
        fs.mkdirs(new Path("/xattrTest"));
        this.createWithHttp("/xattrTest/file", null);
        String statusJson = this.getStatus("/xattrTest/file", "GETXATTRS");
        Map xAttrs = this.getXAttrs(statusJson);
        Assert.assertEquals((long)0L, (long)xAttrs.size());
        this.putCmd("/xattrTest/file", "SETXATTR", TestHttpFSServer.setXAttrParam((String)"user.a1", (byte[])value1));
        this.putCmd("/xattrTest/file", "SETXATTR", TestHttpFSServer.setXAttrParam((String)"user.a2", (byte[])value2));
        statusJson = this.getStatus("/xattrTest/file", "GETXATTRS");
        xAttrs = this.getXAttrs(statusJson);
        Assert.assertEquals((long)2L, (long)xAttrs.size());
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xAttrs.get("user.a1")));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xAttrs.get("user.a2")));
        this.putCmd("/xattrTest/file", "REMOVEXATTR", "xattr.name=user.a1");
        statusJson = this.getStatus("/xattrTest/file", "GETXATTRS");
        xAttrs = this.getXAttrs(statusJson);
        Assert.assertEquals((long)1L, (long)xAttrs.size());
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xAttrs.get("user.a2")));
        this.putCmd("/xattrTest/file", "REMOVEXATTR", "xattr.name=user.a2");
        statusJson = this.getStatus("/xattrTest/file", "GETXATTRS");
        xAttrs = this.getXAttrs(statusJson);
        Assert.assertEquals((long)0L, (long)xAttrs.size());
    }

    public static String setXAttrParam(String name, byte[] value) throws IOException {
        return "xattr.name=" + name + "&xattr.value=" + XAttrCodec.encodeValue((byte[])value, (XAttrCodec)XAttrCodec.HEX) + "&encoding=hex&flag=create";
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testFileAcls() throws Exception {
        String aclUser1 = "user:foo:rw-";
        String aclUser2 = "user:bar:r--";
        String aclGroup1 = "group::r--";
        String aclSpec = "aclspec=user::rwx,user:foo:rw-,group::r--,other::---";
        String modAclSpec = "aclspec=user:bar:r--";
        String remAclSpec = "aclspec=user:foo:rw-";
        String dir = "/aclFileTest";
        String path = "/aclFileTest/test";
        this.createHttpFSServer(false);
        FileSystem fs = FileSystem.get((Configuration)TestHdfsHelper.getHdfsConf());
        fs.mkdirs(new Path("/aclFileTest"));
        this.createWithHttp("/aclFileTest/test", null);
        String statusJson = this.getStatus("/aclFileTest/test", "GETFILESTATUS");
        Assert.assertEquals((long)-1L, (long)statusJson.indexOf("aclBit"));
        statusJson = this.getStatus("/aclFileTest", "LISTSTATUS");
        Assert.assertEquals((long)-1L, (long)statusJson.indexOf("aclBit"));
        statusJson = this.getStatus("/aclFileTest/test", "GETACLSTATUS");
        List aclEntries = this.getAclEntries(statusJson);
        Assert.assertTrue((aclEntries.size() == 0 ? 1 : 0) != 0);
        this.putCmd("/aclFileTest/test", "SETACL", "aclspec=user::rwx,user:foo:rw-,group::r--,other::---");
        statusJson = this.getStatus("/aclFileTest/test", "GETFILESTATUS");
        Assert.assertNotEquals((long)-1L, (long)statusJson.indexOf("aclBit"));
        statusJson = this.getStatus("/aclFileTest", "LISTSTATUS");
        Assert.assertNotEquals((long)-1L, (long)statusJson.indexOf("aclBit"));
        statusJson = this.getStatus("/aclFileTest/test", "GETACLSTATUS");
        aclEntries = this.getAclEntries(statusJson);
        Assert.assertTrue((aclEntries.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)aclEntries.contains("user:foo:rw-"));
        Assert.assertTrue((boolean)aclEntries.contains("group::r--"));
        this.putCmd("/aclFileTest/test", "MODIFYACLENTRIES", "aclspec=user:bar:r--");
        statusJson = this.getStatus("/aclFileTest/test", "GETACLSTATUS");
        aclEntries = this.getAclEntries(statusJson);
        Assert.assertTrue((aclEntries.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)aclEntries.contains("user:foo:rw-"));
        Assert.assertTrue((boolean)aclEntries.contains("user:bar:r--"));
        Assert.assertTrue((boolean)aclEntries.contains("group::r--"));
        this.putCmd("/aclFileTest/test", "REMOVEACLENTRIES", "aclspec=user:foo:rw-");
        statusJson = this.getStatus("/aclFileTest/test", "GETACLSTATUS");
        aclEntries = this.getAclEntries(statusJson);
        Assert.assertTrue((aclEntries.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)aclEntries.contains("user:bar:r--"));
        Assert.assertTrue((boolean)aclEntries.contains("group::r--"));
        this.putCmd("/aclFileTest/test", "REMOVEACL", null);
        statusJson = this.getStatus("/aclFileTest/test", "GETACLSTATUS");
        aclEntries = this.getAclEntries(statusJson);
        Assert.assertTrue((aclEntries.size() == 0 ? 1 : 0) != 0);
        statusJson = this.getStatus("/aclFileTest/test", "GETFILESTATUS");
        Assert.assertEquals((long)-1L, (long)statusJson.indexOf("aclBit"));
        statusJson = this.getStatus("/aclFileTest", "LISTSTATUS");
        Assert.assertEquals((long)-1L, (long)statusJson.indexOf("aclBit"));
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testDirAcls() throws Exception {
        String defUser1 = "default:user:glarch:r-x";
        String defSpec1 = "aclspec=default:user:glarch:r-x";
        String dir = "/aclDirTest";
        this.createHttpFSServer(false);
        FileSystem fs = FileSystem.get((Configuration)TestHdfsHelper.getHdfsConf());
        fs.mkdirs(new Path("/aclDirTest"));
        String statusJson = this.getStatus("/aclDirTest", "GETFILESTATUS");
        Assert.assertEquals((long)-1L, (long)statusJson.indexOf("aclBit"));
        statusJson = this.getStatus("/aclDirTest", "GETACLSTATUS");
        List aclEntries = this.getAclEntries(statusJson);
        Assert.assertTrue((aclEntries.size() == 0 ? 1 : 0) != 0);
        this.putCmd("/aclDirTest", "SETACL", "aclspec=default:user:glarch:r-x");
        statusJson = this.getStatus("/aclDirTest", "GETFILESTATUS");
        Assert.assertNotEquals((long)-1L, (long)statusJson.indexOf("aclBit"));
        statusJson = this.getStatus("/aclDirTest", "GETACLSTATUS");
        aclEntries = this.getAclEntries(statusJson);
        Assert.assertTrue((aclEntries.size() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)aclEntries.contains("default:user:glarch:r-x"));
        this.putCmd("/aclDirTest", "REMOVEDEFAULTACL", null);
        statusJson = this.getStatus("/aclDirTest", "GETFILESTATUS");
        Assert.assertEquals((long)-1L, (long)statusJson.indexOf("aclBit"));
        statusJson = this.getStatus("/aclDirTest", "GETACLSTATUS");
        aclEntries = this.getAclEntries(statusJson);
        Assert.assertTrue((aclEntries.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testOpenOffsetLength() throws Exception {
        this.createHttpFSServer(false);
        byte[] array = new byte[]{0, 1, 2, 3};
        FileSystem fs = FileSystem.get((Configuration)TestHdfsHelper.getHdfsConf());
        fs.mkdirs(new Path("/tmp"));
        FSDataOutputStream os = fs.create(new Path("/tmp/foo"));
        os.write(array);
        os.close();
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        URL url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1/tmp/foo?user.name={0}&op=open&offset=1&length=2", user));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        InputStream is = conn.getInputStream();
        Assert.assertEquals((long)1L, (long)is.read());
        Assert.assertEquals((long)2L, (long)is.read());
        Assert.assertEquals((long)-1L, (long)is.read());
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testPutNoOperation() throws Exception {
        this.createHttpFSServer(false);
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        URL url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1/foo?user.name={0}", user));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestMethod("PUT");
        Assert.assertEquals((long)conn.getResponseCode(), (long)400L);
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testDelegationTokenOperations() throws Exception {
        this.createHttpFSServer(true);
        URL url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=GETHOMEDIRECTORY");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)401L, (long)conn.getResponseCode());
        AuthenticationToken token = new AuthenticationToken("u", "p", "kerberos-dt");
        token.setExpires(System.currentTimeMillis() + 100000000L);
        Signer signer = new Signer("secret".getBytes());
        String tokenSigned = signer.sign(token.toString());
        url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=GETHOMEDIRECTORY");
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Cookie", "hadoop.auth=" + tokenSigned);
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=GETDELEGATIONTOKEN");
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Cookie", "hadoop.auth=" + tokenSigned);
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        JSONObject json = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(conn.getInputStream()));
        json = (JSONObject)json.get((Object)"Token");
        String tokenStr = (String)json.get((Object)"urlString");
        url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=GETHOMEDIRECTORY&delegation=" + tokenStr);
        conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=RENEWDELEGATIONTOKEN&token=" + tokenStr);
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("PUT");
        Assert.assertEquals((long)401L, (long)conn.getResponseCode());
        url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=RENEWDELEGATIONTOKEN&token=" + tokenStr);
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("PUT");
        conn.setRequestProperty("Cookie", "hadoop.auth=" + tokenSigned);
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=CANCELDELEGATIONTOKEN&token=" + tokenStr);
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("PUT");
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=GETHOMEDIRECTORY&delegation=" + tokenStr);
        conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)403L, (long)conn.getResponseCode());
    }
}

