/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.http.client.HttpFSFileSystem;
import org.apache.hadoop.fs.http.client.HttpFSKerberosAuthenticator;
import org.apache.hadoop.fs.http.server.HttpFSKerberosAuthenticationHandlerForTesting;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.hdfs.web.SWebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.lib.service.DelegationTokenManager;
import org.apache.hadoop.lib.service.DelegationTokenManagerException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.HFSTestCase;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHttpFSKerberosAuthenticationHandler
extends HFSTestCase {
    @Test
    @TestDir
    public void testManagementOperationsWebHdfsFileSystem() throws Exception {
        this.testManagementOperations(WebHdfsFileSystem.TOKEN_KIND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @TestDir
    public void testManagementOperationsSWebHdfsFileSystem() throws Exception {
        try {
            System.setProperty("httpfs.ssl.enabled", "true");
            this.testManagementOperations(SWebHdfsFileSystem.TOKEN_KIND);
        }
        finally {
            System.getProperties().remove("httpfs.ssl.enabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testManagementOperations(Text expectedTokenKind) throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration httpfsConf = new Configuration(false);
        HttpFSServerWebApp server = new HttpFSServerWebApp(dir, dir, dir, dir, httpfsConf);
        server.setAuthority(new InetSocketAddress(InetAddress.getLocalHost(), 14000));
        HttpFSKerberosAuthenticationHandlerForTesting handler = new HttpFSKerberosAuthenticationHandlerForTesting();
        try {
            server.init();
            handler.init(null);
            this.testNonManagementOperation((AuthenticationHandler)handler);
            this.testManagementOperationErrors((AuthenticationHandler)handler);
            this.testGetToken((AuthenticationHandler)handler, null, expectedTokenKind);
            this.testGetToken((AuthenticationHandler)handler, "foo", expectedTokenKind);
            this.testCancelToken((AuthenticationHandler)handler);
            this.testRenewToken((AuthenticationHandler)handler);
        }
        finally {
            if (handler != null) {
                handler.destroy();
            }
            server.destroy();
        }
    }

    private void testNonManagementOperation(AuthenticationHandler handler) throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getParameter("op")).thenReturn(null);
        Assert.assertTrue((boolean)handler.managementOperation(null, request, null));
        Mockito.when((Object)request.getParameter("op")).thenReturn((Object)HttpFSFileSystem.Operation.CREATE.toString());
        Assert.assertTrue((boolean)handler.managementOperation(null, request, null));
    }

    private void testManagementOperationErrors(AuthenticationHandler handler) throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getParameter("op")).thenReturn((Object)HttpFSKerberosAuthenticator.DelegationTokenOperation.GETDELEGATIONTOKEN.toString());
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"FOO");
        Assert.assertFalse((boolean)handler.managementOperation(null, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)400), Mockito.startsWith((String)"Wrong HTTP method"));
        Mockito.reset((Object[])new HttpServletResponse[]{response});
        Mockito.when((Object)request.getMethod()).thenReturn((Object)HttpFSKerberosAuthenticator.DelegationTokenOperation.GETDELEGATIONTOKEN.getHttpMethod());
        Assert.assertFalse((boolean)handler.managementOperation(null, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)401), Mockito.contains((String)"requires SPNEGO"));
    }

    private void testGetToken(AuthenticationHandler handler, String renewer, Text expectedTokenKind) throws Exception {
        HttpFSKerberosAuthenticator.DelegationTokenOperation op = HttpFSKerberosAuthenticator.DelegationTokenOperation.GETDELEGATIONTOKEN;
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getParameter("op")).thenReturn((Object)op.toString());
        Mockito.when((Object)request.getMethod()).thenReturn((Object)op.getHttpMethod());
        AuthenticationToken token = (AuthenticationToken)Mockito.mock(AuthenticationToken.class);
        Mockito.when((Object)token.getUserName()).thenReturn((Object)"user");
        Assert.assertFalse((boolean)handler.managementOperation(null, request, response));
        Mockito.when((Object)request.getParameter("renewer")).thenReturn((Object)renewer);
        Mockito.reset((Object[])new HttpServletResponse[]{response});
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)pwriter);
        Assert.assertFalse((boolean)handler.managementOperation(token, request, response));
        if (renewer == null) {
            ((AuthenticationToken)Mockito.verify((Object)token)).getUserName();
        } else {
            ((AuthenticationToken)Mockito.verify((Object)token, (VerificationMode)Mockito.never())).getUserName();
        }
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(200);
        ((HttpServletResponse)Mockito.verify((Object)response)).setContentType("application/json");
        pwriter.close();
        String responseOutput = writer.toString();
        String tokenLabel = "Token";
        Assert.assertTrue((boolean)responseOutput.contains(tokenLabel));
        Assert.assertTrue((boolean)responseOutput.contains("urlString"));
        JSONObject json = (JSONObject)new JSONParser().parse(responseOutput);
        json = (JSONObject)json.get((Object)tokenLabel);
        String tokenStr = (String)json.get((Object)"urlString");
        Token dt = new Token();
        dt.decodeFromUrlString(tokenStr);
        ((DelegationTokenManager)HttpFSServerWebApp.get().get(DelegationTokenManager.class)).verifyToken(dt);
        Assert.assertEquals((Object)expectedTokenKind, (Object)dt.getKind());
    }

    private void testCancelToken(AuthenticationHandler handler) throws Exception {
        HttpFSKerberosAuthenticator.DelegationTokenOperation op = HttpFSKerberosAuthenticator.DelegationTokenOperation.CANCELDELEGATIONTOKEN;
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getParameter("op")).thenReturn((Object)op.toString());
        Mockito.when((Object)request.getMethod()).thenReturn((Object)op.getHttpMethod());
        Assert.assertFalse((boolean)handler.managementOperation(null, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)400), Mockito.contains((String)"requires the parameter [token]"));
        Mockito.reset((Object[])new HttpServletResponse[]{response});
        Token token = ((DelegationTokenManager)HttpFSServerWebApp.get().get(DelegationTokenManager.class)).createToken(UserGroupInformation.getCurrentUser(), "foo");
        Mockito.when((Object)request.getParameter("token")).thenReturn((Object)token.encodeToUrlString());
        Assert.assertFalse((boolean)handler.managementOperation(null, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(200);
        try {
            ((DelegationTokenManager)HttpFSServerWebApp.get().get(DelegationTokenManager.class)).verifyToken(token);
            Assert.fail();
        }
        catch (DelegationTokenManagerException ex) {
            Assert.assertTrue((boolean)ex.toString().contains("DT01"));
        }
    }

    private void testRenewToken(AuthenticationHandler handler) throws Exception {
        HttpFSKerberosAuthenticator.DelegationTokenOperation op = HttpFSKerberosAuthenticator.DelegationTokenOperation.RENEWDELEGATIONTOKEN;
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getParameter("op")).thenReturn((Object)op.toString());
        Mockito.when((Object)request.getMethod()).thenReturn((Object)op.getHttpMethod());
        Assert.assertFalse((boolean)handler.managementOperation(null, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)401), Mockito.contains((String)"equires SPNEGO authentication established"));
        Mockito.reset((Object[])new HttpServletResponse[]{response});
        AuthenticationToken token = (AuthenticationToken)Mockito.mock(AuthenticationToken.class);
        Mockito.when((Object)token.getUserName()).thenReturn((Object)"user");
        Assert.assertFalse((boolean)handler.managementOperation(token, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)400), Mockito.contains((String)"requires the parameter [token]"));
        Mockito.reset((Object[])new HttpServletResponse[]{response});
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)pwriter);
        Token dToken = ((DelegationTokenManager)HttpFSServerWebApp.get().get(DelegationTokenManager.class)).createToken(UserGroupInformation.getCurrentUser(), "user");
        Mockito.when((Object)request.getParameter("token")).thenReturn((Object)dToken.encodeToUrlString());
        Assert.assertFalse((boolean)handler.managementOperation(token, request, response));
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(200);
        pwriter.close();
        Assert.assertTrue((boolean)writer.toString().contains("long"));
        ((DelegationTokenManager)HttpFSServerWebApp.get().get(DelegationTokenManager.class)).verifyToken(dToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @TestDir
    public void testAuthenticate() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration httpfsConf = new Configuration(false);
        HttpFSServerWebApp server = new HttpFSServerWebApp(dir, dir, dir, dir, httpfsConf);
        server.setAuthority(new InetSocketAddress(InetAddress.getLocalHost(), 14000));
        HttpFSKerberosAuthenticationHandlerForTesting handler = new HttpFSKerberosAuthenticationHandlerForTesting();
        try {
            server.init();
            handler.init(null);
            this.testValidDelegationToken((AuthenticationHandler)handler);
            this.testInvalidDelegationToken((AuthenticationHandler)handler);
        }
        finally {
            if (handler != null) {
                handler.destroy();
            }
            server.destroy();
        }
    }

    private void testValidDelegationToken(AuthenticationHandler handler) throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Token dToken = ((DelegationTokenManager)HttpFSServerWebApp.get().get(DelegationTokenManager.class)).createToken(UserGroupInformation.getCurrentUser(), "user");
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)dToken.encodeToUrlString());
        AuthenticationToken token = handler.authenticate(request, response);
        Assert.assertEquals((Object)UserGroupInformation.getCurrentUser().getShortUserName(), (Object)token.getUserName());
        Assert.assertEquals((long)0L, (long)token.getExpires());
        Assert.assertEquals((Object)"kerberos-dt", (Object)token.getType());
        Assert.assertTrue((boolean)token.isExpired());
    }

    private void testInvalidDelegationToken(AuthenticationHandler handler) throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getParameter("delegation")).thenReturn((Object)"invalid");
        try {
            handler.authenticate(request, response);
            Assert.fail();
        }
        catch (AuthenticationException ex) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
    }
}

