/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.lib.wsrs.UserProvider;
import org.apache.hadoop.test.HFSTestCase;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.test.TestJetty;
import org.junit.Assert;
import org.junit.Test;

public class TestHttpFSCustomUserName
extends HFSTestCase {
    @Test
    @TestDir
    @TestJetty
    public void defaultUserName() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration httpfsConf = new Configuration(false);
        HttpFSServerWebApp server = new HttpFSServerWebApp(dir, dir, dir, dir, httpfsConf);
        server.init();
        Assert.assertEquals((Object)"^[A-Za-z_][A-Za-z0-9._-]*[$]?$", (Object)UserProvider.getUserPattern().pattern());
        server.destroy();
    }

    @Test
    @TestDir
    @TestJetty
    public void customUserName() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration httpfsConf = new Configuration(false);
        httpfsConf.set("httpfs.user.provider.user.pattern", "1");
        HttpFSServerWebApp server = new HttpFSServerWebApp(dir, dir, dir, dir, httpfsConf);
        server.init();
        Assert.assertEquals((Object)"1", (Object)UserProvider.getUserPattern().pattern());
        server.destroy();
    }
}

