/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.test.HTestCase;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.test.TestException;
import org.apache.hadoop.test.TestHTestCase;
import org.apache.hadoop.test.TestJetty;
import org.apache.hadoop.test.TestJettyHelper;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;

public class TestHTestCase
extends HTestCase {
    @Test(expected=IllegalStateException.class)
    public void testDirNoAnnotation() throws Exception {
        TestDirHelper.getTestDir();
    }

    @Test(expected=IllegalStateException.class)
    public void testJettyNoAnnotation() throws Exception {
        TestJettyHelper.getJettyServer();
    }

    @Test(expected=IllegalStateException.class)
    public void testJettyNoAnnotation2() throws Exception {
        TestJettyHelper.getJettyURL();
    }

    @Test
    @TestDir
    public void testDirAnnotation() throws Exception {
        Assert.assertNotNull((Object)TestDirHelper.getTestDir());
    }

    @Test
    public void waitFor() {
        long start = Time.now();
        long waited = this.waitFor(1000, (HTestCase.Predicate)new /* Unavailable Anonymous Inner Class!! */);
        long end = Time.now();
        Assert.assertEquals((float)waited, (float)0.0f, (float)50.0f);
        Assert.assertEquals((float)(end - start - waited), (float)0.0f, (float)50.0f);
    }

    @Test
    public void waitForTimeOutRatio1() {
        this.setWaitForRatio(1.0f);
        long start = Time.now();
        long waited = this.waitFor(200, (HTestCase.Predicate)new /* Unavailable Anonymous Inner Class!! */);
        long end = Time.now();
        Assert.assertEquals((long)waited, (long)-1L);
        Assert.assertEquals((float)(end - start), (float)200.0f, (float)50.0f);
    }

    @Test
    public void waitForTimeOutRatio2() {
        this.setWaitForRatio(2.0f);
        long start = Time.now();
        long waited = this.waitFor(200, (HTestCase.Predicate)new /* Unavailable Anonymous Inner Class!! */);
        long end = Time.now();
        Assert.assertEquals((long)waited, (long)-1L);
        Assert.assertEquals((float)(end - start), (float)(200.0f * this.getWaitForRatio()), (float)(50.0f * this.getWaitForRatio()));
    }

    @Test
    public void sleepRatio1() {
        this.setWaitForRatio(1.0f);
        long start = Time.now();
        this.sleep(100L);
        long end = Time.now();
        Assert.assertEquals((float)(end - start), (float)100.0f, (float)50.0f);
    }

    @Test
    public void sleepRatio2() {
        this.setWaitForRatio(1.0f);
        long start = Time.now();
        this.sleep(100L);
        long end = Time.now();
        Assert.assertEquals((float)(end - start), (float)(100.0f * this.getWaitForRatio()), (float)(50.0f * this.getWaitForRatio()));
    }

    @Test
    @TestJetty
    public void testJetty() throws Exception {
        Context context = new Context();
        context.setContextPath("/");
        context.addServlet(MyServlet.class, "/bar");
        Server server = TestJettyHelper.getJettyServer();
        server.addHandler((Handler)context);
        server.start();
        URL url = new URL(TestJettyHelper.getJettyURL(), "/bar");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)conn.getResponseCode(), (long)200L);
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        Assert.assertEquals((Object)reader.readLine(), (Object)"foo");
        reader.close();
    }

    @Test
    @TestException(exception=RuntimeException.class)
    public void testException0() {
        throw new RuntimeException("foo");
    }

    @Test
    @TestException(exception=RuntimeException.class, msgRegExp=".o.")
    public void testException1() {
        throw new RuntimeException("foo");
    }
}

