/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.wsrs;

import org.apache.hadoop.lib.wsrs.Param;
import org.apache.hadoop.lib.wsrs.TestParam;
import org.junit.Assert;
import org.junit.Test;

public class TestParam {
    private <T> void test(Param<T> param, String name, String domain, T defaultValue, T validValue, String invalidStrValue, String outOfRangeValue) throws Exception {
        Assert.assertEquals((Object)name, (Object)param.getName());
        Assert.assertEquals((Object)domain, (Object)param.getDomain());
        Assert.assertEquals(defaultValue, (Object)param.value());
        Assert.assertEquals(defaultValue, (Object)param.parseParam(""));
        Assert.assertEquals(defaultValue, (Object)param.parseParam(null));
        Assert.assertEquals(validValue, (Object)param.parseParam(validValue.toString()));
        if (invalidStrValue != null) {
            try {
                param.parseParam(invalidStrValue);
                Assert.fail();
            }
            catch (IllegalArgumentException ex) {
            }
            catch (Exception ex) {
                Assert.fail();
            }
        }
        if (outOfRangeValue != null) {
            try {
                param.parseParam(outOfRangeValue);
                Assert.fail();
            }
            catch (IllegalArgumentException ex) {
            }
            catch (Exception ex) {
                Assert.fail();
            }
        }
    }

    @Test
    public void testBoolean() throws Exception {
        1 param = new /* Unavailable Anonymous Inner Class!! */;
        this.test((Param)param, "b", "a boolean", (Object)false, (Object)true, "x", null);
    }

    @Test
    public void testByte() throws Exception {
        2 param = new /* Unavailable Anonymous Inner Class!! */;
        this.test((Param)param, "B", "a byte", (Object)1, (Object)2, "x", "256");
    }

    @Test
    public void testShort() throws Exception {
        3 param = new /* Unavailable Anonymous Inner Class!! */;
        this.test((Param)param, "S", "a short", (Object)1, (Object)2, "x", "32768");
        param = new /* Unavailable Anonymous Inner Class!! */;
        Assert.assertEquals((Object)new Short(1023), (Object)param.parse("01777"));
    }

    @Test
    public void testInteger() throws Exception {
        5 param = new /* Unavailable Anonymous Inner Class!! */;
        this.test((Param)param, "I", "an integer", (Object)1, (Object)2, "x", "2147483648");
    }

    @Test
    public void testLong() throws Exception {
        6 param = new /* Unavailable Anonymous Inner Class!! */;
        this.test((Param)param, "L", "a long", (Object)1L, (Object)2L, "x", null);
    }

    @Test
    public void testEnum() throws Exception {
        7 param = new /* Unavailable Anonymous Inner Class!! */;
        this.test((Param)param, "e", "FOO,BAR", (Object)ENUM.FOO, (Object)ENUM.BAR, "x", null);
    }

    @Test
    public void testString() throws Exception {
        8 param = new /* Unavailable Anonymous Inner Class!! */;
        this.test((Param)param, "s", "a string", (Object)"foo", (Object)"bar", null, null);
    }

    @Test
    public void testRegEx() throws Exception {
        9 param = new /* Unavailable Anonymous Inner Class!! */;
        this.test((Param)param, "r", "..", (Object)"aa", (Object)"bb", "c", null);
    }
}

