/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.service.instrumentation;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.lib.server.Server;
import org.apache.hadoop.lib.service.Instrumentation;
import org.apache.hadoop.lib.service.instrumentation.InstrumentationService;
import org.apache.hadoop.lib.service.instrumentation.TestInstrumentationService;
import org.apache.hadoop.lib.service.scheduler.SchedulerService;
import org.apache.hadoop.test.HTestCase;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.junit.Assert;
import org.junit.Test;

public class TestInstrumentationService
extends HTestCase {
    protected float getWaitForRatio() {
        return 1.0f;
    }

    @Test
    public void cron() {
        InstrumentationService.Cron cron = new InstrumentationService.Cron();
        Assert.assertEquals((long)cron.start, (long)0L);
        Assert.assertEquals((long)cron.lapStart, (long)0L);
        Assert.assertEquals((long)cron.own, (long)0L);
        Assert.assertEquals((long)cron.total, (long)0L);
        long begin = Time.now();
        Assert.assertEquals((Object)cron.start(), (Object)cron);
        Assert.assertEquals((Object)cron.start(), (Object)cron);
        Assert.assertEquals((float)cron.start, (float)begin, (float)20.0f);
        Assert.assertEquals((long)cron.start, (long)cron.lapStart);
        this.sleep(100L);
        Assert.assertEquals((Object)cron.stop(), (Object)cron);
        long end = Time.now();
        long delta = end - begin;
        Assert.assertEquals((float)cron.own, (float)delta, (float)20.0f);
        Assert.assertEquals((long)cron.total, (long)0L);
        Assert.assertEquals((long)cron.lapStart, (long)0L);
        this.sleep(100L);
        long reStart = Time.now();
        cron.start();
        Assert.assertEquals((float)cron.start, (float)begin, (float)20.0f);
        Assert.assertEquals((float)cron.lapStart, (float)reStart, (float)20.0f);
        this.sleep(100L);
        cron.stop();
        long reEnd = Time.now();
        Assert.assertEquals((float)cron.own, (float)(delta += reEnd - reStart), (float)20.0f);
        Assert.assertEquals((long)cron.total, (long)0L);
        Assert.assertEquals((long)cron.lapStart, (long)0L);
        cron.end();
        Assert.assertEquals((float)cron.total, (float)(reEnd - begin), (float)20.0f);
        try {
            cron.start();
            Assert.fail();
        }
        catch (IllegalStateException ex) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
        try {
            cron.stop();
            Assert.fail();
        }
        catch (IllegalStateException ex) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
    }

    @Test
    public void timer() throws Exception {
        long totalDelta;
        long ownStart;
        InstrumentationService.Timer timer = new InstrumentationService.Timer(2);
        InstrumentationService.Cron cron = new InstrumentationService.Cron();
        cron.start();
        long totalStart = ownStart = Time.now();
        long ownDelta = 0L;
        this.sleep(100L);
        cron.stop();
        long ownEnd = Time.now();
        ownDelta += ownEnd - ownStart;
        this.sleep(100L);
        cron.start();
        ownStart = Time.now();
        this.sleep(100L);
        cron.stop();
        ownEnd = Time.now();
        long totalEnd = ownEnd;
        long avgTotal = totalDelta = totalEnd - totalStart;
        long avgOwn = ownDelta += ownEnd - ownStart;
        timer.addCron(cron);
        long[] values = timer.getValues();
        Assert.assertEquals((float)values[0], (float)totalDelta, (float)20.0f);
        Assert.assertEquals((float)values[1], (float)ownDelta, (float)20.0f);
        Assert.assertEquals((float)values[2], (float)avgTotal, (float)20.0f);
        Assert.assertEquals((float)values[3], (float)avgOwn, (float)20.0f);
        cron = new InstrumentationService.Cron();
        cron.start();
        totalStart = ownStart = Time.now();
        ownDelta = 0L;
        this.sleep(200L);
        cron.stop();
        ownEnd = Time.now();
        ownDelta += ownEnd - ownStart;
        this.sleep(200L);
        cron.start();
        ownStart = Time.now();
        this.sleep(200L);
        cron.stop();
        ownEnd = Time.now();
        totalEnd = ownEnd;
        totalDelta = totalEnd - totalStart;
        avgTotal = (avgTotal * 1L + totalDelta) / 2L;
        avgOwn = (avgOwn * 1L + (ownDelta += ownEnd - ownStart)) / 2L;
        timer.addCron(cron);
        values = timer.getValues();
        Assert.assertEquals((float)values[0], (float)totalDelta, (float)20.0f);
        Assert.assertEquals((float)values[1], (float)ownDelta, (float)20.0f);
        Assert.assertEquals((float)values[2], (float)avgTotal, (float)20.0f);
        Assert.assertEquals((float)values[3], (float)avgOwn, (float)20.0f);
        avgTotal = totalDelta;
        avgOwn = ownDelta;
        cron = new InstrumentationService.Cron();
        cron.start();
        totalStart = ownStart = Time.now();
        ownDelta = 0L;
        this.sleep(300L);
        cron.stop();
        ownEnd = Time.now();
        ownDelta += ownEnd - ownStart;
        this.sleep(300L);
        cron.start();
        ownStart = Time.now();
        this.sleep(300L);
        cron.stop();
        ownEnd = Time.now();
        totalEnd = ownEnd;
        totalDelta = totalEnd - totalStart;
        avgTotal = (avgTotal * 1L + totalDelta) / 2L;
        avgOwn = (avgOwn * 1L + (ownDelta += ownEnd - ownStart)) / 2L;
        cron.stop();
        timer.addCron(cron);
        values = timer.getValues();
        Assert.assertEquals((float)values[0], (float)totalDelta, (float)20.0f);
        Assert.assertEquals((float)values[1], (float)ownDelta, (float)20.0f);
        Assert.assertEquals((float)values[2], (float)avgTotal, (float)20.0f);
        Assert.assertEquals((float)values[3], (float)avgOwn, (float)20.0f);
        JSONObject json = (JSONObject)new JSONParser().parse(timer.toJSONString());
        Assert.assertEquals((long)json.size(), (long)4L);
        Assert.assertEquals((Object)json.get((Object)"lastTotal"), (Object)values[0]);
        Assert.assertEquals((Object)json.get((Object)"lastOwn"), (Object)values[1]);
        Assert.assertEquals((Object)json.get((Object)"avgTotal"), (Object)values[2]);
        Assert.assertEquals((Object)json.get((Object)"avgOwn"), (Object)values[3]);
        StringWriter writer = new StringWriter();
        timer.writeJSONString((Writer)writer);
        writer.close();
        json = (JSONObject)new JSONParser().parse(writer.toString());
        Assert.assertEquals((long)json.size(), (long)4L);
        Assert.assertEquals((Object)json.get((Object)"lastTotal"), (Object)values[0]);
        Assert.assertEquals((Object)json.get((Object)"lastOwn"), (Object)values[1]);
        Assert.assertEquals((Object)json.get((Object)"avgTotal"), (Object)values[2]);
        Assert.assertEquals((Object)json.get((Object)"avgOwn"), (Object)values[3]);
    }

    @Test
    public void sampler() throws Exception {
        long[] value = new long[1];
        1 var = new /* Unavailable Anonymous Inner Class!! */;
        InstrumentationService.Sampler sampler = new InstrumentationService.Sampler();
        sampler.init(4, (Instrumentation.Variable)var);
        Assert.assertEquals((double)sampler.getRate(), (double)0.0, (double)1.0E-4);
        sampler.sample();
        Assert.assertEquals((double)sampler.getRate(), (double)0.0, (double)1.0E-4);
        value[0] = 1L;
        sampler.sample();
        Assert.assertEquals((double)sampler.getRate(), (double)0.5, (double)1.0E-4);
        value[0] = 2L;
        sampler.sample();
        Assert.assertEquals((double)sampler.getRate(), (double)1.0, (double)1.0E-4);
        value[0] = 3L;
        sampler.sample();
        Assert.assertEquals((double)sampler.getRate(), (double)1.5, (double)1.0E-4);
        value[0] = 4L;
        sampler.sample();
        Assert.assertEquals((double)sampler.getRate(), (double)2.5, (double)1.0E-4);
        JSONObject json = (JSONObject)new JSONParser().parse(sampler.toJSONString());
        Assert.assertEquals((long)json.size(), (long)2L);
        Assert.assertEquals((Object)json.get((Object)"sampler"), (Object)sampler.getRate());
        Assert.assertEquals((Object)json.get((Object)"size"), (Object)4L);
        StringWriter writer = new StringWriter();
        sampler.writeJSONString((Writer)writer);
        writer.close();
        json = (JSONObject)new JSONParser().parse(writer.toString());
        Assert.assertEquals((long)json.size(), (long)2L);
        Assert.assertEquals((Object)json.get((Object)"sampler"), (Object)sampler.getRate());
        Assert.assertEquals((Object)json.get((Object)"size"), (Object)4L);
    }

    @Test
    public void variableHolder() throws Exception {
        InstrumentationService.VariableHolder variableHolder = new InstrumentationService.VariableHolder();
        variableHolder.var = new /* Unavailable Anonymous Inner Class!! */;
        JSONObject json = (JSONObject)new JSONParser().parse(variableHolder.toJSONString());
        Assert.assertEquals((long)json.size(), (long)1L);
        Assert.assertEquals((Object)json.get((Object)"value"), (Object)"foo");
        StringWriter writer = new StringWriter();
        variableHolder.writeJSONString((Writer)writer);
        writer.close();
        json = (JSONObject)new JSONParser().parse(writer.toString());
        Assert.assertEquals((long)json.size(), (long)1L);
        Assert.assertEquals((Object)json.get((Object)"value"), (Object)"foo");
    }

    @Test
    @TestDir
    public void service() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        String services = StringUtils.join((CharSequence)",", Arrays.asList(InstrumentationService.class.getName()));
        Configuration conf = new Configuration(false);
        conf.set("server.services", services);
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        Instrumentation instrumentation = (Instrumentation)server.get(Instrumentation.class);
        Assert.assertNotNull((Object)instrumentation);
        instrumentation.incr("g", "c", 1L);
        instrumentation.incr("g", "c", 2L);
        instrumentation.incr("g", "c1", 2L);
        Instrumentation.Cron cron = instrumentation.createCron();
        cron.start();
        this.sleep(100L);
        cron.stop();
        instrumentation.addCron("g", "t", cron);
        cron = instrumentation.createCron();
        cron.start();
        this.sleep(200L);
        cron.stop();
        instrumentation.addCron("g", "t", cron);
        3 var = new /* Unavailable Anonymous Inner Class!! */;
        instrumentation.addVariable("g", "v", (Instrumentation.Variable)var);
        4 varToSample = new /* Unavailable Anonymous Inner Class!! */;
        instrumentation.addSampler("g", "s", 10, (Instrumentation.Variable)varToSample);
        Map snapshot = instrumentation.getSnapshot();
        Assert.assertNotNull(snapshot.get("os-env"));
        Assert.assertNotNull(snapshot.get("sys-props"));
        Assert.assertNotNull(snapshot.get("jvm"));
        Assert.assertNotNull(snapshot.get("counters"));
        Assert.assertNotNull(snapshot.get("timers"));
        Assert.assertNotNull(snapshot.get("variables"));
        Assert.assertNotNull(snapshot.get("samplers"));
        Assert.assertNotNull(((Map)snapshot.get("os-env")).get("PATH"));
        Assert.assertNotNull(((Map)snapshot.get("sys-props")).get("java.version"));
        Assert.assertNotNull(((Map)snapshot.get("jvm")).get("free.memory"));
        Assert.assertNotNull(((Map)snapshot.get("jvm")).get("max.memory"));
        Assert.assertNotNull(((Map)snapshot.get("jvm")).get("total.memory"));
        Assert.assertNotNull(((Map)snapshot.get("counters")).get("g"));
        Assert.assertNotNull(((Map)snapshot.get("timers")).get("g"));
        Assert.assertNotNull(((Map)snapshot.get("variables")).get("g"));
        Assert.assertNotNull(((Map)snapshot.get("samplers")).get("g"));
        Assert.assertNotNull(((Map)((Map)snapshot.get("counters")).get("g")).get("c"));
        Assert.assertNotNull(((Map)((Map)snapshot.get("counters")).get("g")).get("c1"));
        Assert.assertNotNull(((Map)((Map)snapshot.get("timers")).get("g")).get("t"));
        Assert.assertNotNull(((Map)((Map)snapshot.get("variables")).get("g")).get("v"));
        Assert.assertNotNull(((Map)((Map)snapshot.get("samplers")).get("g")).get("s"));
        StringWriter writer = new StringWriter();
        JSONObject.writeJSONString((Map)snapshot, (Writer)writer);
        writer.close();
        server.destroy();
    }

    @Test
    @TestDir
    public void sampling() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        String services = StringUtils.join((CharSequence)",", Arrays.asList(InstrumentationService.class.getName(), SchedulerService.class.getName()));
        Configuration conf = new Configuration(false);
        conf.set("server.services", services);
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        Instrumentation instrumentation = (Instrumentation)server.get(Instrumentation.class);
        AtomicInteger count = new AtomicInteger();
        5 varToSample = new /* Unavailable Anonymous Inner Class!! */;
        instrumentation.addSampler("g", "s", 10, (Instrumentation.Variable)varToSample);
        this.sleep(2000L);
        int i = count.get();
        Assert.assertTrue((i > 0 ? 1 : 0) != 0);
        Map snapshot = instrumentation.getSnapshot();
        Map samplers = (Map)snapshot.get("samplers");
        InstrumentationService.Sampler sampler = (InstrumentationService.Sampler)((Map)samplers.get("g")).get("s");
        Assert.assertTrue((sampler.getRate() > 0.0 ? 1 : 0) != 0);
        server.destroy();
    }
}

