/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.http.server.HttpFSKerberosAuthenticationHandlerForTesting;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.fs.http.server.TestHttpFSServer;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.test.HFSTestCase;
import org.apache.hadoop.test.HadoopUsersConfTestHelper;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.test.TestHdfs;
import org.apache.hadoop.test.TestHdfsHelper;
import org.apache.hadoop.test.TestJetty;
import org.apache.hadoop.test.TestJettyHelper;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.junit.Assert;
import org.junit.Test;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;

public class TestHttpFSServer
extends HFSTestCase {
    @Test
    @TestDir
    @TestJetty
    public void server() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration httpfsConf = new Configuration(false);
        HttpFSServerWebApp server = new HttpFSServerWebApp(dir, dir, dir, dir, httpfsConf);
        server.init();
        server.destroy();
    }

    private void createHttpFSServer(boolean addDelegationTokenAuthHandler) throws Exception {
        File homeDir = TestDirHelper.getTestDir();
        Assert.assertTrue((boolean)new File(homeDir, "conf").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "log").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "temp").mkdir());
        HttpFSServerWebApp.setHomeDirForCurrentThread((String)homeDir.getAbsolutePath());
        File secretFile = new File(new File(homeDir, "conf"), "secret");
        FileWriter w = new FileWriter(secretFile);
        w.write("secret");
        ((Writer)w).close();
        File hadoopConfDir = new File(new File(homeDir, "conf"), "hadoop-conf");
        hadoopConfDir.mkdirs();
        String fsDefaultName = TestHdfsHelper.getHdfsConf().get("fs.defaultFS");
        Configuration conf = new Configuration(false);
        conf.set("fs.defaultFS", fsDefaultName);
        File hdfsSite = new File(hadoopConfDir, "hdfs-site.xml");
        FileOutputStream os = new FileOutputStream(hdfsSite);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        conf = new Configuration(false);
        if (addDelegationTokenAuthHandler) {
            conf.set("httpfs.authentication.type", HttpFSKerberosAuthenticationHandlerForTesting.class.getName());
        }
        conf.set("httpfs.services.ext", MockGroups.class.getName());
        conf.set("httpfs.admin.group", HadoopUsersConfTestHelper.getHadoopUserGroups((String)HadoopUsersConfTestHelper.getHadoopUsers()[0])[0]);
        conf.set("httpfs.proxyuser." + HadoopUsersConfTestHelper.getHadoopProxyUser() + ".groups", HadoopUsersConfTestHelper.getHadoopProxyUserGroups());
        conf.set("httpfs.proxyuser." + HadoopUsersConfTestHelper.getHadoopProxyUser() + ".hosts", HadoopUsersConfTestHelper.getHadoopProxyUserHosts());
        conf.set("httpfs.authentication.signature.secret.file", secretFile.getAbsolutePath());
        conf.set("httpfs.hadoop.config.dir", hadoopConfDir.toString());
        File httpfsSite = new File(new File(homeDir, "conf"), "httpfs-site.xml");
        os = new FileOutputStream(httpfsSite);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource("webapp");
        WebAppContext context = new WebAppContext(url.getPath(), "/webhdfs");
        Server server = TestJettyHelper.getJettyServer();
        server.addHandler((Handler)context);
        server.start();
        if (addDelegationTokenAuthHandler) {
            HttpFSServerWebApp.get().setAuthority(TestJettyHelper.getAuthority());
        }
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void instrumentation() throws Exception {
        this.createHttpFSServer(false);
        URL url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1?user.name={0}&op=instrumentation", "nobody"));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)conn.getResponseCode(), (long)401L);
        url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1?user.name={0}&op=instrumentation", HadoopUsersConfTestHelper.getHadoopUsers()[0]));
        conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)conn.getResponseCode(), (long)200L);
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String line = reader.readLine();
        reader.close();
        Assert.assertTrue((boolean)line.contains("\"counters\":{"));
        url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1/foo?user.name={0}&op=instrumentation", HadoopUsersConfTestHelper.getHadoopUsers()[0]));
        conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)conn.getResponseCode(), (long)400L);
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testHdfsAccess() throws Exception {
        this.createHttpFSServer(false);
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        URL url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1/?user.name={0}&op=liststatus", user));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)conn.getResponseCode(), (long)200L);
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        reader.readLine();
        reader.close();
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testGlobFilter() throws Exception {
        this.createHttpFSServer(false);
        FileSystem fs = FileSystem.get((Configuration)TestHdfsHelper.getHdfsConf());
        fs.mkdirs(new Path("/tmp"));
        fs.create(new Path("/tmp/foo.txt")).close();
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        URL url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1/tmp?user.name={0}&op=liststatus&filter=f*", user));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)conn.getResponseCode(), (long)200L);
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        reader.readLine();
        reader.close();
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testOpenOffsetLength() throws Exception {
        this.createHttpFSServer(false);
        byte[] array = new byte[]{0, 1, 2, 3};
        FileSystem fs = FileSystem.get((Configuration)TestHdfsHelper.getHdfsConf());
        fs.mkdirs(new Path("/tmp"));
        FSDataOutputStream os = fs.create(new Path("/tmp/foo"));
        os.write(array);
        os.close();
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        URL url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1/tmp/foo?user.name={0}&op=open&offset=1&length=2", user));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        InputStream is = conn.getInputStream();
        Assert.assertEquals((long)1L, (long)is.read());
        Assert.assertEquals((long)2L, (long)is.read());
        Assert.assertEquals((long)-1L, (long)is.read());
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testPutNoOperation() throws Exception {
        this.createHttpFSServer(false);
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        URL url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1/foo?user.name={0}", user));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestMethod("PUT");
        Assert.assertEquals((long)conn.getResponseCode(), (long)400L);
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testDelegationTokenOperations() throws Exception {
        this.createHttpFSServer(true);
        URL url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=GETHOMEDIRECTORY");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)401L, (long)conn.getResponseCode());
        AuthenticationToken token = new AuthenticationToken("u", "p", "kerberos-dt");
        token.setExpires(System.currentTimeMillis() + 100000000L);
        Signer signer = new Signer("secret".getBytes());
        String tokenSigned = signer.sign(token.toString());
        url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=GETHOMEDIRECTORY");
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Cookie", "hadoop.auth=" + tokenSigned);
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=GETDELEGATIONTOKEN");
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Cookie", "hadoop.auth=" + tokenSigned);
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        JSONObject json = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(conn.getInputStream()));
        json = (JSONObject)json.get((Object)"Token");
        String tokenStr = (String)json.get((Object)"urlString");
        url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=GETHOMEDIRECTORY&delegation=" + tokenStr);
        conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=RENEWDELEGATIONTOKEN&token=" + tokenStr);
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("PUT");
        Assert.assertEquals((long)401L, (long)conn.getResponseCode());
        url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=RENEWDELEGATIONTOKEN&token=" + tokenStr);
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("PUT");
        conn.setRequestProperty("Cookie", "hadoop.auth=" + tokenSigned);
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=CANCELDELEGATIONTOKEN&token=" + tokenStr);
        conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("PUT");
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=GETHOMEDIRECTORY&delegation=" + tokenStr);
        conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)403L, (long)conn.getResponseCode());
    }
}

