/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.http.client.HttpFSKerberosAuthenticator;
import org.apache.hadoop.fs.http.client.HttpFSPseudoAuthenticator;
import org.apache.hadoop.fs.http.client.HttpFSUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.hadoop.security.token.Token;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
public class HttpFSKerberosAuthenticator
extends KerberosAuthenticator {
    private static final String HTTP_GET = "GET";
    private static final String HTTP_PUT = "PUT";
    public static final String DELEGATION_PARAM = "delegation";
    public static final String TOKEN_PARAM = "token";
    public static final String RENEWER_PARAM = "renewer";
    public static final String DELEGATION_TOKEN_JSON = "Token";
    public static final String DELEGATION_TOKEN_URL_STRING_JSON = "urlString";
    public static final String RENEW_DELEGATION_TOKEN_JSON = "long";
    public static final String OP_PARAM = "op";

    protected Authenticator getFallBackAuthenticator() {
        return new HttpFSPseudoAuthenticator();
    }

    public static void injectDelegationToken(Map<String, String> params, Token<?> dtToken) throws IOException {
        if (dtToken != null) {
            params.put(DELEGATION_PARAM, dtToken.encodeToUrlString());
        }
    }

    private boolean hasDelegationToken(URL url) {
        return url.getQuery().contains("delegation=");
    }

    public void authenticate(URL url, AuthenticatedURL.Token token) throws IOException, AuthenticationException {
        if (!this.hasDelegationToken(url)) {
            super.authenticate(url, token);
        }
    }

    public static Token<?> getDelegationToken(URI fsURI, InetSocketAddress httpFSAddr, AuthenticatedURL.Token token, String renewer) throws IOException {
        DelegationTokenOperation op = DelegationTokenOperation.GETDELEGATIONTOKEN;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, op.toString());
        params.put(RENEWER_PARAM, renewer);
        URL url = HttpFSUtils.createHttpURL((Path)new Path(fsURI), params);
        AuthenticatedURL aUrl = new AuthenticatedURL((Authenticator)new HttpFSKerberosAuthenticator());
        try {
            HttpURLConnection conn = aUrl.openConnection(url, token);
            conn.setRequestMethod(op.getHttpMethod());
            HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
            JSONObject json = (JSONObject)((JSONObject)HttpFSUtils.jsonParse((HttpURLConnection)conn)).get((Object)DELEGATION_TOKEN_JSON);
            String tokenStr = (String)json.get((Object)DELEGATION_TOKEN_URL_STRING_JSON);
            Token dToken = new Token();
            dToken.decodeFromUrlString(tokenStr);
            SecurityUtil.setTokenService((Token)dToken, (InetSocketAddress)httpFSAddr);
            return dToken;
        }
        catch (AuthenticationException ex) {
            throw new IOException(ex.toString(), ex);
        }
    }

    public static long renewDelegationToken(URI fsURI, AuthenticatedURL.Token token, Token<?> dToken) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, DelegationTokenOperation.RENEWDELEGATIONTOKEN.toString());
        params.put(TOKEN_PARAM, dToken.encodeToUrlString());
        URL url = HttpFSUtils.createHttpURL((Path)new Path(fsURI), params);
        AuthenticatedURL aUrl = new AuthenticatedURL((Authenticator)new HttpFSKerberosAuthenticator());
        try {
            HttpURLConnection conn = aUrl.openConnection(url, token);
            conn.setRequestMethod(DelegationTokenOperation.RENEWDELEGATIONTOKEN.getHttpMethod());
            HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
            JSONObject json = (JSONObject)((JSONObject)HttpFSUtils.jsonParse((HttpURLConnection)conn)).get((Object)DELEGATION_TOKEN_JSON);
            return (Long)json.get((Object)RENEW_DELEGATION_TOKEN_JSON);
        }
        catch (AuthenticationException ex) {
            throw new IOException(ex.toString(), ex);
        }
    }

    public static void cancelDelegationToken(URI fsURI, AuthenticatedURL.Token token, Token<?> dToken) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(OP_PARAM, DelegationTokenOperation.CANCELDELEGATIONTOKEN.toString());
        params.put(TOKEN_PARAM, dToken.encodeToUrlString());
        URL url = HttpFSUtils.createHttpURL((Path)new Path(fsURI), params);
        AuthenticatedURL aUrl = new AuthenticatedURL((Authenticator)new HttpFSKerberosAuthenticator());
        try {
            HttpURLConnection conn = aUrl.openConnection(url, token);
            conn.setRequestMethod(DelegationTokenOperation.CANCELDELEGATIONTOKEN.getHttpMethod());
            HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
        }
        catch (AuthenticationException ex) {
            throw new IOException(ex.toString(), ex);
        }
    }
}

