/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.service.security;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.lib.server.Server;
import org.apache.hadoop.lib.service.DelegationTokenManager;
import org.apache.hadoop.lib.service.DelegationTokenManagerException;
import org.apache.hadoop.lib.service.security.DelegationTokenManagerService;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.HTestCase;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.util.StringUtils;
import org.junit.Test;

public class TestDelegationTokenManagerService
extends HTestCase {
    @Test
    @TestDir
    public void service() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(DelegationTokenManagerService.class.getName())));
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        DelegationTokenManager tm = (DelegationTokenManager)server.get(DelegationTokenManager.class);
        Assert.assertNotNull((Object)tm);
        server.destroy();
    }

    @Test
    @TestDir
    public void tokens() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(DelegationTokenManagerService.class.getName())));
        HttpFSServerWebApp server = new HttpFSServerWebApp(dir, dir, dir, dir, conf);
        server.setAuthority(new InetSocketAddress(InetAddress.getLocalHost(), 14000));
        server.init();
        DelegationTokenManager tm = (DelegationTokenManager)server.get(DelegationTokenManager.class);
        Token token = tm.createToken(UserGroupInformation.getCurrentUser(), "foo");
        Assert.assertNotNull((Object)token);
        tm.verifyToken(token);
        Assert.assertTrue((tm.renewToken(token, "foo") > System.currentTimeMillis() ? 1 : 0) != 0);
        tm.cancelToken(token, "foo");
        try {
            tm.verifyToken(token);
            Assert.fail();
        }
        catch (DelegationTokenManagerException ex) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
        server.destroy();
    }
}

