/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.client;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.http.client.HttpFSFileSystem;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
public class HttpFSUtils {
    public static final String SERVICE_NAME = "/webhdfs";
    public static final String SERVICE_VERSION = "/v1";
    private static final String SERVICE_PATH = "/webhdfs/v1";

    static URL createHttpURL(Path path, Map<String, String> params) throws IOException {
        URI uri = path.toUri();
        if (!uri.getScheme().equalsIgnoreCase("webhdfs")) {
            throw new IllegalArgumentException(MessageFormat.format("Invalid scheme [{0}] it should be 'webhdfs'", uri));
        }
        String realScheme = "http";
        StringBuilder sb = new StringBuilder();
        sb.append(realScheme).append("://").append(uri.getAuthority()).append("/webhdfs/v1").append(uri.getPath());
        String separator = "?";
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append(separator).append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF8"));
            separator = "&";
        }
        return new URL(sb.toString());
    }

    static void validateResponse(HttpURLConnection conn, int expected) throws IOException {
        int status = conn.getResponseCode();
        if (status != expected) {
            try {
                JSONObject json = (JSONObject)HttpFSUtils.jsonParse((HttpURLConnection)conn);
                json = (JSONObject)json.get((Object)"RemoteException");
                String message = (String)json.get((Object)"message");
                String exception = (String)json.get((Object)"exception");
                String className = (String)json.get((Object)"javaClassName");
                try {
                    ClassLoader cl = HttpFSFileSystem.class.getClassLoader();
                    Class<?> klass = cl.loadClass(className);
                    Constructor<?> constr = klass.getConstructor(String.class);
                    throw (IOException)constr.newInstance(message);
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new IOException(MessageFormat.format("{0} - {1}", exception, message));
                }
            }
            catch (IOException ex) {
                if (ex.getCause() instanceof IOException) {
                    throw (IOException)ex.getCause();
                }
                throw new IOException(MessageFormat.format("HTTP status [{0}], {1}", status, conn.getResponseMessage()));
            }
        }
    }

    static Object jsonParse(HttpURLConnection conn) throws IOException {
        try {
            JSONParser parser = new JSONParser();
            return parser.parse((Reader)new InputStreamReader(conn.getInputStream()));
        }
        catch (ParseException ex) {
            throw new IOException("JSON parser error, " + ex.getMessage(), ex);
        }
    }
}

