/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.AccessControlException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.http.client.HttpFSFileSystem;
import org.apache.hadoop.fs.http.server.FSOperations;
import org.apache.hadoop.fs.http.server.HttpFSParametersProvider;
import org.apache.hadoop.fs.http.server.HttpFSServer;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.lib.service.FileSystemAccess;
import org.apache.hadoop.lib.service.FileSystemAccessException;
import org.apache.hadoop.lib.service.Groups;
import org.apache.hadoop.lib.service.Instrumentation;
import org.apache.hadoop.lib.service.ProxyUser;
import org.apache.hadoop.lib.servlet.FileSystemReleaseFilter;
import org.apache.hadoop.lib.servlet.HostnameFilter;
import org.apache.hadoop.lib.wsrs.InputStreamEntity;
import org.apache.hadoop.lib.wsrs.Parameters;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Path(value="/v1")
@InterfaceAudience.Private
public class HttpFSServer {
    private static Logger AUDIT_LOG = LoggerFactory.getLogger((String)"httpfsaudit");

    private String getEffectiveUser(Principal user, String doAs) throws IOException {
        String effectiveUser = user.getName();
        if (doAs != null && !doAs.equals(user.getName())) {
            ProxyUser proxyUser = (ProxyUser)HttpFSServerWebApp.get().get(ProxyUser.class);
            String proxyUserName = user instanceof AuthenticationToken ? ((AuthenticationToken)user).getUserName() : user.getName();
            proxyUser.validate(proxyUserName, HostnameFilter.get(), doAs);
            effectiveUser = doAs;
            AUDIT_LOG.info("Proxy user [{}] DoAs user [{}]", (Object)proxyUserName, (Object)doAs);
        }
        return effectiveUser;
    }

    private <T> T fsExecute(Principal user, String doAs, FileSystemAccess.FileSystemExecutor<T> executor) throws IOException, FileSystemAccessException {
        String hadoopUser = this.getEffectiveUser(user, doAs);
        FileSystemAccess fsAccess = (FileSystemAccess)HttpFSServerWebApp.get().get(FileSystemAccess.class);
        Configuration conf = ((FileSystemAccess)HttpFSServerWebApp.get().get(FileSystemAccess.class)).getFileSystemConfiguration();
        return (T)fsAccess.execute(hadoopUser, conf, executor);
    }

    private FileSystem createFileSystem(Principal user, String doAs) throws IOException, FileSystemAccessException {
        String hadoopUser = this.getEffectiveUser(user, doAs);
        FileSystemAccess fsAccess = (FileSystemAccess)HttpFSServerWebApp.get().get(FileSystemAccess.class);
        Configuration conf = ((FileSystemAccess)HttpFSServerWebApp.get().get(FileSystemAccess.class)).getFileSystemConfiguration();
        FileSystem fs = fsAccess.createFileSystem(hadoopUser, conf);
        FileSystemReleaseFilter.setFileSystem((FileSystem)fs);
        return fs;
    }

    private void enforceRootPath(HttpFSFileSystem.Operation op, String path) {
        if (!path.equals("/")) {
            throw new UnsupportedOperationException(MessageFormat.format("Operation [{0}], invalid path [{1}], must be '/'", op, path));
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response getRoot(@Context Principal user, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context Parameters params) throws IOException, FileSystemAccessException {
        return this.get(user, "", op, params);
    }

    private String makeAbsolute(String path) {
        return "/" + (path != null ? path : "");
    }

    @GET
    @Path(value="{path:.*}")
    @Produces(value={"application/octet-stream", "application/json"})
    public Response get(@Context Principal user, @PathParam(value="path") String path, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context Parameters params) throws IOException, FileSystemAccessException {
        Response response;
        path = this.makeAbsolute(path);
        MDC.put((String)"op", (String)((HttpFSFileSystem.Operation)op.value()).name());
        String doAs = (String)params.get("doas", HttpFSParametersProvider.DoAsParam.class);
        switch (1.$SwitchMap$org$apache$hadoop$fs$http$client$HttpFSFileSystem$Operation[((HttpFSFileSystem.Operation)op.value()).ordinal()]) {
            case 1: {
                FSOperations.FSOpen command = new FSOperations.FSOpen(path);
                FileSystem fs = this.createFileSystem(user, doAs);
                InputStream is = command.execute(fs);
                Long offset = (Long)params.get("offset", HttpFSParametersProvider.OffsetParam.class);
                Long len = (Long)params.get("length", HttpFSParametersProvider.LenParam.class);
                AUDIT_LOG.info("[{}] offset [{}] len [{}]", new Object[]{path, offset, len});
                InputStreamEntity entity = new InputStreamEntity(is, offset.longValue(), len.longValue());
                response = Response.ok((Object)entity).type("application/octet-stream").build();
                break;
            }
            case 2: {
                FSOperations.FSFileStatus command = new FSOperations.FSFileStatus(path);
                Map json = (Map)this.fsExecute(user, doAs, (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}]", (Object)path);
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
            case 3: {
                String filter = (String)params.get("filter", HttpFSParametersProvider.FilterParam.class);
                FSOperations.FSListStatus command = new FSOperations.FSListStatus(path, filter);
                Map json = (Map)this.fsExecute(user, doAs, (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}] filter [{}]", (Object)path, (Object)(filter != null ? filter : "-"));
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
            case 4: {
                this.enforceRootPath((HttpFSFileSystem.Operation)op.value(), path);
                FSOperations.FSHomeDir command = new FSOperations.FSHomeDir();
                JSONObject json = (JSONObject)this.fsExecute(user, doAs, (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("");
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
            case 5: {
                this.enforceRootPath((HttpFSFileSystem.Operation)op.value(), path);
                Groups groups = (Groups)HttpFSServerWebApp.get().get(Groups.class);
                List userGroups = groups.getGroups(user.getName());
                if (!userGroups.contains(HttpFSServerWebApp.get().getAdminGroup())) {
                    throw new AccessControlException("User not in HttpFSServer admin group");
                }
                Instrumentation instrumentation = (Instrumentation)HttpFSServerWebApp.get().get(Instrumentation.class);
                Map snapshot = instrumentation.getSnapshot();
                response = Response.ok((Object)snapshot).build();
                break;
            }
            case 6: {
                FSOperations.FSContentSummary command = new FSOperations.FSContentSummary(path);
                Map json = (Map)this.fsExecute(user, doAs, (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}]", (Object)path);
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
            case 7: {
                FSOperations.FSFileChecksum command = new FSOperations.FSFileChecksum(path);
                Map json = (Map)this.fsExecute(user, doAs, (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}]", (Object)path);
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
            case 8: {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                break;
            }
            default: {
                throw new IOException(MessageFormat.format("Invalid HTTP GET operation [{0}]", op.value()));
            }
        }
        return response;
    }

    @DELETE
    @Path(value="{path:.*}")
    @Produces(value={"application/json"})
    public Response delete(@Context Principal user, @PathParam(value="path") String path, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context Parameters params) throws IOException, FileSystemAccessException {
        Response response;
        path = this.makeAbsolute(path);
        MDC.put((String)"op", (String)((HttpFSFileSystem.Operation)op.value()).name());
        String doAs = (String)params.get("doas", HttpFSParametersProvider.DoAsParam.class);
        switch (1.$SwitchMap$org$apache$hadoop$fs$http$client$HttpFSFileSystem$Operation[((HttpFSFileSystem.Operation)op.value()).ordinal()]) {
            case 9: {
                Boolean recursive = (Boolean)params.get("recursive", HttpFSParametersProvider.RecursiveParam.class);
                AUDIT_LOG.info("[{}] recursive [{}]", (Object)path, (Object)recursive);
                FSOperations.FSDelete command = new FSOperations.FSDelete(path, recursive.booleanValue());
                JSONObject json = (JSONObject)this.fsExecute(user, doAs, (FileSystemAccess.FileSystemExecutor)command);
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
            default: {
                throw new IOException(MessageFormat.format("Invalid HTTP DELETE operation [{0}]", op.value()));
            }
        }
        return response;
    }

    @POST
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Response post(InputStream is, @Context Principal user, @Context UriInfo uriInfo, @PathParam(value="path") String path, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context Parameters params) throws IOException, FileSystemAccessException {
        Response response;
        path = this.makeAbsolute(path);
        MDC.put((String)"op", (String)((HttpFSFileSystem.Operation)op.value()).name());
        switch (1.$SwitchMap$org$apache$hadoop$fs$http$client$HttpFSFileSystem$Operation[((HttpFSFileSystem.Operation)op.value()).ordinal()]) {
            case 10: {
                String doAs = (String)params.get("doas", HttpFSParametersProvider.DoAsParam.class);
                Boolean hasData = (Boolean)params.get("data", HttpFSParametersProvider.DataParam.class);
                if (!hasData.booleanValue()) {
                    response = Response.temporaryRedirect((URI)this.createUploadRedirectionURL(uriInfo, (Enum)HttpFSFileSystem.Operation.APPEND)).build();
                    break;
                }
                FSOperations.FSAppend command = new FSOperations.FSAppend(is, path);
                this.fsExecute(user, doAs, (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}]", (Object)path);
                response = Response.ok().type("application/json").build();
                break;
            }
            case 11: {
                System.out.println("HTTPFS SERVER CONCAT");
                String sources = (String)params.get("sources", HttpFSParametersProvider.SourcesParam.class);
                FSOperations.FSConcat command = new FSOperations.FSConcat(path, sources.split(","));
                this.fsExecute(user, null, (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}]", (Object)path);
                System.out.println("SENT RESPONSE");
                response = Response.ok().build();
                break;
            }
            default: {
                throw new IOException(MessageFormat.format("Invalid HTTP POST operation [{0}]", op.value()));
            }
        }
        return response;
    }

    protected URI createUploadRedirectionURL(UriInfo uriInfo, Enum<?> uploadOperation) {
        UriBuilder uriBuilder = uriInfo.getRequestUriBuilder();
        uriBuilder = uriBuilder.replaceQueryParam("op", new Object[]{uploadOperation}).queryParam("data", new Object[]{Boolean.TRUE});
        return uriBuilder.build(null);
    }

    @PUT
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Response put(InputStream is, @Context Principal user, @Context UriInfo uriInfo, @PathParam(value="path") String path, @QueryParam(value="op") HttpFSParametersProvider.OperationParam op, @Context Parameters params) throws IOException, FileSystemAccessException {
        Response response;
        path = this.makeAbsolute(path);
        MDC.put((String)"op", (String)((HttpFSFileSystem.Operation)op.value()).name());
        String doAs = (String)params.get("doas", HttpFSParametersProvider.DoAsParam.class);
        switch (1.$SwitchMap$org$apache$hadoop$fs$http$client$HttpFSFileSystem$Operation[((HttpFSFileSystem.Operation)op.value()).ordinal()]) {
            case 12: {
                Boolean hasData = (Boolean)params.get("data", HttpFSParametersProvider.DataParam.class);
                if (!hasData.booleanValue()) {
                    response = Response.temporaryRedirect((URI)this.createUploadRedirectionURL(uriInfo, (Enum)HttpFSFileSystem.Operation.CREATE)).build();
                    break;
                }
                Short permission = (Short)params.get("permission", HttpFSParametersProvider.PermissionParam.class);
                Boolean override = (Boolean)params.get("overwrite", HttpFSParametersProvider.OverwriteParam.class);
                Short replication = (Short)params.get("replication", HttpFSParametersProvider.ReplicationParam.class);
                Long blockSize = (Long)params.get("blocksize", HttpFSParametersProvider.BlockSizeParam.class);
                FSOperations.FSCreate command = new FSOperations.FSCreate(is, path, permission.shortValue(), override.booleanValue(), replication.shortValue(), blockSize.longValue());
                this.fsExecute(user, doAs, (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}] permission [{}] override [{}] replication [{}] blockSize [{}]", new Object[]{path, permission, override, replication, blockSize});
                response = Response.status((Response.Status)Response.Status.CREATED).build();
                break;
            }
            case 13: {
                Short permission = (Short)params.get("permission", HttpFSParametersProvider.PermissionParam.class);
                FSOperations.FSMkdirs command = new FSOperations.FSMkdirs(path, permission.shortValue());
                JSONObject json = (JSONObject)this.fsExecute(user, doAs, (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}] permission [{}]", (Object)path, (Object)permission);
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
            case 14: {
                String toPath = (String)params.get("destination", HttpFSParametersProvider.DestinationParam.class);
                FSOperations.FSRename command = new FSOperations.FSRename(path, toPath);
                JSONObject json = (JSONObject)this.fsExecute(user, doAs, (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}] to [{}]", (Object)path, (Object)toPath);
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
            case 15: {
                String owner = (String)params.get("owner", HttpFSParametersProvider.OwnerParam.class);
                String group = (String)params.get("group", HttpFSParametersProvider.GroupParam.class);
                FSOperations.FSSetOwner command = new FSOperations.FSSetOwner(path, owner, group);
                this.fsExecute(user, doAs, (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}] to (O/G)[{}]", (Object)path, (Object)(owner + ":" + group));
                response = Response.ok().build();
                break;
            }
            case 16: {
                Short permission = (Short)params.get("permission", HttpFSParametersProvider.PermissionParam.class);
                FSOperations.FSSetPermission command = new FSOperations.FSSetPermission(path, permission.shortValue());
                this.fsExecute(user, doAs, (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}] to [{}]", (Object)path, (Object)permission);
                response = Response.ok().build();
                break;
            }
            case 17: {
                Short replication = (Short)params.get("replication", HttpFSParametersProvider.ReplicationParam.class);
                FSOperations.FSSetReplication command = new FSOperations.FSSetReplication(path, replication.shortValue());
                JSONObject json = (JSONObject)this.fsExecute(user, doAs, (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}] to [{}]", (Object)path, (Object)replication);
                response = Response.ok((Object)json).build();
                break;
            }
            case 18: {
                Long modifiedTime = (Long)params.get("modificationtime", HttpFSParametersProvider.ModifiedTimeParam.class);
                Long accessTime = (Long)params.get("accesstime", HttpFSParametersProvider.AccessTimeParam.class);
                FSOperations.FSSetTimes command = new FSOperations.FSSetTimes(path, modifiedTime.longValue(), accessTime.longValue());
                this.fsExecute(user, doAs, (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}] to (M/A)[{}]", (Object)path, (Object)(modifiedTime + ":" + accessTime));
                response = Response.ok().build();
                break;
            }
            default: {
                throw new IOException(MessageFormat.format("Invalid HTTP PUT operation [{0}]", op.value()));
            }
        }
        return response;
    }
}

