/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.lib.util.Check;
import org.apache.hadoop.test.HTestCase;
import org.junit.Assert;
import org.junit.Test;

public class TestCheck
extends HTestCase {
    @Test
    public void notNullNotNull() {
        Assert.assertEquals((Object)Check.notNull((Object)"value", (String)"name"), (Object)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notNullNull() {
        Check.notNull(null, (String)"name");
    }

    @Test
    public void notNullElementsNotNull() {
        Check.notNullElements(new ArrayList(), (String)"name");
        Check.notNullElements(Arrays.asList("a"), (String)"name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notNullElementsNullList() {
        Check.notNullElements(null, (String)"name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notNullElementsNullElements() {
        Check.notNullElements(Arrays.asList("a", "", null), (String)"name");
    }

    @Test
    public void notEmptyElementsNotNull() {
        Check.notEmptyElements(new ArrayList(), (String)"name");
        Check.notEmptyElements(Arrays.asList("a"), (String)"name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notEmptyElementsNullList() {
        Check.notEmptyElements(null, (String)"name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notEmptyElementsNullElements() {
        Check.notEmptyElements(Arrays.asList("a", null), (String)"name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notEmptyElementsEmptyElements() {
        Check.notEmptyElements(Arrays.asList("a", ""), (String)"name");
    }

    @Test
    public void notEmptyNotEmtpy() {
        Assert.assertEquals((Object)Check.notEmpty((String)"value", (String)"name"), (Object)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notEmptyNull() {
        Check.notEmpty(null, (String)"name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notEmptyEmpty() {
        Check.notEmpty((String)"", (String)"name");
    }

    @Test
    public void validIdentifierValid() throws Exception {
        Assert.assertEquals((Object)Check.validIdentifier((String)"a", (int)1, (String)""), (Object)"a");
        Assert.assertEquals((Object)Check.validIdentifier((String)"a1", (int)2, (String)""), (Object)"a1");
        Assert.assertEquals((Object)Check.validIdentifier((String)"a_", (int)3, (String)""), (Object)"a_");
        Assert.assertEquals((Object)Check.validIdentifier((String)"_", (int)1, (String)""), (Object)"_");
    }

    @Test(expected=IllegalArgumentException.class)
    public void validIdentifierInvalid1() throws Exception {
        Check.validIdentifier((String)"!", (int)1, (String)"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void validIdentifierInvalid2() throws Exception {
        Check.validIdentifier((String)"a1", (int)1, (String)"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void validIdentifierInvalid3() throws Exception {
        Check.validIdentifier((String)"1", (int)1, (String)"");
    }

    @Test
    public void checkGTZeroGreater() {
        Assert.assertEquals((long)Check.gt0((int)120, (String)"test"), (long)120L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkGTZeroZero() {
        Check.gt0((int)0, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkGTZeroLessThanZero() {
        Check.gt0((int)-1, (String)"test");
    }

    @Test
    public void checkGEZero() {
        Assert.assertEquals((long)Check.ge0((int)120, (String)"test"), (long)120L);
        Assert.assertEquals((long)Check.ge0((int)0, (String)"test"), (long)0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkGELessThanZero() {
        Check.ge0((int)-1, (String)"test");
    }
}

