/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DelegationTokenRenewer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.http.client.HttpFSFileSystem;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.HFSTestCase;
import org.apache.hadoop.test.KerberosTestUtils;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.test.TestHdfs;
import org.apache.hadoop.test.TestHdfsHelper;
import org.apache.hadoop.test.TestJetty;
import org.apache.hadoop.test.TestJettyHelper;
import org.junit.After;
import org.junit.Test;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;

public class TestHttpFSWithKerberos
extends HFSTestCase {
    @After
    public void resetUGI() {
        Configuration conf = new Configuration();
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    private void createHttpFSServer() throws Exception {
        File homeDir = TestDirHelper.getTestDir();
        Assert.assertTrue((boolean)new File(homeDir, "conf").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "log").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "temp").mkdir());
        HttpFSServerWebApp.setHomeDirForCurrentThread((String)homeDir.getAbsolutePath());
        File secretFile = new File(new File(homeDir, "conf"), "secret");
        FileWriter w = new FileWriter(secretFile);
        w.write("secret");
        ((Writer)w).close();
        File hadoopConfDir = new File(new File(homeDir, "conf"), "hadoop-conf");
        hadoopConfDir.mkdirs();
        String fsDefaultName = TestHdfsHelper.getHdfsConf().get("fs.defaultFS");
        Configuration conf = new Configuration(false);
        conf.set("fs.defaultFS", fsDefaultName);
        File hdfsSite = new File(hadoopConfDir, "hdfs-site.xml");
        FileOutputStream os = new FileOutputStream(hdfsSite);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        conf = new Configuration(false);
        conf.set("httpfs.proxyuser.client.hosts", "*");
        conf.set("httpfs.proxyuser.client.groups", "*");
        conf.set("httpfs.authentication.type", "kerberos");
        conf.set("httpfs.authentication.signature.secret.file", secretFile.getAbsolutePath());
        File httpfsSite = new File(new File(homeDir, "conf"), "httpfs-site.xml");
        os = new FileOutputStream(httpfsSite);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource("webapp");
        WebAppContext context = new WebAppContext(url.getPath(), "/webhdfs");
        Server server = TestJettyHelper.getJettyServer();
        server.addHandler((Handler)context);
        server.start();
        HttpFSServerWebApp.get().setAuthority(TestJettyHelper.getAuthority());
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testValidHttpFSAccess() throws Exception {
        this.createHttpFSServer();
        KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testInvalidadHttpFSAccess() throws Exception {
        this.createHttpFSServer();
        URL url = new URL(TestJettyHelper.getJettyURL(), "/webhdfs/v1/?op=GETHOMEDIRECTORY");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((int)conn.getResponseCode(), (int)401);
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testDelegationTokenHttpFSAccess() throws Exception {
        this.createHttpFSServer();
        KerberosTestUtils.doAsClient((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void testDelegationTokenWithFS(Class fileSystemClass) throws Exception {
        this.createHttpFSServer();
        Configuration conf = new Configuration();
        conf.set("fs.webhdfs.impl", fileSystemClass.getName());
        conf.set("fs.hdfs.impl.disable.cache", "true");
        URI uri = new URI("webhdfs://" + TestJettyHelper.getJettyURL().toURI().getAuthority());
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        Token[] tokens = fs.addDelegationTokens("foo", null);
        fs.close();
        Assert.assertEquals((int)1, (int)tokens.length);
        fs = FileSystem.get((URI)uri, (Configuration)conf);
        ((DelegationTokenRenewer.Renewable)fs).setDelegationToken(tokens[0]);
        fs.listStatus(new Path("/"));
        fs.close();
    }

    private void testDelegationTokenWithinDoAs(Class fileSystemClass, boolean proxyUser) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation.loginUserFromKeytab((String)"client", (String)"/Users/tucu/tucu.keytab");
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        if (proxyUser) {
            ugi = UserGroupInformation.createProxyUser((String)"foo", (UserGroupInformation)ugi);
        }
        conf = new Configuration();
        UserGroupInformation.setConfiguration((Configuration)conf);
        ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testDelegationTokenWithHttpFSFileSystem() throws Exception {
        this.testDelegationTokenWithinDoAs(HttpFSFileSystem.class, false);
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testDelegationTokenWithWebhdfsFileSystem() throws Exception {
        this.testDelegationTokenWithinDoAs(WebHdfsFileSystem.class, false);
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testDelegationTokenWithHttpFSFileSystemProxyUser() throws Exception {
        this.testDelegationTokenWithinDoAs(HttpFSFileSystem.class, true);
    }

    static /* synthetic */ void access$000(TestHttpFSWithKerberos x0, Class x1) throws Exception {
        x0.testDelegationTokenWithFS(x1);
    }
}

