/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.http.client.BaseTestHttpFSWith;
import org.apache.hadoop.fs.http.client.HttpFSFileSystem;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.HFSTestCase;
import org.apache.hadoop.test.HadoopUsersConfTestHelper;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.test.TestHdfs;
import org.apache.hadoop.test.TestJetty;
import org.apache.hadoop.test.TestJettyHelper;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;

/*
 * Exception performing whole class analysis ignored.
 */
@RunWith(value=Parameterized.class)
public abstract class BaseTestHttpFSWith
extends HFSTestCase {
    private Operation operation;

    protected abstract Path getProxiedFSTestDir();

    protected abstract String getProxiedFSURI();

    protected abstract Configuration getProxiedFSConf();

    protected boolean isLocalFS() {
        return this.getProxiedFSURI().startsWith("file://");
    }

    private void createHttpFSServer() throws Exception {
        File homeDir = TestDirHelper.getTestDir();
        Assert.assertTrue((boolean)new File(homeDir, "conf").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "log").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "temp").mkdir());
        HttpFSServerWebApp.setHomeDirForCurrentThread((String)homeDir.getAbsolutePath());
        File secretFile = new File(new File(homeDir, "conf"), "secret");
        FileWriter w = new FileWriter(secretFile);
        w.write("secret");
        ((Writer)w).close();
        String fsDefaultName = this.getProxiedFSURI();
        Configuration conf = new Configuration(false);
        conf.set("fs.defaultFS", fsDefaultName);
        File hdfsSite = new File(new File(homeDir, "conf"), "hdfs-site.xml");
        FileOutputStream os = new FileOutputStream(hdfsSite);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        conf = new Configuration(false);
        conf.set("httpfs.proxyuser." + HadoopUsersConfTestHelper.getHadoopProxyUser() + ".groups", HadoopUsersConfTestHelper.getHadoopProxyUserGroups());
        conf.set("httpfs.proxyuser." + HadoopUsersConfTestHelper.getHadoopProxyUser() + ".hosts", HadoopUsersConfTestHelper.getHadoopProxyUserHosts());
        conf.set("httpfs.authentication.signature.secret.file", secretFile.getAbsolutePath());
        File httpfsSite = new File(new File(homeDir, "conf"), "httpfs-site.xml");
        os = new FileOutputStream(httpfsSite);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource("webapp");
        WebAppContext context = new WebAppContext(url.getPath(), "/webhdfs");
        Server server = TestJettyHelper.getJettyServer();
        server.addHandler((Handler)context);
        server.start();
    }

    protected Class getFileSystemClass() {
        return HttpFSFileSystem.class;
    }

    protected FileSystem getHttpFSFileSystem() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.webhdfs.impl", this.getFileSystemClass().getName());
        URI uri = new URI("webhdfs://" + TestJettyHelper.getJettyURL().toURI().getAuthority());
        return FileSystem.get((URI)uri, (Configuration)conf);
    }

    protected void testGet() throws Exception {
        FileSystem fs = this.getHttpFSFileSystem();
        Assert.assertNotNull((Object)fs);
        URI uri = new URI("webhdfs://" + TestJettyHelper.getJettyURL().toURI().getAuthority());
        Assert.assertEquals((Object)fs.getUri(), (Object)uri);
        fs.close();
    }

    private void testOpen() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
        FSDataOutputStream os = fs.create(path);
        os.write(1);
        os.close();
        fs.close();
        fs = this.getHttpFSFileSystem();
        FSDataInputStream is = fs.open(new Path(path.toUri().getPath()));
        Assert.assertEquals((long)is.read(), (long)1L);
        is.close();
        fs.close();
    }

    private void testCreate(Path path, boolean override) throws Exception {
        FileSystem fs = this.getHttpFSFileSystem();
        FsPermission permission = new FsPermission(FsAction.READ_WRITE, FsAction.NONE, FsAction.NONE);
        FSDataOutputStream os = fs.create(new Path(path.toUri().getPath()), permission, override, 1024, (short)2, 0x6400000L, null);
        os.write(1);
        os.close();
        fs.close();
        fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        FileStatus status = fs.getFileStatus(path);
        if (!this.isLocalFS()) {
            Assert.assertEquals((long)status.getReplication(), (long)2L);
            Assert.assertEquals((long)status.getBlockSize(), (long)0x6400000L);
        }
        Assert.assertEquals((Object)status.getPermission(), (Object)permission);
        FSDataInputStream is = fs.open(path);
        Assert.assertEquals((long)is.read(), (long)1L);
        is.close();
        fs.close();
    }

    private void testCreate() throws Exception {
        Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
        this.testCreate(path, false);
        this.testCreate(path, true);
        try {
            this.testCreate(path, false);
            Assert.fail((String)"the create should have failed because the file exists and override is FALSE");
        }
        catch (IOException ex) {
        }
        catch (Exception ex) {
            Assert.fail((String)ex.toString());
        }
    }

    private void testAppend() throws Exception {
        if (!this.isLocalFS()) {
            FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            fs.mkdirs(this.getProxiedFSTestDir());
            Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
            FSDataOutputStream os = fs.create(path);
            os.write(1);
            os.close();
            fs.close();
            fs = this.getHttpFSFileSystem();
            os = fs.append(new Path(path.toUri().getPath()));
            os.write(2);
            os.close();
            fs.close();
            fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            FSDataInputStream is = fs.open(path);
            Assert.assertEquals((long)is.read(), (long)1L);
            Assert.assertEquals((long)is.read(), (long)2L);
            Assert.assertEquals((long)is.read(), (long)-1L);
            is.close();
            fs.close();
        }
    }

    private void testConcat() throws Exception {
        Configuration config = this.getProxiedFSConf();
        config.setLong("dfs.blocksize", 1024L);
        if (!this.isLocalFS()) {
            FileSystem fs = FileSystem.get((Configuration)config);
            fs.mkdirs(this.getProxiedFSTestDir());
            Path path1 = new Path("/test/foo.txt");
            Path path2 = new Path("/test/bar.txt");
            Path path3 = new Path("/test/derp.txt");
            DFSTestUtil.createFile((FileSystem)fs, (Path)path1, (long)1024L, (short)3, (long)0L);
            DFSTestUtil.createFile((FileSystem)fs, (Path)path2, (long)1024L, (short)3, (long)0L);
            DFSTestUtil.createFile((FileSystem)fs, (Path)path3, (long)1024L, (short)3, (long)0L);
            fs.close();
            fs = this.getHttpFSFileSystem();
            fs.concat(path1, new Path[]{path2, path3});
            fs.close();
            fs = FileSystem.get((Configuration)config);
            Assert.assertTrue((boolean)fs.exists(path1));
            Assert.assertFalse((boolean)fs.exists(path2));
            Assert.assertFalse((boolean)fs.exists(path3));
            fs.close();
        }
    }

    private void testRename() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Path path = new Path(this.getProxiedFSTestDir(), "foo");
        fs.mkdirs(path);
        fs.close();
        fs = this.getHttpFSFileSystem();
        Path oldPath = new Path(path.toUri().getPath());
        Path newPath = new Path(path.getParent(), "bar");
        fs.rename(oldPath, newPath);
        fs.close();
        fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Assert.assertFalse((boolean)fs.exists(oldPath));
        Assert.assertTrue((boolean)fs.exists(newPath));
        fs.close();
    }

    private void testDelete() throws Exception {
        Path foo = new Path(this.getProxiedFSTestDir(), "foo");
        Path bar = new Path(this.getProxiedFSTestDir(), "bar");
        Path foe = new Path(this.getProxiedFSTestDir(), "foe");
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        fs.mkdirs(foo);
        fs.mkdirs(new Path(bar, "a"));
        fs.mkdirs(foe);
        FileSystem hoopFs = this.getHttpFSFileSystem();
        Assert.assertTrue((boolean)hoopFs.delete(new Path(foo.toUri().getPath()), false));
        Assert.assertFalse((boolean)fs.exists(foo));
        try {
            hoopFs.delete(new Path(bar.toUri().getPath()), false);
            Assert.fail();
        }
        catch (IOException ex) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
        Assert.assertTrue((boolean)fs.exists(bar));
        Assert.assertTrue((boolean)hoopFs.delete(new Path(bar.toUri().getPath()), true));
        Assert.assertFalse((boolean)fs.exists(bar));
        Assert.assertTrue((boolean)fs.exists(foe));
        Assert.assertTrue((boolean)hoopFs.delete(foe, true));
        Assert.assertFalse((boolean)fs.exists(foe));
        hoopFs.close();
        fs.close();
    }

    private void testListStatus() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
        FSDataOutputStream os = fs.create(path);
        os.write(1);
        os.close();
        FileStatus status1 = fs.getFileStatus(path);
        fs.close();
        fs = this.getHttpFSFileSystem();
        FileStatus status2 = fs.getFileStatus(new Path(path.toUri().getPath()));
        fs.close();
        Assert.assertEquals((Object)status2.getPermission(), (Object)status1.getPermission());
        Assert.assertEquals((Object)status2.getPath().toUri().getPath(), (Object)status1.getPath().toUri().getPath());
        Assert.assertEquals((long)status2.getReplication(), (long)status1.getReplication());
        Assert.assertEquals((long)status2.getBlockSize(), (long)status1.getBlockSize());
        Assert.assertEquals((long)status2.getAccessTime(), (long)status1.getAccessTime());
        Assert.assertEquals((long)status2.getModificationTime(), (long)status1.getModificationTime());
        Assert.assertEquals((Object)status2.getOwner(), (Object)status1.getOwner());
        Assert.assertEquals((Object)status2.getGroup(), (Object)status1.getGroup());
        Assert.assertEquals((long)status2.getLen(), (long)status1.getLen());
        FileStatus[] stati = fs.listStatus(path.getParent());
        Assert.assertEquals((long)stati.length, (long)1L);
        Assert.assertEquals((Object)stati[0].getPath().getName(), (Object)path.getName());
    }

    private void testWorkingdirectory() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Path workingDir = fs.getWorkingDirectory();
        fs.close();
        fs = this.getHttpFSFileSystem();
        if (this.isLocalFS()) {
            fs.setWorkingDirectory(workingDir);
        }
        Path httpFSWorkingDir = fs.getWorkingDirectory();
        fs.close();
        Assert.assertEquals((Object)httpFSWorkingDir.toUri().getPath(), (Object)workingDir.toUri().getPath());
        fs = this.getHttpFSFileSystem();
        fs.setWorkingDirectory(new Path("/tmp"));
        workingDir = fs.getWorkingDirectory();
        fs.close();
        Assert.assertEquals((Object)workingDir.toUri().getPath(), (Object)new Path("/tmp").toUri().getPath());
    }

    private void testMkdirs() throws Exception {
        Path path = new Path(this.getProxiedFSTestDir(), "foo");
        FileSystem fs = this.getHttpFSFileSystem();
        fs.mkdirs(path);
        fs.close();
        fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Assert.assertTrue((boolean)fs.exists(path));
        fs.close();
    }

    private void testSetTimes() throws Exception {
        if (!this.isLocalFS()) {
            FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
            FSDataOutputStream os = fs.create(path);
            os.write(1);
            os.close();
            FileStatus status1 = fs.getFileStatus(path);
            fs.close();
            long at = status1.getAccessTime();
            long mt = status1.getModificationTime();
            fs = this.getHttpFSFileSystem();
            fs.setTimes(path, mt - 10L, at - 20L);
            fs.close();
            fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            status1 = fs.getFileStatus(path);
            fs.close();
            long atNew = status1.getAccessTime();
            long mtNew = status1.getModificationTime();
            Assert.assertEquals((long)mtNew, (long)(mt - 10L));
            Assert.assertEquals((long)atNew, (long)(at - 20L));
        }
    }

    protected void testSetPermission() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Path path = new Path(this.getProxiedFSTestDir(), "foodir");
        fs.mkdirs(path);
        fs = this.getHttpFSFileSystem();
        FsPermission permission1 = new FsPermission(FsAction.READ_WRITE, FsAction.NONE, FsAction.NONE);
        fs.setPermission(path, permission1);
        fs.close();
        fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        FileStatus status1 = fs.getFileStatus(path);
        fs.close();
        FsPermission permission2 = status1.getPermission();
        Assert.assertEquals((Object)permission2, (Object)permission1);
        fs = this.getHttpFSFileSystem();
        permission1 = new FsPermission(FsAction.READ_WRITE, FsAction.NONE, FsAction.NONE, true);
        fs.setPermission(path, permission1);
        fs.close();
        fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        status1 = fs.getFileStatus(path);
        fs.close();
        permission2 = status1.getPermission();
        Assert.assertTrue((boolean)permission2.getStickyBit());
        Assert.assertEquals((Object)permission2, (Object)permission1);
    }

    private void testSetOwner() throws Exception {
        if (!this.isLocalFS()) {
            FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            fs.mkdirs(this.getProxiedFSTestDir());
            Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
            FSDataOutputStream os = fs.create(path);
            os.write(1);
            os.close();
            fs.close();
            fs = this.getHttpFSFileSystem();
            String user = HadoopUsersConfTestHelper.getHadoopUsers()[1];
            String group = HadoopUsersConfTestHelper.getHadoopUserGroups((String)user)[0];
            fs.setOwner(path, user, group);
            fs.close();
            fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            FileStatus status1 = fs.getFileStatus(path);
            fs.close();
            Assert.assertEquals((Object)status1.getOwner(), (Object)user);
            Assert.assertEquals((Object)status1.getGroup(), (Object)group);
        }
    }

    private void testSetReplication() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
        FSDataOutputStream os = fs.create(path);
        os.write(1);
        os.close();
        fs.close();
        fs.setReplication(path, (short)2);
        fs = this.getHttpFSFileSystem();
        fs.setReplication(path, (short)1);
        fs.close();
        fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        FileStatus status1 = fs.getFileStatus(path);
        fs.close();
        Assert.assertEquals((long)status1.getReplication(), (long)1L);
    }

    private void testChecksum() throws Exception {
        if (!this.isLocalFS()) {
            FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
            fs.mkdirs(this.getProxiedFSTestDir());
            Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
            FSDataOutputStream os = fs.create(path);
            os.write(1);
            os.close();
            FileChecksum hdfsChecksum = fs.getFileChecksum(path);
            fs.close();
            fs = this.getHttpFSFileSystem();
            FileChecksum httpChecksum = fs.getFileChecksum(path);
            fs.close();
            Assert.assertEquals((Object)httpChecksum.getAlgorithmName(), (Object)hdfsChecksum.getAlgorithmName());
            Assert.assertEquals((long)httpChecksum.getLength(), (long)hdfsChecksum.getLength());
            Assert.assertArrayEquals((byte[])httpChecksum.getBytes(), (byte[])hdfsChecksum.getBytes());
        }
    }

    private void testContentSummary() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.getProxiedFSConf());
        Path path = new Path(this.getProxiedFSTestDir(), "foo.txt");
        FSDataOutputStream os = fs.create(path);
        os.write(1);
        os.close();
        ContentSummary hdfsContentSummary = fs.getContentSummary(path);
        fs.close();
        fs = this.getHttpFSFileSystem();
        ContentSummary httpContentSummary = fs.getContentSummary(path);
        fs.close();
        Assert.assertEquals((long)httpContentSummary.getDirectoryCount(), (long)hdfsContentSummary.getDirectoryCount());
        Assert.assertEquals((long)httpContentSummary.getFileCount(), (long)hdfsContentSummary.getFileCount());
        Assert.assertEquals((long)httpContentSummary.getLength(), (long)hdfsContentSummary.getLength());
        Assert.assertEquals((long)httpContentSummary.getQuota(), (long)hdfsContentSummary.getQuota());
        Assert.assertEquals((long)httpContentSummary.getSpaceConsumed(), (long)hdfsContentSummary.getSpaceConsumed());
        Assert.assertEquals((long)httpContentSummary.getSpaceQuota(), (long)hdfsContentSummary.getSpaceQuota());
    }

    private void operation(Operation op) throws Exception {
        switch (2.$SwitchMap$org$apache$hadoop$fs$http$client$BaseTestHttpFSWith$Operation[op.ordinal()]) {
            case 1: {
                this.testGet();
                break;
            }
            case 2: {
                this.testOpen();
                break;
            }
            case 3: {
                this.testCreate();
                break;
            }
            case 4: {
                this.testAppend();
                break;
            }
            case 5: {
                this.testConcat();
            }
            case 6: {
                this.testRename();
                break;
            }
            case 7: {
                this.testDelete();
                break;
            }
            case 8: {
                this.testListStatus();
                break;
            }
            case 9: {
                this.testWorkingdirectory();
                break;
            }
            case 10: {
                this.testMkdirs();
                break;
            }
            case 11: {
                this.testSetTimes();
                break;
            }
            case 12: {
                this.testSetPermission();
                break;
            }
            case 13: {
                this.testSetOwner();
                break;
            }
            case 14: {
                this.testSetReplication();
                break;
            }
            case 15: {
                this.testChecksum();
                break;
            }
            case 16: {
                this.testContentSummary();
            }
        }
    }

    @Parameterized.Parameters
    public static Collection operations() {
        Object[][] ops = new Object[Operation.values().length][];
        for (int i = 0; i < Operation.values().length; ++i) {
            ops[i] = new Object[]{Operation.values()[i]};
        }
        return Arrays.asList(ops);
    }

    public BaseTestHttpFSWith(Operation operation) {
        this.operation = operation;
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testOperation() throws Exception {
        this.createHttpFSServer();
        this.operation(this.operation);
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testOperationDoAs() throws Exception {
        this.createHttpFSServer();
        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)HadoopUsersConfTestHelper.getHadoopUsers()[0], (UserGroupInformation)UserGroupInformation.getCurrentUser());
        ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Operation access$000(BaseTestHttpFSWith x0) {
        return x0.operation;
    }

    static /* synthetic */ void access$100(BaseTestHttpFSWith x0, Operation x1) throws Exception {
        x0.operation(x1);
    }
}

