/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapred.gridmix.CompressionEmulationUtil;
import org.apache.hadoop.mapred.gridmix.GenerateData;
import org.apache.hadoop.mapred.gridmix.RandomTextDataGenerator;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
class CompressionEmulationUtil {
    static final Log LOG = LogFactory.getLog(CompressionEmulationUtil.class);
    private static final String COMPRESSION_EMULATION_ENABLE = "gridmix.compression-emulation.enable";
    private static final String INPUT_DECOMPRESSION_EMULATION_ENABLE = "gridmix.compression-emulation.input-decompression.enable";
    private static final String GRIDMIX_MAP_INPUT_COMPRESSION_RATIO = "gridmix.compression-emulation.map-input.decompression-ratio";
    private static final String GRIDMIX_MAP_OUTPUT_COMPRESSION_RATIO = "gridmix.compression-emulation.map-output.compression-ratio";
    private static final String GRIDMIX_JOB_OUTPUT_COMPRESSION_RATIO = "gridmix.compression-emulation.job-output.compression-ratio";
    static final float DEFAULT_COMPRESSION_RATIO = 0.5f;
    private static final CompressionRatioLookupTable COMPRESSION_LOOKUP_TABLE = new CompressionRatioLookupTable();
    private static final Charset charsetUTF8 = Charset.forName("UTF-8");

    CompressionEmulationUtil() {
    }

    static void configure(Job job) throws IOException, InterruptedException, ClassNotFoundException {
        job.setMapperClass(RandomTextDataMapper.class);
        job.setNumReduceTasks(0);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setInputFormatClass(GenerateData.GenDataFormat.class);
        job.setJarByClass(GenerateData.class);
        org.apache.hadoop.mapreduce.lib.output.FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
        try {
            org.apache.hadoop.mapreduce.lib.input.FileInputFormat.addInputPath((Job)job, (Path)new Path("ignored"));
        }
        catch (IOException e) {
            LOG.error((Object)"Error while adding input path ", (Throwable)e);
        }
    }

    static void setupDataGeneratorConfig(Configuration conf) {
        boolean compress = CompressionEmulationUtil.isCompressionEmulationEnabled((Configuration)conf);
        if (compress) {
            float ratio = CompressionEmulationUtil.getMapInputCompressionEmulationRatio((Configuration)conf);
            LOG.info((Object)("GridMix is configured to generate compressed input data with  a compression ratio of " + ratio));
            int wordSize = COMPRESSION_LOOKUP_TABLE.getWordSizeForRatio(ratio);
            RandomTextDataGenerator.setRandomTextDataGeneratorWordSize((Configuration)conf, (int)wordSize);
            RandomTextDataGenerator.setRandomTextDataGeneratorListSize((Configuration)conf, (int)200);
        }
    }

    static RandomTextDataGenerator getRandomTextDataGenerator(float ratio, long seed) {
        int wordSize = COMPRESSION_LOOKUP_TABLE.getWordSizeForRatio(ratio);
        RandomTextDataGenerator rtg = new RandomTextDataGenerator(200, Long.valueOf(seed), wordSize);
        return rtg;
    }

    static GenerateData.DataStatistics publishCompressedDataStatistics(Path inputDir, Configuration conf, long uncompressedDataSize) throws IOException {
        FileStatus[] outFileStatuses;
        FileSystem fs = inputDir.getFileSystem(conf);
        CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(conf);
        long compressedDataSize = 0L;
        int numCompressedFiles = 0;
        for (FileStatus status : outFileStatuses = fs.listStatus(inputDir, (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter())) {
            CompressionCodec codec;
            if (compressionCodecs == null || (codec = compressionCodecs.getCodec(status.getPath())) == null) continue;
            ++numCompressedFiles;
            compressedDataSize += status.getLen();
        }
        LOG.info((Object)"Gridmix is configured to use compressed input data.");
        LOG.info((Object)("Total size of compressed input data : " + StringUtils.humanReadableInt((long)compressedDataSize)));
        LOG.info((Object)("Total number of compressed input data files : " + numCompressedFiles));
        if (numCompressedFiles == 0) {
            throw new RuntimeException("No compressed file found in the input directory : " + inputDir.toString() + ". To enable compression" + " emulation, run Gridmix either with " + " an input directory containing compressed input file(s) or" + " use the -generate option to (re)generate it. If compression" + " emulation is not desired, disable it by setting '" + "gridmix.compression-emulation.enable" + "' to 'false'.");
        }
        if (uncompressedDataSize > 0L) {
            double ratio = (double)compressedDataSize / (double)uncompressedDataSize;
            LOG.info((Object)("Input Data Compression Ratio : " + ratio));
        }
        return new GenerateData.DataStatistics(compressedDataSize, (long)numCompressedFiles, true);
    }

    static void setCompressionEmulationEnabled(Configuration conf, boolean val) {
        conf.setBoolean("gridmix.compression-emulation.enable", val);
    }

    static boolean isCompressionEmulationEnabled(Configuration conf) {
        return conf.getBoolean("gridmix.compression-emulation.enable", true);
    }

    static void setInputCompressionEmulationEnabled(Configuration conf, boolean val) {
        conf.setBoolean("gridmix.compression-emulation.input-decompression.enable", val);
    }

    static boolean isInputCompressionEmulationEnabled(Configuration conf) {
        return conf.getBoolean("gridmix.compression-emulation.input-decompression.enable", false);
    }

    static void setMapInputCompressionEmulationRatio(Configuration conf, float ratio) {
        conf.setFloat("gridmix.compression-emulation.map-input.decompression-ratio", ratio);
    }

    static float getMapInputCompressionEmulationRatio(Configuration conf) {
        return conf.getFloat("gridmix.compression-emulation.map-input.decompression-ratio", 0.5f);
    }

    static void setMapOutputCompressionEmulationRatio(Configuration conf, float ratio) {
        conf.setFloat("gridmix.compression-emulation.map-output.compression-ratio", ratio);
    }

    static float getMapOutputCompressionEmulationRatio(Configuration conf) {
        return conf.getFloat("gridmix.compression-emulation.map-output.compression-ratio", 0.5f);
    }

    static void setJobOutputCompressionEmulationRatio(Configuration conf, float ratio) {
        conf.setFloat("gridmix.compression-emulation.job-output.compression-ratio", ratio);
    }

    static float getJobOutputCompressionEmulationRatio(Configuration conf) {
        return conf.getFloat("gridmix.compression-emulation.job-output.compression-ratio", 0.5f);
    }

    static float standardizeCompressionRatio(float ratio) {
        int significant = Math.round(ratio * 100.0f);
        return (float)significant / 100.0f;
    }

    static InputStream getPossiblyDecompressedInputStream(Path file, Configuration conf, long offset) throws IOException {
        Decompressor decompressor;
        CompressionCodecFactory compressionCodecs;
        CompressionCodec codec;
        FileSystem fs = file.getFileSystem(conf);
        if (CompressionEmulationUtil.isCompressionEmulationEnabled((Configuration)conf) && CompressionEmulationUtil.isInputCompressionEmulationEnabled((Configuration)conf) && (codec = (compressionCodecs = new CompressionCodecFactory(conf)).getCodec(file)) != null && (decompressor = CodecPool.getDecompressor((CompressionCodec)codec)) != null) {
            CompressionInputStream in = codec.createInputStream((InputStream)fs.open(file), decompressor);
            return in;
        }
        FSDataInputStream in = fs.open(file);
        in.seek(offset);
        return in;
    }

    static OutputStream getPossiblyCompressedOutputStream(Path file, Configuration conf) throws IOException {
        FileSystem fs = file.getFileSystem(conf);
        JobConf jConf = new JobConf(conf);
        if (FileOutputFormat.getCompressOutput((JobConf)jConf)) {
            Class codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jConf, GzipCodec.class);
            CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            file = file.suffix(codec.getDefaultExtension());
            if (CompressionEmulationUtil.isCompressionEmulationEnabled((Configuration)conf)) {
                FSDataOutputStream fileOut = fs.create(file, false);
                return new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fileOut));
            }
        }
        return fs.create(file, false);
    }

    static void configureCompressionEmulation(Configuration source, Configuration target) {
        String jobOutputCompressionType;
        target.setBoolean("mapreduce.output.fileoutputformat.compress", source.getBoolean("mapreduce.output.fileoutputformat.compress", false));
        String jobOutputCompressionCodec = source.get("mapreduce.output.fileoutputformat.compress.codec");
        if (jobOutputCompressionCodec != null) {
            target.set("mapreduce.output.fileoutputformat.compress.codec", jobOutputCompressionCodec);
        }
        if ((jobOutputCompressionType = source.get("mapreduce.output.fileoutputformat.compress.type")) != null) {
            target.set("mapreduce.output.fileoutputformat.compress.type", jobOutputCompressionType);
        }
        target.setBoolean("mapreduce.map.output.compress", source.getBoolean("mapreduce.map.output.compress", false));
        String mapOutputCompressionCodec = source.get("mapreduce.map.output.compress.codec");
        if (mapOutputCompressionCodec != null) {
            target.set("mapreduce.map.output.compress.codec", mapOutputCompressionCodec);
        }
        Path[] inputs = FileInputFormat.getInputPaths((JobConf)new JobConf(source));
        boolean needsCompressedInput = false;
        CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(source);
        for (Path input : inputs) {
            CompressionCodec codec = compressionCodecs.getCodec(input);
            if (codec == null) continue;
            needsCompressedInput = true;
        }
        CompressionEmulationUtil.setInputCompressionEmulationEnabled((Configuration)target, (boolean)needsCompressedInput);
    }

    static long getUncompressedInputBytes(long possiblyCompressedInputBytes, Configuration conf) {
        long uncompressedInputBytes = possiblyCompressedInputBytes;
        if (CompressionEmulationUtil.isInputCompressionEmulationEnabled((Configuration)conf)) {
            float inputCompressionRatio = CompressionEmulationUtil.getMapInputCompressionEmulationRatio((Configuration)conf);
            uncompressedInputBytes = (long)((float)uncompressedInputBytes / inputCompressionRatio);
        }
        return uncompressedInputBytes;
    }

    static /* synthetic */ Charset access$000() {
        return charsetUTF8;
    }
}

