/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.gridmix.DebugJobProducer;
import org.apache.hadoop.mapred.gridmix.DistributedCacheEmulator;
import org.apache.hadoop.mapred.gridmix.GenerateDistCacheData;
import org.apache.hadoop.mapred.gridmix.GridmixTestUtils;
import org.apache.hadoop.mapred.gridmix.JobCreator;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.rumen.JobStoryProducer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDistCacheEmulation {
    private DistributedCacheEmulator dce = null;

    @BeforeClass
    public static void init() throws IOException {
        GridmixTestUtils.initCluster(TestDistCacheEmulation.class);
        File target = new File("target" + File.separator + TestDistCacheEmulation.class.getName());
        if (!target.exists()) {
            Assert.assertTrue((boolean)target.mkdirs());
        }
    }

    @AfterClass
    public static void shutDown() throws IOException {
        GridmixTestUtils.shutdownCluster();
    }

    private void validateDistCacheData(Configuration jobConf, long[] sortedFileSizes) throws FileNotFoundException, IOException {
        Path distCachePath = this.dce.getDistributedCacheDir();
        String filesListFile = jobConf.get("gridmix.distcache.file.list");
        FileSystem fs = FileSystem.get((Configuration)jobConf);
        Path listFile = new Path(filesListFile);
        Assert.assertTrue((String)"Path of Distributed Cache files list file is wrong.", (boolean)distCachePath.equals((Object)listFile.getParent().makeQualified(fs.getUri(), fs.getWorkingDirectory())));
        Assert.assertTrue((String)("Failed to delete distributed Cache files list file " + listFile), (boolean)fs.delete(listFile, true));
        ArrayList<Long> fileSizes = new ArrayList<Long>();
        for (long size : sortedFileSizes) {
            fileSizes.add(size);
        }
        this.validateDistCacheFiles(fileSizes, distCachePath);
    }

    private void validateDistCacheFiles(List<Long> filesSizesExpected, Path distCacheDir) throws FileNotFoundException, IOException {
        FileStatus[] statuses = GridmixTestUtils.dfs.listStatus(distCacheDir);
        int numFiles = filesSizesExpected.size();
        Assert.assertEquals((String)"Number of files under distributed cache dir is wrong.", (long)numFiles, (long)statuses.length);
        for (int i = 0; i < numFiles; ++i) {
            FileStatus stat = statuses[i];
            Assert.assertTrue((String)("File size of distributed cache file " + stat.getPath().toUri().getPath() + " is wrong."), (boolean)filesSizesExpected.remove(stat.getLen()));
            FsPermission perm = stat.getPermission();
            Assert.assertEquals((String)("Wrong permissions for distributed cache file " + stat.getPath().toUri().getPath()), (Object)new FsPermission(420), (Object)perm);
        }
    }

    private long[] configureDummyDistCacheFiles(Configuration conf) throws IOException {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        conf.set("user.name", user);
        String[] distCacheFiles = new String[]{"hdfs:///tmp/file1.txt", "/tmp/" + user + "/.staging/job_1/file2.txt", "hdfs:///user/user1/file3.txt", "/home/user2/file4.txt", "subdir1/file5.txt", "subdir2/file6.gz"};
        String[] fileSizes = new String[]{"400", "2500", "700", "1200", "1500", "500"};
        String[] visibilities = new String[]{"true", "false", "false", "true", "true", "false"};
        String[] timeStamps = new String[]{"1234", "2345", "34567", "5434", "125", "134"};
        conf.setStrings("mapreduce.job.cache.files", distCacheFiles);
        conf.setStrings("mapreduce.job.cache.files.filesizes", fileSizes);
        conf.setStrings("mapreduce.job.cache.files.visibilities", visibilities);
        conf.setStrings("mapreduce.job.cache.files.timestamps", timeStamps);
        long[] sortedFileSizes = new long[]{1500L, 1200L, 700L, 500L, 400L};
        return sortedFileSizes;
    }

    private Configuration runSetupGenerateDistCacheData(boolean generate, long[] sortedFileSizes) throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        long[] fileSizes = this.configureDummyDistCacheFiles(conf);
        System.arraycopy(fileSizes, 0, sortedFileSizes, 0, fileSizes.length);
        int numJobs = 3;
        DebugJobProducer jobProducer = new DebugJobProducer(3, conf);
        Configuration jobConf = GridmixTestUtils.mrvl.getConfig();
        Path ioPath = new Path("testSetupGenerateDistCacheData").makeQualified(GridmixTestUtils.dfs.getUri(), GridmixTestUtils.dfs.getWorkingDirectory());
        FileSystem fs = FileSystem.get((Configuration)jobConf);
        if (fs.exists(ioPath)) {
            fs.delete(ioPath, true);
        }
        FileSystem.mkdirs((FileSystem)fs, (Path)ioPath, (FsPermission)new FsPermission(511));
        this.dce = this.createDistributedCacheEmulator(jobConf, ioPath, generate);
        int exitCode = this.dce.setupGenerateDistCacheData((JobStoryProducer)jobProducer);
        int expectedExitCode = generate ? 0 : 3;
        Assert.assertEquals((String)"setupGenerateDistCacheData failed.", (long)expectedExitCode, (long)exitCode);
        this.resetDistCacheConfigProperties(jobConf);
        return jobConf;
    }

    private void resetDistCacheConfigProperties(Configuration jobConf) {
        jobConf.setStrings("mapreduce.job.cache.files", new String[]{""});
        jobConf.setStrings("mapreduce.job.cache.files.filesizes", new String[]{""});
        jobConf.setStrings("mapreduce.job.cache.files.timestamps", new String[]{""});
        jobConf.setStrings("mapreduce.job.cache.files.visibilities", new String[]{""});
        jobConf.setStrings("mapred.cache.files", new String[]{""});
        jobConf.setStrings("mapred.cache.files.filesizes", new String[]{""});
        jobConf.setStrings("mapred.cache.files.visibilities", new String[]{""});
        jobConf.setStrings("mapred.cache.files.timestamps", new String[]{""});
    }

    @Test(timeout=200000L)
    public void testGenerateDistCacheData() throws Exception {
        long[] sortedFileSizes = new long[5];
        Configuration jobConf = this.runSetupGenerateDistCacheData(true, sortedFileSizes);
        GenerateDistCacheData gridmixJob = new GenerateDistCacheData(jobConf);
        Job job = (Job)gridmixJob.call();
        Assert.assertEquals((String)"Number of reduce tasks in GenerateDistCacheData is not 0.", (long)0L, (long)job.getNumReduceTasks());
        Assert.assertTrue((String)"GenerateDistCacheData job failed.", (boolean)job.waitForCompletion(false));
        this.validateDistCacheData(jobConf, sortedFileSizes);
    }

    private void validateSetupGenDC(Configuration jobConf, long[] sortedFileSizes) throws IOException, InterruptedException {
        long sumOfFileSizes = 0L;
        for (int i = 0; i < sortedFileSizes.length; ++i) {
            sumOfFileSizes += sortedFileSizes[i];
        }
        FileSystem fs = FileSystem.get((Configuration)jobConf);
        Assert.assertEquals((String)"Number of distributed cache files to be generated is wrong.", (long)sortedFileSizes.length, (long)jobConf.getInt("gridmix.distcache.file.count", -1));
        Assert.assertEquals((String)"Total size of dist cache files to be generated is wrong.", (long)sumOfFileSizes, (long)jobConf.getLong("gridmix.distcache.byte.count", -1L));
        Path filesListFile = new Path(jobConf.get("gridmix.distcache.file.list"));
        FileStatus stat = fs.getFileStatus(filesListFile);
        Assert.assertEquals((String)("Wrong permissions of dist Cache files list file " + filesListFile), (Object)new FsPermission(420), (Object)stat.getPermission());
        FileSplit split = new FileSplit(filesListFile, 0L, stat.getLen(), (String[])null);
        TaskAttemptContext taskContext = MapReduceTestUtil.createDummyMapTaskAttemptContext((Configuration)jobConf);
        RecordReader reader = new GenerateDistCacheData.GenDCDataFormat().createRecordReader((InputSplit)split, taskContext);
        MapContextImpl mapContext = new MapContextImpl(jobConf, taskContext.getTaskAttemptID(), reader, null, null, MapReduceTestUtil.createDummyReporter(), (InputSplit)split);
        reader.initialize((InputSplit)split, (TaskAttemptContext)mapContext);
        this.doValidateSetupGenDC(reader, fs, sortedFileSizes);
    }

    private void doValidateSetupGenDC(RecordReader<LongWritable, BytesWritable> reader, FileSystem fs, long[] sortedFileSizes) throws IOException, InterruptedException {
        Path distCacheDir = this.dce.getDistributedCacheDir();
        Assert.assertEquals((String)("Wrong permissions for distributed cache dir " + distCacheDir), (Object)fs.getFileStatus(distCacheDir).getPermission().getOtherAction().and(FsAction.EXECUTE), (Object)FsAction.EXECUTE);
        LongWritable key = new LongWritable();
        BytesWritable val = new BytesWritable();
        for (int i = 0; i < sortedFileSizes.length; ++i) {
            Assert.assertTrue((String)"Number of files written to the sequence file by setupGenerateDistCacheData is less than the expected.", (boolean)reader.nextKeyValue());
            key = (LongWritable)reader.getCurrentKey();
            val = (BytesWritable)reader.getCurrentValue();
            long fileSize = key.get();
            String file = new String(val.getBytes(), 0, val.getLength());
            Assert.assertEquals((String)"Dist cache file size is wrong.", (long)sortedFileSizes[i], (long)fileSize);
            Path parent = new Path(file).getParent().makeQualified(fs.getUri(), fs.getWorkingDirectory());
            Assert.assertTrue((String)"Public dist cache file path is wrong.", (boolean)distCacheDir.equals((Object)parent));
        }
    }

    @Test(timeout=20000L)
    public void testSetupGenerateDistCacheData() throws IOException, InterruptedException {
        long[] sortedFileSizes = new long[5];
        Configuration jobConf = this.runSetupGenerateDistCacheData(true, sortedFileSizes);
        this.validateSetupGenDC(jobConf, sortedFileSizes);
        this.runSetupGenerateDistCacheData(false, sortedFileSizes);
    }

    private DistributedCacheEmulator createDistributedCacheEmulator(Configuration conf, Path ioPath, boolean generate) throws IOException {
        DistributedCacheEmulator dce = new DistributedCacheEmulator(conf, ioPath);
        JobCreator jobCreator = JobCreator.getPolicy((Configuration)conf, (JobCreator)JobCreator.LOADJOB);
        jobCreator.setDistCacheEmulator(dce);
        dce.init("dummytrace", jobCreator, generate);
        return dce;
    }

    @Test(timeout=2000L)
    public void testDistCacheEmulationConfigurability() throws IOException {
        Configuration jobConf = GridmixTestUtils.mrvl.getConfig();
        Path ioPath = new Path("testDistCacheEmulationConfigurability").makeQualified(GridmixTestUtils.dfs.getUri(), GridmixTestUtils.dfs.getWorkingDirectory());
        FileSystem fs = FileSystem.get((Configuration)jobConf);
        FileSystem.mkdirs((FileSystem)fs, (Path)ioPath, (FsPermission)new FsPermission(511));
        this.dce = this.createDistributedCacheEmulator(jobConf, ioPath, false);
        Assert.assertTrue((String)"Default configuration of gridmix.distributed-cache-emulation.enable is wrong.", (boolean)this.dce.shouldEmulateDistCacheLoad());
        jobConf.setBoolean("gridmix.distributed-cache-emulation.enable", false);
        this.dce = this.createDistributedCacheEmulator(jobConf, ioPath, false);
        Assert.assertFalse((String)"Disabling of emulation of distributed cache load by setting gridmix.distributed-cache-emulation.enable to false is not working.", (boolean)this.dce.shouldEmulateDistCacheLoad());
    }

    @Test(timeout=2000L)
    public void testDistCacheEmulator() throws Exception {
        Configuration conf = new Configuration();
        this.configureDummyDistCacheFiles(conf);
        File ws = new File("target" + File.separator + this.getClass().getName());
        Path ioPath = new Path(ws.getAbsolutePath());
        DistributedCacheEmulator dce = new DistributedCacheEmulator(conf, ioPath);
        JobConf jobConf = new JobConf(conf);
        jobConf.setUser(UserGroupInformation.getCurrentUser().getShortUserName());
        File fin = new File("src" + File.separator + "test" + File.separator + "resources" + File.separator + "data" + File.separator + "wordcount.json");
        dce.init(fin.getAbsolutePath(), JobCreator.LOADJOB, true);
        dce.configureDistCacheFiles(conf, jobConf);
        String[] caches = conf.getStrings("mapreduce.job.cache.files");
        String[] tmpfiles = conf.getStrings("tmpfiles");
        Assert.assertEquals((long)6L, (long)((caches == null ? 0 : caches.length) + (tmpfiles == null ? 0 : tmpfiles.length)));
    }
}

