/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.DistCpV1;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class DistCpV1
implements Tool {
    public static final Log LOG = LogFactory.getLog(DistCpV1.class);
    private static final String NAME = "distcp";
    private static final String usage = "distcp [OPTIONS] <srcurl>* <desturl>\n\nOPTIONS:\n-p[rbugpt]             Preserve status\n                       r: replication number\n                       b: block size\n                       u: user\n                       g: group\n                       p: permission\n                       t: modification and access times\n                       -p alone is equivalent to -prbugpt\n-i                     Ignore failures\n-basedir <basedir>     Use <basedir> as the base directory when copying files from <srcurl>\n-log <logdir>          Write logs to <logdir>\n-m <num_maps>          Maximum number of simultaneous copies\n-overwrite             Overwrite destination\n-update                Overwrite if src size different from dst size\n-skipcrccheck          Do not use CRC check to determine if src is \n                       different from dest. Relevant only if -update\n                       is specified\n-f <urilist_uri>       Use list at <urilist_uri> as src list\n-filelimit <n>         Limit the total number of files to be <= n\n-sizelimit <n>         Limit the total size to be <= n bytes\n-delete                Delete the files existing in the dst but not in src\n-dryrun                Display count of files and total size of files\n                        in src and then exit. Copy is not done at all.\n                        desturl should not be speicified with out -update.\n-mapredSslConf <f>     Filename of SSL configuration for mapper task\n\nNOTE 1: if -overwrite or -update are set, each source URI is \n      interpreted as an isomorphic update to an existing directory.\nFor example:\nhadoop distcp -p -update \"hdfs://A:8020/user/foo/bar\" \"hdfs://B:8020/user/foo/baz\"\n\n     would update all descendants of 'baz' also in 'bar'; it would \n     *not* update /user/foo/baz/bar\n\nNOTE 2: The parameter <n> in -filelimit and -sizelimit can be \n     specified with symbolic representation.  For examples,\n       1230k = 1230 * 1024 = 1259520\n       891g = 891 * 1024^3 = 956703965184\n";
    private static final long BYTES_PER_MAP = 0x10000000L;
    private static final int MAX_MAPS_PER_NODE = 20;
    private static final int SYNC_FILE_MAX = 10;
    private static final int DEFAULT_FILE_RETRIES = 3;
    static final String TMP_DIR_LABEL = "distcp.tmp.dir";
    static final String DST_DIR_LABEL = "distcp.dest.path";
    static final String JOB_DIR_LABEL = "distcp.job.dir";
    static final String MAX_MAPS_LABEL = "distcp.max.map.tasks";
    static final String SRC_LIST_LABEL = "distcp.src.list";
    static final String SRC_COUNT_LABEL = "distcp.src.count";
    static final String TOTAL_SIZE_LABEL = "distcp.total.size";
    static final String DST_DIR_LIST_LABEL = "distcp.dst.dir.list";
    static final String BYTES_PER_MAP_LABEL = "distcp.bytes.per.map";
    static final String PRESERVE_STATUS_LABEL = Options.PRESERVE_STATUS.propertyname + ".value";
    static final String FILE_RETRIES_LABEL = "distcp.file.retries";
    private JobConf conf;
    private static final Random RANDOM = new Random();

    public void setConf(Configuration conf) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public DistCpV1(Configuration conf) {
        this.setConf(conf);
    }

    private static List<Path> fetchFileList(Configuration conf, Path srcList) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        FileSystem fs = srcList.getFileSystem(conf);
        try (BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)fs.open(srcList), Charset.forName("UTF-8")));){
            String line = input.readLine();
            while (line != null) {
                result.add(new Path(line));
                line = input.readLine();
            }
        }
        return result;
    }

    @Deprecated
    public static void copy(Configuration conf, String srcPath, String destPath, Path logPath, boolean srcAsList, boolean ignoreReadFailures) throws IOException {
        Path src = new Path(srcPath);
        ArrayList<Path> tmp = new ArrayList<Path>();
        if (srcAsList) {
            tmp.addAll(DistCpV1.fetchFileList((Configuration)conf, (Path)src));
        } else {
            tmp.add(src);
        }
        EnumSet<Options> flags = ignoreReadFailures ? EnumSet.of(Options.IGNORE_READ_FAILURES) : EnumSet.noneOf(Options.class);
        Path dst = new Path(destPath);
        DistCpV1.copy((Configuration)conf, (Arguments)new Arguments(tmp, null, dst, logPath, flags, null, Long.MAX_VALUE, Long.MAX_VALUE, null, false));
    }

    private static void checkSrcPath(JobConf jobConf, List<Path> srcPaths) throws IOException {
        ArrayList<IOException> rslt = new ArrayList<IOException>();
        LinkedList<Path> unglobbed = new LinkedList<Path>();
        Path[] ps = new Path[srcPaths.size()];
        ps = srcPaths.toArray(ps);
        TokenCache.obtainTokensForNamenodes((Credentials)jobConf.getCredentials(), (Path[])ps, (Configuration)jobConf);
        for (Path p : srcPaths) {
            FileSystem fs = p.getFileSystem((Configuration)jobConf);
            FileStatus[] inputs = fs.globStatus(p);
            if (inputs != null && inputs.length > 0) {
                for (FileStatus onePath : inputs) {
                    unglobbed.add(onePath.getPath());
                }
                continue;
            }
            rslt.add(new IOException("Input source " + p + " does not exist."));
        }
        if (!rslt.isEmpty()) {
            throw new InvalidInputException(rslt);
        }
        srcPaths.clear();
        srcPaths.addAll(unglobbed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copy(Configuration conf, Arguments args) throws IOException {
        LOG.info((Object)("srcPaths=" + args.srcs));
        if (!args.dryrun || args.flags.contains(Options.UPDATE)) {
            LOG.info((Object)("destPath=" + args.dst));
        }
        JobConf job = DistCpV1.createJobConf((Configuration)conf);
        DistCpV1.checkSrcPath((JobConf)job, (List)args.srcs);
        if (args.preservedAttributes != null) {
            job.set(PRESERVE_STATUS_LABEL, args.preservedAttributes);
        }
        if (args.mapredSslConf != null) {
            job.set("dfs.https.client.keystore.resource", args.mapredSslConf);
        }
        try {
            if (DistCpV1.setup((Configuration)conf, (JobConf)job, (Arguments)args)) {
                JobClient.runJob((JobConf)job);
            }
            if (!args.dryrun) {
                DistCpV1.finalize((Configuration)conf, (JobConf)job, (Path)args.dst, (String)args.preservedAttributes);
            }
        }
        finally {
            if (!args.dryrun) {
                DistCpV1.fullyDelete((String)job.get("distcp.tmp.dir"), (Configuration)job);
            }
            DistCpV1.fullyDelete((String)job.get("distcp.job.dir"), (Configuration)job);
        }
    }

    private static void updateDestStatus(FileStatus src, FileStatus dst, EnumSet<FileAttribute> preseved, FileSystem destFileSys) throws IOException {
        String owner = null;
        String group = null;
        if (preseved.contains(FileAttribute.USER) && !src.getOwner().equals(dst.getOwner())) {
            owner = src.getOwner();
        }
        if (preseved.contains(FileAttribute.GROUP) && !src.getGroup().equals(dst.getGroup())) {
            group = src.getGroup();
        }
        if (owner != null || group != null) {
            destFileSys.setOwner(dst.getPath(), owner, group);
        }
        if (preseved.contains(FileAttribute.PERMISSION) && !src.getPermission().equals((Object)dst.getPermission())) {
            destFileSys.setPermission(dst.getPath(), src.getPermission());
        }
        if (preseved.contains(FileAttribute.TIMES)) {
            destFileSys.setTimes(dst.getPath(), src.getModificationTime(), src.getAccessTime());
        }
    }

    private static void finalize(Configuration conf, JobConf jobconf, Path destPath, String presevedAttributes) throws IOException {
        if (presevedAttributes == null) {
            return;
        }
        EnumSet preseved = FileAttribute.parse((String)presevedAttributes);
        if (!(preseved.contains(FileAttribute.USER) || preseved.contains(FileAttribute.GROUP) || preseved.contains(FileAttribute.PERMISSION))) {
            return;
        }
        FileSystem dstfs = destPath.getFileSystem(conf);
        Path dstdirlist = new Path(jobconf.get("distcp.dst.dir.list"));
        try (SequenceFile.Reader in = new SequenceFile.Reader((Configuration)jobconf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)dstdirlist)});){
            Text dsttext = new Text();
            FilePair pair = new FilePair();
            while (in.next((Writable)dsttext, (Writable)pair)) {
                Path absdst = new Path(destPath, pair.output);
                DistCpV1.updateDestStatus((FileStatus)pair.input, (FileStatus)dstfs.getFileStatus(absdst), (EnumSet)preseved, (FileSystem)dstfs);
            }
        }
    }

    public int run(String[] args) {
        try {
            DistCpV1.copy((Configuration)this.conf, (Arguments)Arguments.valueOf((String[])args, (Configuration)this.conf));
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.err.println(StringUtils.stringifyException((Throwable)e) + "\n" + "distcp [OPTIONS] <srcurl>* <desturl>\n\nOPTIONS:\n-p[rbugpt]             Preserve status\n                       r: replication number\n                       b: block size\n                       u: user\n                       g: group\n                       p: permission\n                       t: modification and access times\n                       -p alone is equivalent to -prbugpt\n-i                     Ignore failures\n-basedir <basedir>     Use <basedir> as the base directory when copying files from <srcurl>\n-log <logdir>          Write logs to <logdir>\n-m <num_maps>          Maximum number of simultaneous copies\n-overwrite             Overwrite destination\n-update                Overwrite if src size different from dst size\n-skipcrccheck          Do not use CRC check to determine if src is \n                       different from dest. Relevant only if -update\n                       is specified\n-f <urilist_uri>       Use list at <urilist_uri> as src list\n-filelimit <n>         Limit the total number of files to be <= n\n-sizelimit <n>         Limit the total size to be <= n bytes\n-delete                Delete the files existing in the dst but not in src\n-dryrun                Display count of files and total size of files\n                        in src and then exit. Copy is not done at all.\n                        desturl should not be speicified with out -update.\n-mapredSslConf <f>     Filename of SSL configuration for mapper task\n\nNOTE 1: if -overwrite or -update are set, each source URI is \n      interpreted as an isomorphic update to an existing directory.\nFor example:\nhadoop distcp -p -update \"hdfs://A:8020/user/foo/bar\" \"hdfs://B:8020/user/foo/baz\"\n\n     would update all descendants of 'baz' also in 'bar'; it would \n     *not* update /user/foo/baz/bar\n\nNOTE 2: The parameter <n> in -filelimit and -sizelimit can be \n     specified with symbolic representation.  For examples,\n       1230k = 1230 * 1024 = 1259520\n       891g = 891 * 1024^3 = 956703965184\n");
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return -1;
        }
        catch (DuplicationException e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            return -2;
        }
        catch (RemoteException e) {
            IOException unwrapped = e.unwrapRemoteException(new Class[]{FileNotFoundException.class, AccessControlException.class, QuotaExceededException.class});
            System.err.println(StringUtils.stringifyException((Throwable)unwrapped));
            return -3;
        }
        catch (Exception e) {
            System.err.println("With failures, global counters are inaccurate; consider running with -i");
            System.err.println("Copy failed: " + StringUtils.stringifyException((Throwable)e));
            return -999;
        }
    }

    public static void main(String[] args) throws Exception {
        JobConf job = new JobConf(DistCpV1.class);
        DistCpV1 distcp = new DistCpV1((Configuration)job);
        int res = ToolRunner.run((Tool)distcp, (String[])args);
        System.exit(res);
    }

    static String makeRelative(Path root, Path absPath) {
        if (!absPath.isAbsolute()) {
            throw new IllegalArgumentException("!absPath.isAbsolute(), absPath=" + absPath);
        }
        String p = absPath.toUri().getPath();
        StringTokenizer pathTokens = new StringTokenizer(p, "/");
        StringTokenizer rootTokens = new StringTokenizer(root.toUri().getPath(), "/");
        while (rootTokens.hasMoreTokens()) {
            if (rootTokens.nextToken().equals(pathTokens.nextToken())) continue;
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (pathTokens.hasMoreTokens()) {
            sb.append(pathTokens.nextToken());
            if (!pathTokens.hasMoreTokens()) continue;
            sb.append("/");
        }
        return sb.length() == 0 ? "." : sb.toString();
    }

    private static int setMapCount(long totalBytes, JobConf job) throws IOException {
        int numMaps = (int)(totalBytes / job.getLong("distcp.bytes.per.map", 0x10000000L));
        numMaps = Math.min(numMaps, job.getInt("distcp.max.map.tasks", 20 * new JobClient(job).getClusterStatus().getTaskTrackers()));
        numMaps = Math.max(numMaps, 1);
        job.setNumMapTasks(numMaps);
        return numMaps;
    }

    static void fullyDelete(String dir, Configuration conf) throws IOException {
        Path tmp;
        boolean success;
        if (dir != null && !(success = (tmp = new Path(dir)).getFileSystem(conf).delete(tmp, true))) {
            LOG.warn((Object)("Could not fully delete " + tmp));
        }
    }

    private static JobConf createJobConf(Configuration conf) {
        JobConf jobconf = new JobConf(conf, DistCpV1.class);
        jobconf.setJobName(conf.get("mapred.job.name", "distcp"));
        jobconf.setMapSpeculativeExecution(false);
        jobconf.setInputFormat(CopyInputFormat.class);
        jobconf.setOutputKeyClass(Text.class);
        jobconf.setOutputValueClass(Text.class);
        jobconf.setMapperClass(CopyFilesMapper.class);
        jobconf.setNumReduceTasks(0);
        return jobconf;
    }

    public static String getRandomId() {
        return Integer.toString(RANDOM.nextInt(Integer.MAX_VALUE), 36);
    }

    private static void setReplication(Configuration conf, JobConf jobConf, Path srcfilelist, int numMaps) throws IOException {
        int numMaxMaps = new JobClient(jobConf).getClusterStatus().getMaxMapTasks();
        short replication = (short)Math.ceil(Math.sqrt(Math.min(numMaxMaps, numMaps)));
        FileSystem fs = srcfilelist.getFileSystem(conf);
        FileStatus srcStatus = fs.getFileStatus(srcfilelist);
        if (srcStatus.getReplication() < replication && !fs.setReplication(srcfilelist, replication)) {
            throw new IOException("Unable to increase the replication of file " + srcfilelist);
        }
    }

    private static boolean dirExists(Configuration conf, Path dst) throws IOException {
        FileSystem destFileSys = dst.getFileSystem(conf);
        FileStatus status = null;
        try {
            status = destFileSys.getFileStatus(dst);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        if (status.isFile()) {
            throw new FileAlreadyExistsException("Not a dir: " + dst + " is a file.");
        }
        return true;
    }

    static boolean setup(Configuration conf, JobConf jobConf, Arguments args) throws IOException {
        Path logPath;
        Path stagingArea;
        jobConf.set("distcp.dest.path", args.dst.toUri().toString());
        boolean update = args.flags.contains(Options.UPDATE);
        boolean skipCRCCheck = args.flags.contains(Options.SKIPCRC);
        boolean overwrite = !update && args.flags.contains(Options.OVERWRITE) && !args.dryrun;
        jobConf.setBoolean(Options.UPDATE.propertyname, update);
        jobConf.setBoolean(Options.SKIPCRC.propertyname, skipCRCCheck);
        jobConf.setBoolean(Options.OVERWRITE.propertyname, overwrite);
        jobConf.setBoolean(Options.IGNORE_READ_FAILURES.propertyname, args.flags.contains(Options.IGNORE_READ_FAILURES));
        jobConf.setBoolean(Options.PRESERVE_STATUS.propertyname, args.flags.contains(Options.PRESERVE_STATUS));
        String randomId = DistCpV1.getRandomId();
        JobClient jClient = new JobClient(jobConf);
        try {
            stagingArea = JobSubmissionFiles.getStagingDir((Cluster)jClient.getClusterHandle(), (Configuration)conf);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        Path jobDirectory = new Path(stagingArea + "distcp" + "_" + randomId);
        FsPermission mapredSysPerms = new FsPermission(JobSubmissionFiles.JOB_DIR_PERMISSION);
        FileSystem.mkdirs((FileSystem)jClient.getFs(), (Path)jobDirectory, (FsPermission)mapredSysPerms);
        jobConf.set("distcp.job.dir", jobDirectory.toString());
        long maxBytesPerMap = conf.getLong("distcp.bytes.per.map", 0x10000000L);
        FileSystem dstfs = args.dst.getFileSystem(conf);
        TokenCache.obtainTokensForNamenodes((Credentials)jobConf.getCredentials(), (Path[])new Path[]{args.dst}, (Configuration)conf);
        boolean dstExists = dstfs.exists(args.dst);
        boolean dstIsDir = false;
        if (dstExists) {
            dstIsDir = dstfs.getFileStatus(args.dst).isDirectory();
        }
        if ((logPath = args.log) == null) {
            String filename = "_distcp_logs_" + randomId;
            if (!dstExists || !dstIsDir) {
                Path parent = args.dst.getParent();
                if (null == parent) {
                    parent = args.dst;
                }
                if (!dstfs.exists(parent)) {
                    dstfs.mkdirs(parent);
                }
                logPath = new Path(parent, filename);
            } else {
                logPath = new Path(args.dst, filename);
            }
        }
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)logPath);
        FileSystem jobfs = jobDirectory.getFileSystem((Configuration)jobConf);
        Path srcfilelist = new Path(jobDirectory, "_distcp_src_files");
        Path dstfilelist = new Path(jobDirectory, "_distcp_dst_files");
        Path dstdirlist = new Path(jobDirectory, "_distcp_dst_dirs");
        jobConf.set("distcp.src.list", srcfilelist.toString());
        jobConf.set("distcp.dst.dir.list", dstdirlist.toString());
        int srcCount = 0;
        int cnsyncf = 0;
        int dirsyn = 0;
        long fileCount = 0L;
        long dirCount = 0L;
        long byteCount = 0L;
        long cbsyncs = 0L;
        long skipFileCount = 0L;
        long skipByteCount = 0L;
        try (SequenceFile.Writer src_writer = SequenceFile.createWriter((Configuration)jobConf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)srcfilelist), SequenceFile.Writer.keyClass(LongWritable.class), SequenceFile.Writer.valueClass(FilePair.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE)});
             SequenceFile.Writer dst_writer = SequenceFile.createWriter((Configuration)jobConf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)dstfilelist), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(Text.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE)});
             SequenceFile.Writer dir_writer = SequenceFile.createWriter((Configuration)jobConf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)dstdirlist), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(FilePair.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE)});){
            FileSystem basefs;
            boolean special = args.srcs.size() == 1 && !dstExists || update || overwrite;
            Path basedir = null;
            HashSet<Path> parentDirsToCopy = new HashSet<Path>();
            if (args.basedir != null && !(basefs = args.basedir.getFileSystem(conf)).isDirectory(basedir = args.basedir.makeQualified(basefs.getUri(), basefs.getWorkingDirectory()))) {
                throw new IOException("Basedir " + basedir + " is not a directory.");
            }
            for (Path src : args.srcs) {
                Path root;
                FileSystem srcfs = src.getFileSystem(conf);
                FileStatus srcfilestat = srcfs.getFileStatus(src);
                Path path = root = special && srcfilestat.isDirectory() ? src : src.getParent();
                if (dstExists && !dstIsDir && (args.srcs.size() > 1 || srcfilestat.isDirectory())) {
                    throw new IOException("Destination " + args.dst + " should be a dir" + " if multiple source paths are there OR if" + " the source path is a dir");
                }
                if (basedir != null) {
                    Path parent;
                    root = basedir;
                    for (parent = src.getParent().makeQualified(srcfs.getUri(), srcfs.getWorkingDirectory()); parent != null && !parent.equals((Object)basedir); parent = parent.getParent()) {
                        if (parentDirsToCopy.contains(parent)) continue;
                        parentDirsToCopy.add(parent);
                        String dst = DistCpV1.makeRelative((Path)root, (Path)parent);
                        FileStatus pst = srcfs.getFileStatus(parent);
                        src_writer.append((Writable)new LongWritable(0L), (Writable)new FilePair(pst, dst));
                        dst_writer.append((Writable)new Text(dst), (Writable)new Text(parent.toString()));
                        dir_writer.append((Writable)new Text(dst), (Writable)new FilePair(pst, dst));
                        if (++dirsyn <= 10) continue;
                        dirsyn = 0;
                        dir_writer.sync();
                    }
                    if (parent == null) {
                        throw new IOException("Basedir " + basedir + " is not a prefix of source path " + src);
                    }
                }
                if (srcfilestat.isDirectory()) {
                    ++srcCount;
                    String dst = DistCpV1.makeRelative((Path)root, (Path)src);
                    if (!update || !DistCpV1.dirExists((Configuration)conf, (Path)new Path(args.dst, dst))) {
                        ++dirCount;
                        src_writer.append((Writable)new LongWritable(0L), (Writable)new FilePair(srcfilestat, dst));
                    }
                    dst_writer.append((Writable)new Text(dst), (Writable)new Text(src.toString()));
                }
                Stack<FileStatus> pathstack = new Stack<FileStatus>();
                pathstack.push(srcfilestat);
                while (!pathstack.empty()) {
                    FileStatus cur = (FileStatus)pathstack.pop();
                    FileStatus[] children = srcfs.listStatus(cur.getPath());
                    for (int i = 0; i < children.length; ++i) {
                        boolean skipPath = false;
                        FileStatus child = children[i];
                        String dst = DistCpV1.makeRelative((Path)root, (Path)child.getPath());
                        ++srcCount;
                        if (child.isDirectory()) {
                            pathstack.push(child);
                            if (!update || !DistCpV1.dirExists((Configuration)conf, (Path)new Path(args.dst, dst))) {
                                ++dirCount;
                            } else {
                                skipPath = true;
                            }
                        } else {
                            Path destPath = new Path(args.dst, dst);
                            if (cur.isFile() && args.srcs.size() == 1) {
                                Path dstparent = destPath.getParent();
                                FileSystem destFileSys = destPath.getFileSystem((Configuration)jobConf);
                                if (!destFileSys.exists(dstparent) || !destFileSys.getFileStatus(dstparent).isDirectory()) {
                                    destPath = dstparent;
                                }
                            }
                            skipPath = update && DistCpV1.sameFile((FileSystem)srcfs, (FileStatus)child, (FileSystem)dstfs, (Path)destPath, (boolean)skipCRCCheck);
                            if (!(skipPath |= fileCount == args.filelimit || byteCount + child.getLen() > args.sizelimit)) {
                                ++fileCount;
                                byteCount += child.getLen();
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace((Object)("adding file " + child.getPath()));
                                }
                                if (++cnsyncf > 10 || (cbsyncs += child.getLen()) > maxBytesPerMap) {
                                    src_writer.sync();
                                    dst_writer.sync();
                                    cnsyncf = 0;
                                    cbsyncs = 0L;
                                }
                            } else {
                                ++skipFileCount;
                                skipByteCount += child.getLen();
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace((Object)("skipping file " + child.getPath()));
                                }
                            }
                        }
                        if (!skipPath) {
                            src_writer.append((Writable)new LongWritable(child.isDirectory() ? 0L : child.getLen()), (Writable)new FilePair(child, dst));
                        }
                        dst_writer.append((Writable)new Text(dst), (Writable)new Text(child.getPath().toString()));
                    }
                    if (!cur.isDirectory()) continue;
                    String dst = DistCpV1.makeRelative((Path)root, (Path)cur.getPath());
                    dir_writer.append((Writable)new Text(dst), (Writable)new FilePair(cur, dst));
                    if (++dirsyn <= 10) continue;
                    dirsyn = 0;
                    dir_writer.sync();
                }
            }
        }
        LOG.info((Object)("sourcePathsCount(files+directories)=" + srcCount));
        LOG.info((Object)("filesToCopyCount=" + fileCount));
        LOG.info((Object)("bytesToCopyCount=" + StringUtils.TraditionalBinaryPrefix.long2String((long)byteCount, (String)"", (int)1)));
        if (update) {
            LOG.info((Object)("filesToSkipCopyCount=" + skipFileCount));
            LOG.info((Object)("bytesToSkipCopyCount=" + StringUtils.TraditionalBinaryPrefix.long2String((long)skipByteCount, (String)"", (int)1)));
        }
        if (args.dryrun) {
            return false;
        }
        int mapCount = DistCpV1.setMapCount((long)byteCount, (JobConf)jobConf);
        DistCpV1.setReplication((Configuration)conf, (JobConf)jobConf, (Path)srcfilelist, (int)mapCount);
        FileStatus dststatus = null;
        try {
            dststatus = dstfs.getFileStatus(args.dst);
        }
        catch (FileNotFoundException fnfe) {
            LOG.info((Object)(args.dst + " does not exist."));
        }
        if (dststatus == null && srcCount > 1 && !dstfs.mkdirs(args.dst)) {
            throw new IOException("Failed to create" + args.dst);
        }
        Path sorted = new Path(jobDirectory, "_distcp_sorted");
        DistCpV1.checkDuplication((FileSystem)jobfs, (Path)dstfilelist, (Path)sorted, (Configuration)conf);
        if (dststatus != null && args.flags.contains(Options.DELETE)) {
            long deletedPathsCount = DistCpV1.deleteNonexisting((FileSystem)dstfs, (FileStatus)dststatus, (Path)sorted, (FileSystem)jobfs, (Path)jobDirectory, (JobConf)jobConf, (Configuration)conf);
            LOG.info((Object)("deletedPathsFromDestCount(files+directories)=" + deletedPathsCount));
        }
        Path tmpDir = new Path(dstExists && !dstIsDir || !dstExists && srcCount == 1 ? args.dst.getParent() : args.dst, "_distcp_tmp_" + randomId);
        jobConf.set("distcp.tmp.dir", tmpDir.toUri().toString());
        tmpDir.getFileSystem(conf).mkdirs(tmpDir);
        LOG.info((Object)("sourcePathsCount=" + srcCount));
        LOG.info((Object)("filesToCopyCount=" + fileCount));
        LOG.info((Object)("bytesToCopyCount=" + StringUtils.TraditionalBinaryPrefix.long2String((long)byteCount, (String)"", (int)1)));
        jobConf.setInt("distcp.src.count", srcCount);
        jobConf.setLong("distcp.total.size", byteCount);
        return fileCount + dirCount > 0L;
    }

    private static boolean sameFile(FileSystem srcfs, FileStatus srcstatus, FileSystem dstfs, Path dstpath, boolean skipCRCCheck) throws IOException {
        FileChecksum srccs;
        FileStatus dststatus;
        try {
            dststatus = dstfs.getFileStatus(dstpath);
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        if (srcstatus.getLen() != dststatus.getLen()) {
            return false;
        }
        if (skipCRCCheck) {
            LOG.debug((Object)"Skipping the CRC check");
            return true;
        }
        try {
            srccs = srcfs.getFileChecksum(srcstatus.getPath());
        }
        catch (FileNotFoundException fnfe) {
            return true;
        }
        try {
            FileChecksum dstcs = dstfs.getFileChecksum(dststatus.getPath());
            return srccs == null || dstcs == null || srccs.equals((Object)dstcs);
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
    }

    private static long deleteNonexisting(FileSystem dstfs, FileStatus dstroot, Path dstsorted, FileSystem jobfs, Path jobdir, JobConf jobconf, Configuration conf) throws IOException {
        if (dstroot.isFile()) {
            throw new IOException("dst must be a directory when option " + Options.DELETE.cmd + " is set, but dst (= " + dstroot.getPath() + ") is not a directory.");
        }
        Path dstlsr = new Path(jobdir, "_distcp_dst_lsr");
        try (SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)jobconf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)dstlsr), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(NullWritable.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE)});){
            Stack<FileStatus> lsrstack = new Stack<FileStatus>();
            lsrstack.push(dstroot);
            while (!lsrstack.isEmpty()) {
                FileStatus status = (FileStatus)lsrstack.pop();
                if (!status.isDirectory()) continue;
                for (FileStatus child : dstfs.listStatus(status.getPath())) {
                    String relative = DistCpV1.makeRelative((Path)dstroot.getPath(), (Path)child.getPath());
                    writer.append((Writable)new Text(relative), (Writable)NullWritable.get());
                    lsrstack.push(child);
                }
            }
        }
        Path sortedlsr = new Path(jobdir, "_distcp_dst_lsr_sorted");
        SequenceFile.Sorter sorter = new SequenceFile.Sorter(jobfs, (RawComparator)new Text.Comparator(), Text.class, NullWritable.class, (Configuration)jobconf);
        sorter.sort(dstlsr, sortedlsr);
        long deletedPathsCount = 0L;
        try (SequenceFile.Reader lsrin = new SequenceFile.Reader((Configuration)jobconf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sortedlsr)});
             SequenceFile.Reader dstin = new SequenceFile.Reader((Configuration)jobconf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)dstsorted)});){
            Text lsrpath = new Text();
            Text dstpath = new Text();
            Text dstfrom = new Text();
            Trash trash = new Trash(dstfs, conf);
            Path lastpath = null;
            boolean hasnext = dstin.next((Writable)dstpath, (Writable)dstfrom);
            while (lsrin.next((Writable)lsrpath, (Writable)NullWritable.get())) {
                int dst_cmp_lsr = dstpath.compareTo((BinaryComparable)lsrpath);
                while (hasnext && dst_cmp_lsr < 0) {
                    hasnext = dstin.next((Writable)dstpath, (Writable)dstfrom);
                    dst_cmp_lsr = dstpath.compareTo((BinaryComparable)lsrpath);
                }
                if (dst_cmp_lsr == 0) {
                    hasnext = dstin.next((Writable)dstpath, (Writable)dstfrom);
                    continue;
                }
                Path rmpath = new Path(dstroot.getPath(), lsrpath.toString());
                ++deletedPathsCount;
                if (lastpath != null && DistCpV1.isAncestorPath(lastpath, (Path)rmpath)) continue;
                if (!trash.moveToTrash(rmpath) && !dstfs.delete(rmpath, true)) {
                    throw new IOException("Failed to delete " + rmpath);
                }
                lastpath = rmpath;
            }
        }
        return deletedPathsCount;
    }

    private static boolean isAncestorPath(Path xp, Path yp) {
        String x = xp.toString();
        String y = yp.toString();
        if (!y.startsWith(x)) {
            return false;
        }
        int len = x.length();
        return y.length() == len || y.charAt(len) == '/';
    }

    private static void checkDuplication(FileSystem fs, Path file, Path sorted, Configuration conf) throws IOException {
        SequenceFile.Sorter sorter = new SequenceFile.Sorter(fs, (RawComparator)new Text.Comparator(), Text.class, Text.class, conf);
        sorter.sort(file, sorted);
        try (SequenceFile.Reader in = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sorted)});){
            Text prevdst = null;
            Text curdst = new Text();
            Text prevsrc = null;
            Text cursrc = new Text();
            while (in.next((Writable)curdst, (Writable)cursrc)) {
                if (prevdst != null && curdst.equals((Object)prevdst)) {
                    throw new DuplicationException("Invalid input, there are duplicated files in the sources: " + prevsrc + ", " + cursrc);
                }
                prevdst = curdst;
                curdst = new Text();
                prevsrc = cursrc;
                cursrc = new Text();
            }
        }
    }

    static /* synthetic */ boolean access$000(FileSystem x0, FileStatus x1, FileSystem x2, Path x3, boolean x4) throws IOException {
        return DistCpV1.sameFile((FileSystem)x0, (FileStatus)x1, (FileSystem)x2, (Path)x3, (boolean)x4);
    }

    static /* synthetic */ void access$100(FileStatus x0, FileStatus x1, EnumSet x2, FileSystem x3) throws IOException {
        DistCpV1.updateDestStatus((FileStatus)x0, (FileStatus)x1, (EnumSet)x2, (FileSystem)x3);
    }

    static /* synthetic */ List access$300(Configuration x0, Path x1) throws IOException {
        return DistCpV1.fetchFileList((Configuration)x0, (Path)x1);
    }
}

