/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.tools.DistCh;
import org.apache.hadoop.tools.TestDistCh;
import org.apache.log4j.Level;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDistCh
extends TestCase {
    static final Long RANDOM_NUMBER_GENERATOR_SEED = null;
    static final FsPermission UMASK = FsPermission.createImmutable((short)73);
    private static final Random RANDOM = new Random();
    static final String TEST_ROOT_DIR;
    static final int NUN_SUBS = 7;

    public TestDistCh() {
        ((Log4JLogger)LogFactory.getLog((String)"org.apache.hadoop.hdfs.StateChange")).getLogger().setLevel(Level.ERROR);
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ERROR);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistCh() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.capacity.root.queues", "default");
        conf.set("yarn.scheduler.capacity.root.default.capacity", "100");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(true).build();
        FileSystem fs = cluster.getFileSystem();
        FsShell shell = new FsShell(conf);
        try {
            FileTree tree = new FileTree(fs, "testDistCh");
            FileStatus rootstatus = fs.getFileStatus(FileTree.access$100((FileTree)tree));
            TestDistCh.runLsr((FsShell)shell, (String)FileTree.access$200((FileTree)tree), (int)0);
            String[] args = new String[7];
            ChPermissionStatus[] newstatus = new ChPermissionStatus[7];
            args[0] = "/test/testDistCh/sub0:sub1::";
            newstatus[0] = new ChPermissionStatus(rootstatus, "sub1", "", "");
            args[1] = "/test/testDistCh/sub1::sub2:";
            newstatus[1] = new ChPermissionStatus(rootstatus, "", "sub2", "");
            args[2] = "/test/testDistCh/sub2:::437";
            newstatus[2] = new ChPermissionStatus(rootstatus, "", "", "437");
            args[3] = "/test/testDistCh/sub3:sub1:sub2:447";
            newstatus[3] = new ChPermissionStatus(rootstatus, "sub1", "sub2", "447");
            args[4] = "/test/testDistCh/sub4::sub5:437";
            newstatus[4] = new ChPermissionStatus(rootstatus, "", "sub5", "437");
            args[5] = "/test/testDistCh/sub5:sub1:sub5:";
            newstatus[5] = new ChPermissionStatus(rootstatus, "sub1", "sub5", "");
            args[6] = "/test/testDistCh/sub6:sub3::437";
            newstatus[6] = new ChPermissionStatus(rootstatus, "sub3", "", "437");
            System.out.println("args=" + Arrays.asList(args).toString().replace(",", ",\n  "));
            System.out.println("newstatus=" + Arrays.asList(newstatus).toString().replace(",", ",\n  "));
            new DistCh(MiniMRClientClusterFactory.create(this.getClass(), (int)2, (Configuration)conf).getConfig()).run(args);
            TestDistCh.runLsr((FsShell)shell, (String)FileTree.access$200((FileTree)tree), (int)0);
            for (int i = 0; i < 7; ++i) {
                Path sub = new Path(FileTree.access$200((FileTree)tree) + "/sub" + i);
                TestDistCh.checkFileStatus((ChPermissionStatus)newstatus[i], (FileStatus)fs.getFileStatus(sub));
                for (FileStatus status : fs.listStatus(sub)) {
                    TestDistCh.checkFileStatus((ChPermissionStatus)newstatus[i], (FileStatus)status);
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    static void checkFileStatus(ChPermissionStatus expected, FileStatus actual) {
        TestDistCh.assertEquals((String)expected.getUserName(), (String)actual.getOwner());
        TestDistCh.assertEquals((String)expected.getGroupName(), (String)actual.getGroup());
        FsPermission perm = expected.getPermission();
        if (actual.isFile() && ChPermissionStatus.access$300((ChPermissionStatus)expected)) {
            perm = perm.applyUMask(UMASK);
        }
        TestDistCh.assertEquals((Object)perm, (Object)actual.getPermission());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runLsr(FsShell shell, String root, int returnvalue) throws Exception {
        String results;
        System.out.println("root=" + root + ", returnvalue=" + returnvalue);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        System.setOut(out);
        System.setErr(out);
        try {
            TestDistCh.assertEquals((int)returnvalue, (int)shell.run(new String[]{"-lsr", root}));
            results = bytes.toString();
        }
        finally {
            IOUtils.closeStream((Closeable)out);
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
        System.out.println("results:\n" + results);
        return results;
    }

    static /* synthetic */ Random access$000() {
        return RANDOM;
    }

    static {
        long seed = RANDOM_NUMBER_GENERATOR_SEED == null ? RANDOM.nextLong() : RANDOM_NUMBER_GENERATOR_SEED.longValue();
        System.out.println("seed=" + seed);
        RANDOM.setSeed(seed);
        TEST_ROOT_DIR = new Path(System.getProperty("test.build.data", "/tmp")).toString().replace(' ', '+');
    }
}

