/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.tools.DiffInfo;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;

/*
 * Exception performing whole class analysis ignored.
 */
class DistCpSync {
    DistCpSync() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean sync(DistCpOptions inputOptions, Configuration conf) throws IOException {
        boolean bl;
        DiffInfo[] diffs;
        Path tmpDir;
        DistributedFileSystem targetFs;
        Path sourceDir;
        block8: {
            List sourcePaths = inputOptions.getSourcePaths();
            if (sourcePaths.size() != 1) {
                DistCp.LOG.warn((Object)(sourcePaths.size() + " source paths are provided"));
                return false;
            }
            sourceDir = (Path)sourcePaths.get(0);
            Path targetDir = inputOptions.getTargetPath();
            FileSystem sfs = sourceDir.getFileSystem(conf);
            FileSystem tfs = targetDir.getFileSystem(conf);
            if (!(sfs instanceof DistributedFileSystem) || !(tfs instanceof DistributedFileSystem)) {
                DistCp.LOG.warn((Object)"To use diff-based distcp, the FileSystems needs to be DistributedFileSystem");
                return false;
            }
            DistributedFileSystem sourceFs = (DistributedFileSystem)sfs;
            targetFs = (DistributedFileSystem)tfs;
            if (!DistCpSync.checkNoChange((DistCpOptions)inputOptions, (DistributedFileSystem)targetFs, (Path)targetDir)) {
                return false;
            }
            tmpDir = null;
            tmpDir = DistCpSync.createTargetTmpDir((DistributedFileSystem)targetFs, (Path)targetDir);
            diffs = DistCpSync.getDiffs((DistCpOptions)inputOptions, (DistributedFileSystem)sourceFs, (Path)sourceDir, (Path)targetDir);
            if (diffs != null) break block8;
            boolean bl2 = false;
            DistCpSync.deleteTargetTmpDir((DistributedFileSystem)targetFs, (Path)tmpDir);
            inputOptions.setSourcePaths(Arrays.asList(DistCpSync.getSourceSnapshotPath((Path)sourceDir, (String)inputOptions.getToSnapshot())));
            return bl2;
        }
        try {
            DistCpSync.syncDiff((DiffInfo[])diffs, (DistributedFileSystem)targetFs, (Path)tmpDir);
            bl = true;
        }
        catch (Exception e) {
            boolean bl3;
            try {
                DistCp.LOG.warn((Object)"Failed to use snapshot diff for distcp", (Throwable)e);
                bl3 = false;
            }
            catch (Throwable throwable) {
                DistCpSync.deleteTargetTmpDir((DistributedFileSystem)targetFs, (Path)tmpDir);
                inputOptions.setSourcePaths(Arrays.asList(DistCpSync.getSourceSnapshotPath((Path)sourceDir, (String)inputOptions.getToSnapshot())));
                throw throwable;
            }
            DistCpSync.deleteTargetTmpDir((DistributedFileSystem)targetFs, (Path)tmpDir);
            inputOptions.setSourcePaths(Arrays.asList(DistCpSync.getSourceSnapshotPath((Path)sourceDir, (String)inputOptions.getToSnapshot())));
            return bl3;
        }
        DistCpSync.deleteTargetTmpDir((DistributedFileSystem)targetFs, (Path)tmpDir);
        inputOptions.setSourcePaths(Arrays.asList(DistCpSync.getSourceSnapshotPath((Path)sourceDir, (String)inputOptions.getToSnapshot())));
        return bl;
    }

    private static String getSnapshotName(String name) {
        return ".".equals(name) ? "" : name;
    }

    private static Path getSourceSnapshotPath(Path sourceDir, String snapshotName) {
        if (".".equals(snapshotName)) {
            return sourceDir;
        }
        return new Path(sourceDir, ".snapshot/" + snapshotName);
    }

    private static Path createTargetTmpDir(DistributedFileSystem targetFs, Path targetDir) throws IOException {
        Path tmp = new Path(targetDir, ".distcp.diff.tmp" + DistCp.rand.nextInt());
        if (!targetFs.mkdirs(tmp)) {
            throw new IOException("The tmp directory " + tmp + " already exists");
        }
        return tmp;
    }

    private static void deleteTargetTmpDir(DistributedFileSystem targetFs, Path tmpDir) {
        try {
            if (tmpDir != null) {
                targetFs.delete(tmpDir, true);
            }
        }
        catch (IOException e) {
            DistCp.LOG.error((Object)("Unable to cleanup tmp dir: " + tmpDir), (Throwable)e);
        }
    }

    private static boolean checkNoChange(DistCpOptions inputOptions, DistributedFileSystem fs, Path path) {
        try {
            SnapshotDiffReport targetDiff = fs.getSnapshotDiffReport(path, inputOptions.getFromSnapshot(), "");
            if (!targetDiff.getDiffList().isEmpty()) {
                DistCp.LOG.warn((Object)("The target has been modified since snapshot " + inputOptions.getFromSnapshot()));
                return false;
            }
            return true;
        }
        catch (IOException e) {
            DistCp.LOG.warn((Object)("Failed to compute snapshot diff on " + path), (Throwable)e);
            return false;
        }
    }

    @VisibleForTesting
    static DiffInfo[] getDiffs(DistCpOptions inputOptions, DistributedFileSystem fs, Path sourceDir, Path targetDir) {
        try {
            String from = DistCpSync.getSnapshotName((String)inputOptions.getFromSnapshot());
            String to = DistCpSync.getSnapshotName((String)inputOptions.getToSnapshot());
            SnapshotDiffReport sourceDiff = fs.getSnapshotDiffReport(sourceDir, from, to);
            return DiffInfo.getDiffs((SnapshotDiffReport)sourceDiff, (Path)targetDir);
        }
        catch (IOException e) {
            DistCp.LOG.warn((Object)("Failed to compute snapshot diff on " + sourceDir), (Throwable)e);
            return null;
        }
    }

    private static void syncDiff(DiffInfo[] diffs, DistributedFileSystem targetFs, Path tmpDir) throws IOException {
        DistCpSync.moveToTmpDir((DiffInfo[])diffs, (DistributedFileSystem)targetFs, (Path)tmpDir);
        DistCpSync.moveToTarget((DiffInfo[])diffs, (DistributedFileSystem)targetFs);
    }

    private static void moveToTmpDir(DiffInfo[] diffs, DistributedFileSystem targetFs, Path tmpDir) throws IOException {
        Arrays.sort(diffs, DiffInfo.sourceComparator);
        Random random = new Random();
        for (DiffInfo diff : diffs) {
            Path tmpTarget = new Path(tmpDir, diff.source.getName());
            while (targetFs.exists(tmpTarget)) {
                tmpTarget = new Path(tmpDir, diff.source.getName() + random.nextInt());
            }
            diff.setTmp(tmpTarget);
            targetFs.rename(diff.source, tmpTarget);
        }
    }

    private static void moveToTarget(DiffInfo[] diffs, DistributedFileSystem targetFs) throws IOException {
        Arrays.sort(diffs, DiffInfo.targetComparator);
        for (DiffInfo diff : diffs) {
            if (diff.target == null) continue;
            if (!targetFs.exists(diff.target.getParent())) {
                targetFs.mkdirs(diff.target.getParent());
            }
            targetFs.rename(diff.getTmp(), diff.target);
        }
    }
}

