/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tools.util.DistCpTestUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestDistCpWithRawXAttrs {
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static FileSystem fs;
    private static final String rawName1 = "raw.a1";
    private static final byte[] rawValue1;
    private static final String userName1 = "user.a1";
    private static final byte[] userValue1;
    private static final Path dir1;
    private static final Path subDir1;
    private static final Path file1;
    private static final String rawRootName = "/.reserved/raw";
    private static final String rootedDestName = "/dest";
    private static final String rootedSrcName = "/src";
    private static final String rawDestName = "/.reserved/raw/dest";
    private static final String rawSrcName = "/.reserved/raw/src";
    private static Path[] pathnames;

    @BeforeClass
    public static void init() throws Exception {
        conf = new Configuration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(true).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
    }

    @AfterClass
    public static void shutdown() {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fs});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreserveRawXAttrs1() throws Exception {
        String relSrc = "/./.reserved/../.reserved/raw/../raw/src/../src";
        String relDst = "/./.reserved/../.reserved/raw/../raw/dest/../dest";
        this.doTestPreserveRawXAttrs("/./.reserved/../.reserved/raw/../raw/src/../src", "/./.reserved/../.reserved/raw/../raw/dest/../dest", "-px", true, true, 0);
        this.doTestPreserveRawXAttrs("/src", "/dest", "-px", false, true, 0);
        this.doTestPreserveRawXAttrs("/src", "/.reserved/raw/dest", "-px", false, true, -1);
        this.doTestPreserveRawXAttrs("/.reserved/raw/src", "/dest", "-px", false, true, -1);
        this.doTestPreserveRawXAttrs("/.reserved/raw/src", "/.reserved/raw/dest", "-px", true, true, 0);
        Path savedWd = fs.getWorkingDirectory();
        try {
            fs.setWorkingDirectory(new Path("/.reserved/raw"));
            this.doTestPreserveRawXAttrs("../../.reserved/raw/src", "../../.reserved/raw/dest", "-px", true, true, 0);
        }
        finally {
            fs.setWorkingDirectory(savedWd);
        }
    }

    @Test
    public void testPreserveRawXAttrs2() throws Exception {
        this.doTestPreserveRawXAttrs("/src", "/dest", "-p", false, false, 0);
        this.doTestPreserveRawXAttrs("/src", "/.reserved/raw/dest", "-p", false, false, -1);
        this.doTestPreserveRawXAttrs("/.reserved/raw/src", "/dest", "-p", false, false, -1);
        this.doTestPreserveRawXAttrs("/.reserved/raw/src", "/.reserved/raw/dest", "-p", true, false, 0);
    }

    @Test
    public void testPreserveRawXAttrs3() throws Exception {
        this.doTestPreserveRawXAttrs("/src", "/dest", null, false, false, 0);
        this.doTestPreserveRawXAttrs("/src", "/.reserved/raw/dest", null, false, false, -1);
        this.doTestPreserveRawXAttrs("/.reserved/raw/src", "/dest", null, false, false, -1);
        this.doTestPreserveRawXAttrs("/.reserved/raw/src", "/.reserved/raw/dest", null, true, false, 0);
    }

    private static void makeFilesAndDirs(FileSystem fs) throws Exception {
        fs.delete(new Path("/src"), true);
        fs.delete(new Path("/dest"), true);
        fs.mkdirs(subDir1);
        fs.create(file1).close();
    }

    private void initXAttrs() throws Exception {
        TestDistCpWithRawXAttrs.makeFilesAndDirs((FileSystem)fs);
        for (Path p : pathnames) {
            fs.setXAttr(new Path("/.reserved/raw/src", p), "raw.a1", rawValue1);
            fs.setXAttr(new Path("/.reserved/raw/src", p), "user.a1", userValue1);
        }
    }

    private void doTestPreserveRawXAttrs(String src, String dest, String preserveOpts, boolean expectRaw, boolean expectUser, int expectedExitCode) throws Exception {
        this.initXAttrs();
        DistCpTestUtils.assertRunDistCp((int)expectedExitCode, (String)src, (String)dest, (String)preserveOpts, (Configuration)conf);
        if (expectedExitCode == 0) {
            HashMap xAttrs = Maps.newHashMap();
            for (Path p : pathnames) {
                xAttrs.clear();
                if (expectRaw) {
                    xAttrs.put("raw.a1", rawValue1);
                }
                if (expectUser) {
                    xAttrs.put("user.a1", userValue1);
                }
                DistCpTestUtils.assertXAttrs((Path)new Path(dest, p), (FileSystem)fs, (Map)xAttrs);
            }
        }
    }

    static {
        rawValue1 = new byte[]{55, 56, 57};
        userValue1 = new byte[]{56, 56, 56};
        dir1 = new Path("/src/dir1");
        subDir1 = new Path(dir1, "subdir1");
        file1 = new Path("/src/file1");
        pathnames = new Path[]{new Path("dir1"), new Path("dir1/subdir1"), new Path("file1")};
    }
}

