/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.OptionsParser;
import org.junit.Assert;
import org.junit.Test;

public class TestOptionsParser {
    @Test
    public void testParseIgnoreFailure() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertFalse((boolean)options.shouldIgnoreFailures());
        options = OptionsParser.parse((String[])new String[]{"-i", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertTrue((boolean)options.shouldIgnoreFailures());
    }

    @Test
    public void testParseOverwrite() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertFalse((boolean)options.shouldOverwrite());
        options = OptionsParser.parse((String[])new String[]{"-overwrite", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertTrue((boolean)options.shouldOverwrite());
        try {
            OptionsParser.parse((String[])new String[]{"-update", "-overwrite", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            Assert.fail((String)"Update and overwrite aren't allowed together");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testLogPath() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertNull((Object)options.getLogPath());
        options = OptionsParser.parse((String[])new String[]{"-log", "hdfs://localhost:8020/logs", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertEquals((Object)options.getLogPath(), (Object)new Path("hdfs://localhost:8020/logs"));
    }

    @Test
    public void testParseBlokcing() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertTrue((boolean)options.shouldBlock());
        options = OptionsParser.parse((String[])new String[]{"-async", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertFalse((boolean)options.shouldBlock());
    }

    @Test
    public void testParsebandwidth() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertEquals((long)options.getMapBandwidth(), (long)100L);
        options = OptionsParser.parse((String[])new String[]{"-bandwidth", "11", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertEquals((long)options.getMapBandwidth(), (long)11L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseNonPositiveBandwidth() {
        OptionsParser.parse((String[])new String[]{"-bandwidth", "-11", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseZeroBandwidth() {
        OptionsParser.parse((String[])new String[]{"-bandwidth", "0", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
    }

    @Test
    public void testParseSkipCRC() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertFalse((boolean)options.shouldSkipCRC());
        options = OptionsParser.parse((String[])new String[]{"-update", "-skipcrccheck", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertTrue((boolean)options.shouldSyncFolder());
        Assert.assertTrue((boolean)options.shouldSkipCRC());
    }

    @Test
    public void testParseAtomicCommit() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertFalse((boolean)options.shouldAtomicCommit());
        options = OptionsParser.parse((String[])new String[]{"-atomic", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertTrue((boolean)options.shouldAtomicCommit());
        try {
            OptionsParser.parse((String[])new String[]{"-atomic", "-update", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            Assert.fail((String)"Atomic and sync folders were allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseWorkPath() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertNull((Object)options.getAtomicWorkPath());
        options = OptionsParser.parse((String[])new String[]{"-atomic", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertNull((Object)options.getAtomicWorkPath());
        options = OptionsParser.parse((String[])new String[]{"-atomic", "-tmp", "hdfs://localhost:8020/work", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertEquals((Object)options.getAtomicWorkPath(), (Object)new Path("hdfs://localhost:8020/work"));
        try {
            OptionsParser.parse((String[])new String[]{"-tmp", "hdfs://localhost:8020/work", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            Assert.fail((String)"work path was allowed without -atomic switch");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseSyncFolders() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertFalse((boolean)options.shouldSyncFolder());
        options = OptionsParser.parse((String[])new String[]{"-update", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertTrue((boolean)options.shouldSyncFolder());
    }

    @Test
    public void testParseDeleteMissing() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertFalse((boolean)options.shouldDeleteMissing());
        options = OptionsParser.parse((String[])new String[]{"-update", "-delete", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertTrue((boolean)options.shouldSyncFolder());
        Assert.assertTrue((boolean)options.shouldDeleteMissing());
        options = OptionsParser.parse((String[])new String[]{"-overwrite", "-delete", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertTrue((boolean)options.shouldOverwrite());
        Assert.assertTrue((boolean)options.shouldDeleteMissing());
        try {
            OptionsParser.parse((String[])new String[]{"-atomic", "-delete", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            Assert.fail((String)"Atomic and delete folders were allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseSSLConf() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertNull((Object)options.getSslConfigurationFile());
        options = OptionsParser.parse((String[])new String[]{"-mapredSslConf", "/tmp/ssl-client.xml", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertEquals((Object)options.getSslConfigurationFile(), (Object)"/tmp/ssl-client.xml");
    }

    @Test
    public void testParseMaps() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertEquals((long)options.getMaxMaps(), (long)20L);
        options = OptionsParser.parse((String[])new String[]{"-m", "1", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertEquals((long)options.getMaxMaps(), (long)1L);
        options = OptionsParser.parse((String[])new String[]{"-m", "0", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertEquals((long)options.getMaxMaps(), (long)1L);
        try {
            OptionsParser.parse((String[])new String[]{"-m", "hello", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            Assert.fail((String)"Non numberic map parsed");
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            OptionsParser.parse((String[])new String[]{"-mapredXslConf", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            Assert.fail((String)"Non numberic map parsed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSourceListing() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertEquals((Object)options.getSourceFileListing(), (Object)new Path("hdfs://localhost:8020/source/first"));
    }

    @Test
    public void testSourceListingAndSourcePath() {
        try {
            OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            Assert.fail((String)"Both source listing & source paths allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMissingSourceInfo() {
        try {
            OptionsParser.parse((String[])new String[]{"hdfs://localhost:8020/target/"});
            Assert.fail((String)"Neither source listing not source paths present");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMissingTarget() {
        try {
            OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:8020/source"});
            Assert.fail((String)"Missing target allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidArgs() {
        try {
            OptionsParser.parse((String[])new String[]{"-m", "-f", "hdfs://localhost:8020/source"});
            Assert.fail((String)"Missing map value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToString() {
        DistCpOptions option = new DistCpOptions(new Path("abc"), new Path("xyz"));
        String val = "DistCpOptions{atomicCommit=false, syncFolder=false, deleteMissing=false, ignoreFailures=false, maxMaps=20, sslConfigurationFile='null', copyStrategy='uniformsize', sourceFileListing=abc, sourcePaths=null, targetPath=xyz, targetPathExists=true}";
        Assert.assertEquals((Object)val, (Object)option.toString());
        Assert.assertNotSame((Object)DistCpOptionSwitch.ATOMIC_COMMIT.toString(), (Object)DistCpOptionSwitch.ATOMIC_COMMIT.name());
    }

    @Test
    public void testCopyStrategy() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-strategy", "dynamic", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertEquals((Object)options.getCopyStrategy(), (Object)"dynamic");
        options = OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertEquals((Object)options.getCopyStrategy(), (Object)"uniformsize");
    }

    @Test
    public void testTargetPath() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertEquals((Object)options.getTargetPath(), (Object)new Path("hdfs://localhost:8020/target/"));
    }

    @Test
    public void testPreserve() {
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        options = OptionsParser.parse((String[])new String[]{"-p", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-p", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-pbr", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-pbrgup", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-pbrgupcax", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-pc", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.BLOCKSIZE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.REPLICATION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.USER));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.GROUP));
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.CHECKSUMTYPE));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.ACL));
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.XATTR));
        options = OptionsParser.parse((String[])new String[]{"-p", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        int i = 0;
        Iterator attribIterator = options.preserveAttributes();
        while (attribIterator.hasNext()) {
            attribIterator.next();
            ++i;
        }
        Assert.assertEquals((long)i, (long)6L);
        try {
            OptionsParser.parse((String[])new String[]{"-pabcd", "-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target"});
            Assert.fail((String)"Invalid preserve attribute");
        }
        catch (IllegalArgumentException ignore) {
        }
        catch (NoSuchElementException ignore) {
            // empty catch block
        }
        options = OptionsParser.parse((String[])new String[]{"-f", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        Assert.assertFalse((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        options.preserve(DistCpOptions.FileAttribute.PERMISSION);
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
        options.preserve(DistCpOptions.FileAttribute.PERMISSION);
        Assert.assertTrue((boolean)options.shouldPreserve(DistCpOptions.FileAttribute.PERMISSION));
    }

    @Test
    public void testOptionsSwitchAddToConf() {
        Configuration conf = new Configuration();
        Assert.assertNull((Object)conf.get(DistCpOptionSwitch.ATOMIC_COMMIT.getConfigLabel()));
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.ATOMIC_COMMIT);
        Assert.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.ATOMIC_COMMIT.getConfigLabel(), false));
    }

    @Test
    public void testOptionsAppendToConf() {
        Configuration conf = new Configuration();
        Assert.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.IGNORE_FAILURES.getConfigLabel(), false));
        Assert.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.ATOMIC_COMMIT.getConfigLabel(), false));
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-atomic", "-i", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        Assert.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.IGNORE_FAILURES.getConfigLabel(), false));
        Assert.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.ATOMIC_COMMIT.getConfigLabel(), false));
        Assert.assertEquals((long)conf.getInt(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), -1), (long)100L);
        conf = new Configuration();
        Assert.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), false));
        Assert.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.DELETE_MISSING.getConfigLabel(), false));
        Assert.assertEquals((Object)conf.get(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel()), null);
        options = OptionsParser.parse((String[])new String[]{"-update", "-delete", "-pu", "-bandwidth", "11", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        Assert.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), false));
        Assert.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.DELETE_MISSING.getConfigLabel(), false));
        Assert.assertEquals((Object)conf.get(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel()), (Object)"U");
        Assert.assertEquals((long)conf.getInt(DistCpOptionSwitch.BANDWIDTH.getConfigLabel(), -1), (long)11L);
    }

    @Test
    public void testAppendOption() {
        Configuration conf = new Configuration();
        Assert.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.APPEND.getConfigLabel(), false));
        Assert.assertFalse((boolean)conf.getBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), false));
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-update", "-append", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        Assert.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.APPEND.getConfigLabel(), false));
        Assert.assertTrue((boolean)conf.getBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), false));
        try {
            options = OptionsParser.parse((String[])new String[]{"-append", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            Assert.fail((String)"Append should fail if update option is not specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Append is valid only with update options", (Throwable)e);
        }
        try {
            options = OptionsParser.parse((String[])new String[]{"-append", "-update", "-skipcrccheck", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            Assert.fail((String)"Append should fail if skipCrc option is specified");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Append is disallowed when skipping CRC", (Throwable)e);
        }
    }

    @Test
    public void testFileSizeOption() {
        Configuration conf = new Configuration();
        Assert.assertNull((Object)conf.get(DistCpOptionSwitch.MIN_FILE_SIZE.getConfigLabel()));
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.MIN_FILE_SIZE, (String)"10");
        Assert.assertEquals((Object)"10", (Object)conf.get(DistCpOptionSwitch.MIN_FILE_SIZE.getConfigLabel()));
        Assert.assertNull((Object)conf.get(DistCpOptionSwitch.MAX_FILE_SIZE.getConfigLabel()));
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.MAX_FILE_SIZE, (String)"900");
        Assert.assertEquals((Object)"900", (Object)conf.get(DistCpOptionSwitch.MAX_FILE_SIZE.getConfigLabel()));
        DistCpOptions options = OptionsParser.parse((String[])new String[]{"-filesizemin", "20", "-filesizemax", "50", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
        options.appendToConf(conf);
        Assert.assertEquals((Object)"20", (Object)conf.get(DistCpOptionSwitch.MIN_FILE_SIZE.getConfigLabel()));
        Assert.assertEquals((Object)"50", (Object)conf.get(DistCpOptionSwitch.MAX_FILE_SIZE.getConfigLabel()));
        try {
            options = OptionsParser.parse((String[])new String[]{"-filesizemin", "100", "-filesizemax", "99", "hdfs://localhost:8020/source/first", "hdfs://localhost:8020/target/"});
            Assert.fail((String)"Should fail since max file size is less than min file size");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Maximum file size cannot be less than minimum file size: 100", (Throwable)e);
        }
    }
}

