/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.util.DistCpUtils;

public class DistCpOptions {
    private boolean atomicCommit = false;
    private boolean syncFolder = false;
    private boolean deleteMissing = false;
    private boolean ignoreFailures = false;
    private boolean overwrite = false;
    private boolean append = false;
    private boolean skipCRC = false;
    private boolean blocking = true;
    private int maxMaps = 20;
    private int mapBandwidth = 100;
    private String sslConfigurationFile;
    private String copyStrategy = "uniformsize";
    private EnumSet<FileAttribute> preserveStatus = EnumSet.noneOf(FileAttribute.class);
    private Path atomicWorkPath;
    private Path logPath;
    private Path sourceFileListing;
    private List<Path> sourcePaths;
    private Path targetPath;
    private boolean targetPathExists = true;
    private long minFileSize = 0L;
    private long maxFileSize = Long.MAX_VALUE;

    public DistCpOptions(List<Path> sourcePaths, Path targetPath) {
        assert (sourcePaths != null && !sourcePaths.isEmpty()) : "Invalid source paths";
        assert (targetPath != null) : "Invalid Target path";
        this.sourcePaths = sourcePaths;
        this.targetPath = targetPath;
    }

    public DistCpOptions(Path sourceFileListing, Path targetPath) {
        assert (sourceFileListing != null) : "Invalid source paths";
        assert (targetPath != null) : "Invalid Target path";
        this.sourceFileListing = sourceFileListing;
        this.targetPath = targetPath;
    }

    public DistCpOptions(DistCpOptions that) {
        if (this != that && that != null) {
            this.atomicCommit = that.atomicCommit;
            this.syncFolder = that.syncFolder;
            this.deleteMissing = that.deleteMissing;
            this.ignoreFailures = that.ignoreFailures;
            this.overwrite = that.overwrite;
            this.skipCRC = that.skipCRC;
            this.blocking = that.blocking;
            this.maxMaps = that.maxMaps;
            this.mapBandwidth = that.mapBandwidth;
            this.sslConfigurationFile = that.getSslConfigurationFile();
            this.copyStrategy = that.copyStrategy;
            this.preserveStatus = that.preserveStatus;
            this.atomicWorkPath = that.getAtomicWorkPath();
            this.logPath = that.getLogPath();
            this.sourceFileListing = that.getSourceFileListing();
            this.sourcePaths = that.getSourcePaths();
            this.targetPath = that.getTargetPath();
            this.targetPathExists = that.getTargetPathExists();
            this.minFileSize = that.minFileSize;
            this.maxFileSize = that.maxFileSize;
        }
    }

    public boolean shouldAtomicCommit() {
        return this.atomicCommit;
    }

    public void setAtomicCommit(boolean atomicCommit) {
        this.validate(DistCpOptionSwitch.ATOMIC_COMMIT, atomicCommit);
        this.atomicCommit = atomicCommit;
    }

    public boolean shouldSyncFolder() {
        return this.syncFolder;
    }

    public void setSyncFolder(boolean syncFolder) {
        this.validate(DistCpOptionSwitch.SYNC_FOLDERS, syncFolder);
        this.syncFolder = syncFolder;
    }

    public boolean shouldDeleteMissing() {
        return this.deleteMissing;
    }

    public void setDeleteMissing(boolean deleteMissing) {
        this.validate(DistCpOptionSwitch.DELETE_MISSING, deleteMissing);
        this.deleteMissing = deleteMissing;
    }

    public boolean shouldIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    public boolean shouldBlock() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public boolean shouldOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.validate(DistCpOptionSwitch.OVERWRITE, overwrite);
        this.overwrite = overwrite;
    }

    public boolean shouldAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.validate(DistCpOptionSwitch.APPEND, append);
        this.append = append;
    }

    public boolean shouldSkipCRC() {
        return this.skipCRC;
    }

    public void setSkipCRC(boolean skipCRC) {
        this.validate(DistCpOptionSwitch.SKIP_CRC, skipCRC);
        this.skipCRC = skipCRC;
    }

    public int getMaxMaps() {
        return this.maxMaps;
    }

    public void setMaxMaps(int maxMaps) {
        this.maxMaps = Math.max(maxMaps, 1);
    }

    public int getMapBandwidth() {
        return this.mapBandwidth;
    }

    public void setMapBandwidth(int mapBandwidth) {
        assert (mapBandwidth > 0) : "Bandwidth " + mapBandwidth + " is invalid (should be > 0)";
        this.mapBandwidth = mapBandwidth;
    }

    public long getMinFileSize() {
        return this.minFileSize;
    }

    public void setMinFileSize(long minFileSize) {
        this.minFileSize = minFileSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public String getSslConfigurationFile() {
        return this.sslConfigurationFile;
    }

    public void setSslConfigurationFile(String sslConfigurationFile) {
        this.sslConfigurationFile = sslConfigurationFile;
    }

    public Iterator<FileAttribute> preserveAttributes() {
        return this.preserveStatus.iterator();
    }

    public boolean shouldPreserve(FileAttribute attribute) {
        return this.preserveStatus.contains(attribute);
    }

    public void preserve(FileAttribute fileAttribute) {
        for (FileAttribute attribute : this.preserveStatus) {
            if (!attribute.equals((Object)fileAttribute)) continue;
            return;
        }
        this.preserveStatus.add(fileAttribute);
    }

    public Path getAtomicWorkPath() {
        return this.atomicWorkPath;
    }

    public void setAtomicWorkPath(Path atomicWorkPath) {
        this.atomicWorkPath = atomicWorkPath;
    }

    public Path getLogPath() {
        return this.logPath;
    }

    public void setLogPath(Path logPath) {
        this.logPath = logPath;
    }

    public String getCopyStrategy() {
        return this.copyStrategy;
    }

    public void setCopyStrategy(String copyStrategy) {
        this.copyStrategy = copyStrategy;
    }

    public Path getSourceFileListing() {
        return this.sourceFileListing;
    }

    public List<Path> getSourcePaths() {
        return this.sourcePaths;
    }

    public void setSourcePaths(List<Path> sourcePaths) {
        assert (sourcePaths != null && sourcePaths.size() != 0);
        this.sourcePaths = sourcePaths;
    }

    public Path getTargetPath() {
        return this.targetPath;
    }

    public boolean getTargetPathExists() {
        return this.targetPathExists;
    }

    public boolean setTargetPathExists(boolean targetPathExists) {
        this.targetPathExists = targetPathExists;
        return this.targetPathExists;
    }

    public void validate(DistCpOptionSwitch option, boolean value) {
        boolean append;
        boolean syncFolder = option == DistCpOptionSwitch.SYNC_FOLDERS ? value : this.syncFolder;
        boolean overwrite = option == DistCpOptionSwitch.OVERWRITE ? value : this.overwrite;
        boolean deleteMissing = option == DistCpOptionSwitch.DELETE_MISSING ? value : this.deleteMissing;
        boolean atomicCommit = option == DistCpOptionSwitch.ATOMIC_COMMIT ? value : this.atomicCommit;
        boolean skipCRC = option == DistCpOptionSwitch.SKIP_CRC ? value : this.skipCRC;
        boolean bl = append = option == DistCpOptionSwitch.APPEND ? value : this.append;
        if (syncFolder && atomicCommit) {
            throw new IllegalArgumentException("Atomic commit can't be used with sync folder or overwrite options");
        }
        if (deleteMissing && !overwrite && !syncFolder) {
            throw new IllegalArgumentException("Delete missing is applicable only with update or overwrite options");
        }
        if (overwrite && syncFolder) {
            throw new IllegalArgumentException("Overwrite and update options are mutually exclusive");
        }
        if (!syncFolder && skipCRC) {
            throw new IllegalArgumentException("Skip CRC is valid only with update options");
        }
        if (!syncFolder && append) {
            throw new IllegalArgumentException("Append is valid only with update options");
        }
        if (skipCRC && append) {
            throw new IllegalArgumentException("Append is disallowed when skipping CRC");
        }
    }

    public void appendToConf(Configuration conf) {
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.ATOMIC_COMMIT, (String)String.valueOf(this.atomicCommit));
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.IGNORE_FAILURES, (String)String.valueOf(this.ignoreFailures));
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.SYNC_FOLDERS, (String)String.valueOf(this.syncFolder));
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.DELETE_MISSING, (String)String.valueOf(this.deleteMissing));
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.OVERWRITE, (String)String.valueOf(this.overwrite));
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.APPEND, (String)String.valueOf(this.append));
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.SKIP_CRC, (String)String.valueOf(this.skipCRC));
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.BANDWIDTH, (String)String.valueOf(this.mapBandwidth));
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.PRESERVE_STATUS, (String)DistCpUtils.packAttributes((EnumSet)this.preserveStatus));
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.MIN_FILE_SIZE, (String)String.valueOf(this.minFileSize));
        DistCpOptionSwitch.addToConf((Configuration)conf, (DistCpOptionSwitch)DistCpOptionSwitch.MAX_FILE_SIZE, (String)String.valueOf(this.maxFileSize));
    }

    public String toString() {
        return "DistCpOptions{atomicCommit=" + this.atomicCommit + ", syncFolder=" + this.syncFolder + ", deleteMissing=" + this.deleteMissing + ", ignoreFailures=" + this.ignoreFailures + ", maxMaps=" + this.maxMaps + ", sslConfigurationFile='" + this.sslConfigurationFile + '\'' + ", copyStrategy='" + this.copyStrategy + '\'' + ", sourceFileListing=" + this.sourceFileListing + ", sourcePaths=" + this.sourcePaths + ", targetPath=" + this.targetPath + ", targetPathExists=" + this.targetPathExists + '}';
    }

    protected DistCpOptions clone() throws CloneNotSupportedException {
        return (DistCpOptions)super.clone();
    }
}

