/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.GlobbedCopyListing;
import org.apache.hadoop.tools.mapred.CopyCommitter;
import org.apache.hadoop.tools.mapred.TestCopyCommitter;
import org.apache.hadoop.tools.util.TestDistCpUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestCopyCommitter {
    private static final Log LOG = LogFactory.getLog(TestCopyCommitter.class);
    private static final Random rand = new Random();
    private static final Credentials CREDENTIALS = new Credentials();
    public static final int PORT = 39737;
    private static Configuration config;
    private static MiniDFSCluster cluster;

    private static Job getJobForClient() throws IOException {
        Job job = Job.getInstance((Configuration)new Configuration());
        job.getConfiguration().set("mapred.job.tracker", "localhost:39737");
        job.setInputFormatClass(NullInputFormat.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setNumReduceTasks(0);
        return job;
    }

    @BeforeClass
    public static void create() throws IOException {
        config = TestCopyCommitter.getJobForClient().getConfiguration();
        config.setLong("mapred.total.bytes.expected", 0L);
        cluster = new MiniDFSCluster.Builder(config).numDataNodes(1).format(true).build();
    }

    @AfterClass
    public static void destroy() {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void createMetaFolder() {
        config.set("distcp.meta.folder", "/meta");
        Path meta = new Path("/meta");
        try {
            cluster.getFileSystem().mkdirs(meta);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while creating meta folder", (Throwable)e);
            Assert.fail((String)"Unable to create meta folder");
        }
    }

    @After
    public void cleanupMetaFolder() {
        Path meta = new Path("/meta");
        try {
            if (cluster.getFileSystem().exists(meta)) {
                cluster.getFileSystem().delete(meta, true);
                Assert.fail((String)"Expected meta folder to be deleted");
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered while cleaning up folder", (Throwable)e);
            Assert.fail((String)"Unable to clean up meta folder");
        }
    }

    @Test
    public void testNoCommitAction() {
        TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(config);
        JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
        try {
            CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
            committer.commitJob((JobContext)jobContext);
            Assert.assertEquals((Object)taskAttemptContext.getStatus(), (Object)"Commit Successful");
            committer.commitJob((JobContext)jobContext);
            Assert.assertEquals((Object)taskAttemptContext.getStatus(), (Object)"Commit Successful");
        }
        catch (IOException e) {
            LOG.error((Object)"Exception encountered ", (Throwable)e);
            Assert.fail((String)"Commit failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreserveStatus() {
        FileSystem fs;
        Configuration conf;
        block5: {
            TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(config);
            JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
            conf = jobContext.getConfiguration();
            fs = null;
            try {
                CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
                fs = FileSystem.get((Configuration)conf);
                FsPermission sourcePerm = new FsPermission(511);
                FsPermission initialPerm = new FsPermission(448);
                String sourceBase = TestDistCpUtils.createTestSetup((FileSystem)fs, (FsPermission)sourcePerm);
                String targetBase = TestDistCpUtils.createTestSetup((FileSystem)fs, (FsPermission)initialPerm);
                DistCpOptions options = new DistCpOptions(Arrays.asList(new Path(sourceBase)), new Path("/out"));
                options.preserve(DistCpOptions.FileAttribute.PERMISSION);
                options.appendToConf(conf);
                GlobbedCopyListing listing = new GlobbedCopyListing(conf, CREDENTIALS);
                Path listingFile = new Path("/tmp1/" + String.valueOf(rand.nextLong()));
                listing.buildListing(listingFile, options);
                conf.set("distcp.target.work.path", targetBase);
                committer.commitJob((JobContext)jobContext);
                if (!this.checkDirectoryPermissions(fs, targetBase, sourcePerm)) {
                    Assert.fail((String)"Permission don't match");
                }
                committer.commitJob((JobContext)jobContext);
                if (this.checkDirectoryPermissions(fs, targetBase, sourcePerm)) break block5;
                Assert.fail((String)"Permission don't match");
            }
            catch (IOException e) {
                try {
                    LOG.error((Object)"Exception encountered while testing for preserve status", (Throwable)e);
                    Assert.fail((String)"Preserve status failure");
                }
                catch (Throwable throwable) {
                    TestDistCpUtils.delete(fs, (String)"/tmp1");
                    conf.unset("distcp.preserve.status");
                    throw throwable;
                }
                TestDistCpUtils.delete((FileSystem)fs, (String)"/tmp1");
                conf.unset("distcp.preserve.status");
            }
        }
        TestDistCpUtils.delete((FileSystem)fs, (String)"/tmp1");
        conf.unset("distcp.preserve.status");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteMissing() {
        FileSystem fs;
        Configuration conf;
        block7: {
            TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(config);
            JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
            conf = jobContext.getConfiguration();
            fs = null;
            try {
                CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
                fs = FileSystem.get((Configuration)conf);
                String sourceBase = TestDistCpUtils.createTestSetup((FileSystem)fs, (FsPermission)FsPermission.getDefault());
                String targetBase = TestDistCpUtils.createTestSetup((FileSystem)fs, (FsPermission)FsPermission.getDefault());
                String targetBaseAdd = TestDistCpUtils.createTestSetup((FileSystem)fs, (FsPermission)FsPermission.getDefault());
                fs.rename(new Path(targetBaseAdd), new Path(targetBase));
                DistCpOptions options = new DistCpOptions(Arrays.asList(new Path(sourceBase)), new Path("/out"));
                options.setSyncFolder(true);
                options.setDeleteMissing(true);
                options.appendToConf(conf);
                GlobbedCopyListing listing = new GlobbedCopyListing(conf, CREDENTIALS);
                Path listingFile = new Path("/tmp1/" + String.valueOf(rand.nextLong()));
                listing.buildListing(listingFile, options);
                conf.set("distcp.target.work.path", targetBase);
                conf.set("distcp.target.final.path", targetBase);
                committer.commitJob((JobContext)jobContext);
                if (!TestDistCpUtils.checkIfFoldersAreInSync((FileSystem)fs, (String)targetBase, (String)sourceBase)) {
                    Assert.fail((String)"Source and target folders are not in sync");
                }
                if (!TestDistCpUtils.checkIfFoldersAreInSync((FileSystem)fs, (String)sourceBase, (String)targetBase)) {
                    Assert.fail((String)"Source and target folders are not in sync");
                }
                committer.commitJob((JobContext)jobContext);
                if (!TestDistCpUtils.checkIfFoldersAreInSync((FileSystem)fs, (String)targetBase, (String)sourceBase)) {
                    Assert.fail((String)"Source and target folders are not in sync");
                }
                if (TestDistCpUtils.checkIfFoldersAreInSync((FileSystem)fs, (String)sourceBase, (String)targetBase)) break block7;
                Assert.fail((String)"Source and target folders are not in sync");
            }
            catch (Throwable e) {
                try {
                    LOG.error((Object)"Exception encountered while testing for delete missing", e);
                    Assert.fail((String)"Delete missing failure");
                }
                catch (Throwable throwable) {
                    TestDistCpUtils.delete(fs, (String)"/tmp1");
                    conf.set("distcp.delete.missing.source", "false");
                    throw throwable;
                }
                TestDistCpUtils.delete((FileSystem)fs, (String)"/tmp1");
                conf.set("distcp.delete.missing.source", "false");
            }
        }
        TestDistCpUtils.delete((FileSystem)fs, (String)"/tmp1");
        conf.set("distcp.delete.missing.source", "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteMissingFlatInterleavedFiles() {
        TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(config);
        JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
        Configuration conf = jobContext.getConfiguration();
        FileSystem fs = null;
        try {
            CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
            fs = FileSystem.get((Configuration)conf);
            String sourceBase = "/tmp1/" + String.valueOf(rand.nextLong());
            String targetBase = "/tmp1/" + String.valueOf(rand.nextLong());
            TestDistCpUtils.createFile((FileSystem)fs, (String)(sourceBase + "/1"));
            TestDistCpUtils.createFile((FileSystem)fs, (String)(sourceBase + "/3"));
            TestDistCpUtils.createFile((FileSystem)fs, (String)(sourceBase + "/4"));
            TestDistCpUtils.createFile((FileSystem)fs, (String)(sourceBase + "/5"));
            TestDistCpUtils.createFile((FileSystem)fs, (String)(sourceBase + "/7"));
            TestDistCpUtils.createFile((FileSystem)fs, (String)(sourceBase + "/8"));
            TestDistCpUtils.createFile((FileSystem)fs, (String)(sourceBase + "/9"));
            TestDistCpUtils.createFile((FileSystem)fs, (String)(targetBase + "/2"));
            TestDistCpUtils.createFile((FileSystem)fs, (String)(targetBase + "/4"));
            TestDistCpUtils.createFile((FileSystem)fs, (String)(targetBase + "/5"));
            TestDistCpUtils.createFile((FileSystem)fs, (String)(targetBase + "/7"));
            TestDistCpUtils.createFile((FileSystem)fs, (String)(targetBase + "/9"));
            TestDistCpUtils.createFile((FileSystem)fs, (String)(targetBase + "/A"));
            DistCpOptions options = new DistCpOptions(Arrays.asList(new Path(sourceBase)), new Path("/out"));
            options.setSyncFolder(true);
            options.setDeleteMissing(true);
            options.appendToConf(conf);
            GlobbedCopyListing listing = new GlobbedCopyListing(conf, CREDENTIALS);
            Path listingFile = new Path("/tmp1/" + String.valueOf(rand.nextLong()));
            listing.buildListing(listingFile, options);
            conf.set("distcp.target.work.path", targetBase);
            conf.set("distcp.target.final.path", targetBase);
            committer.commitJob((JobContext)jobContext);
            if (!TestDistCpUtils.checkIfFoldersAreInSync((FileSystem)fs, (String)targetBase, (String)sourceBase)) {
                Assert.fail((String)"Source and target folders are not in sync");
            }
            Assert.assertEquals((long)fs.listStatus(new Path(targetBase)).length, (long)4L);
            committer.commitJob((JobContext)jobContext);
            if (!TestDistCpUtils.checkIfFoldersAreInSync((FileSystem)fs, (String)targetBase, (String)sourceBase)) {
                Assert.fail((String)"Source and target folders are not in sync");
            }
            Assert.assertEquals((long)fs.listStatus(new Path(targetBase)).length, (long)4L);
        }
        catch (IOException e) {
            try {
                LOG.error((Object)"Exception encountered while testing for delete missing", (Throwable)e);
                Assert.fail((String)"Delete missing failure");
            }
            catch (Throwable throwable) {
                TestDistCpUtils.delete(fs, (String)"/tmp1");
                conf.set("distcp.delete.missing.source", "false");
                throw throwable;
            }
            TestDistCpUtils.delete((FileSystem)fs, (String)"/tmp1");
            conf.set("distcp.delete.missing.source", "false");
        }
        TestDistCpUtils.delete((FileSystem)fs, (String)"/tmp1");
        conf.set("distcp.delete.missing.source", "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAtomicCommitMissingFinal() {
        TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(config);
        JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
        Configuration conf = jobContext.getConfiguration();
        String workPath = "/tmp1/" + String.valueOf(rand.nextLong());
        String finalPath = "/tmp1/" + String.valueOf(rand.nextLong());
        FileSystem fs = null;
        try {
            CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
            fs = FileSystem.get((Configuration)conf);
            fs.mkdirs(new Path(workPath));
            conf.set("distcp.target.work.path", workPath);
            conf.set("distcp.target.final.path", finalPath);
            conf.setBoolean("distcp.atomic.copy", true);
            Assert.assertTrue((boolean)fs.exists(new Path(workPath)));
            Assert.assertFalse((boolean)fs.exists(new Path(finalPath)));
            committer.commitJob((JobContext)jobContext);
            Assert.assertFalse((boolean)fs.exists(new Path(workPath)));
            Assert.assertTrue((boolean)fs.exists(new Path(finalPath)));
            committer.commitJob((JobContext)jobContext);
            Assert.assertFalse((boolean)fs.exists(new Path(workPath)));
            Assert.assertTrue((boolean)fs.exists(new Path(finalPath)));
        }
        catch (IOException e) {
            try {
                LOG.error((Object)"Exception encountered while testing for preserve status", (Throwable)e);
                Assert.fail((String)"Atomic commit failure");
            }
            catch (Throwable throwable) {
                TestDistCpUtils.delete(fs, (String)workPath);
                TestDistCpUtils.delete(fs, (String)finalPath);
                conf.setBoolean("distcp.atomic.copy", false);
                throw throwable;
            }
            TestDistCpUtils.delete((FileSystem)fs, (String)workPath);
            TestDistCpUtils.delete((FileSystem)fs, (String)finalPath);
            conf.setBoolean("distcp.atomic.copy", false);
        }
        TestDistCpUtils.delete((FileSystem)fs, (String)workPath);
        TestDistCpUtils.delete((FileSystem)fs, (String)finalPath);
        conf.setBoolean("distcp.atomic.copy", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAtomicCommitExistingFinal() {
        TaskAttemptContext taskAttemptContext = this.getTaskAttemptContext(config);
        JobContextImpl jobContext = new JobContextImpl(taskAttemptContext.getConfiguration(), taskAttemptContext.getTaskAttemptID().getJobID());
        Configuration conf = jobContext.getConfiguration();
        String workPath = "/tmp1/" + String.valueOf(rand.nextLong());
        String finalPath = "/tmp1/" + String.valueOf(rand.nextLong());
        FileSystem fs = null;
        try {
            CopyCommitter committer = new CopyCommitter(null, taskAttemptContext);
            fs = FileSystem.get((Configuration)conf);
            fs.mkdirs(new Path(workPath));
            fs.mkdirs(new Path(finalPath));
            conf.set("distcp.target.work.path", workPath);
            conf.set("distcp.target.final.path", finalPath);
            conf.setBoolean("distcp.atomic.copy", true);
            Assert.assertTrue((boolean)fs.exists(new Path(workPath)));
            Assert.assertTrue((boolean)fs.exists(new Path(finalPath)));
            try {
                committer.commitJob((JobContext)jobContext);
                Assert.fail((String)"Should not be able to atomic-commit to pre-existing path.");
            }
            catch (Exception exception) {
                Assert.assertTrue((boolean)fs.exists(new Path(workPath)));
                Assert.assertTrue((boolean)fs.exists(new Path(finalPath)));
                LOG.info((Object)"Atomic-commit Test pass.");
            }
        }
        catch (IOException e) {
            try {
                LOG.error((Object)"Exception encountered while testing for atomic commit.", (Throwable)e);
                Assert.fail((String)"Atomic commit failure");
            }
            catch (Throwable throwable) {
                TestDistCpUtils.delete(fs, (String)workPath);
                TestDistCpUtils.delete(fs, (String)finalPath);
                conf.setBoolean("distcp.atomic.copy", false);
                throw throwable;
            }
            TestDistCpUtils.delete((FileSystem)fs, (String)workPath);
            TestDistCpUtils.delete((FileSystem)fs, (String)finalPath);
            conf.setBoolean("distcp.atomic.copy", false);
        }
        TestDistCpUtils.delete((FileSystem)fs, (String)workPath);
        TestDistCpUtils.delete((FileSystem)fs, (String)finalPath);
        conf.setBoolean("distcp.atomic.copy", false);
    }

    private TaskAttemptContext getTaskAttemptContext(Configuration conf) {
        return new TaskAttemptContextImpl(conf, new TaskAttemptID("200707121733", 1, TaskType.MAP, 1, 1));
    }

    private boolean checkDirectoryPermissions(FileSystem fs, String targetBase, FsPermission sourcePerm) throws IOException {
        Path base = new Path(targetBase);
        Stack<Path> stack = new Stack<Path>();
        stack.push(base);
        while (!stack.isEmpty()) {
            FileStatus[] fStatus;
            Path file = (Path)stack.pop();
            if (!fs.exists(file) || (fStatus = fs.listStatus(file)) == null || fStatus.length == 0) continue;
            for (FileStatus status : fStatus) {
                if (!status.isDirectory()) continue;
                stack.push(status.getPath());
                Assert.assertEquals((Object)status.getPermission(), (Object)sourcePerm);
            }
        }
        return true;
    }
}

