/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.CopyListing;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.util.DistCpUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class SimpleCopyListing
extends CopyListing {
    private static final Log LOG = LogFactory.getLog(SimpleCopyListing.class);
    private long totalPaths = 0L;
    private long totalBytesToCopy = 0L;
    private static final ByteArrayOutputStream buffer = new ByteArrayOutputStream(64);
    private DataInputBuffer in = new DataInputBuffer();

    protected SimpleCopyListing(Configuration configuration, Credentials credentials) {
        super(configuration, credentials);
    }

    protected void validatePaths(DistCpOptions options) throws IOException, CopyListing.InvalidInputException {
        Path targetPath = options.getTargetPath();
        FileSystem targetFS = targetPath.getFileSystem(this.getConf());
        boolean targetIsFile = targetFS.isFile(targetPath);
        if (targetIsFile) {
            if (options.getSourcePaths().size() > 1) {
                throw new CopyListing.InvalidInputException("Multiple source being copied to a file: " + targetPath);
            }
            Path srcPath = (Path)options.getSourcePaths().get(0);
            FileSystem sourceFS = srcPath.getFileSystem(this.getConf());
            if (!sourceFS.isFile(srcPath)) {
                throw new CopyListing.InvalidInputException("Cannot copy " + srcPath + ", which is not a file to " + targetPath);
            }
        }
        if (options.shouldAtomicCommit() && targetFS.exists(targetPath)) {
            throw new CopyListing.InvalidInputException("Target path for atomic-commit already exists: " + targetPath + ". Cannot atomic-commit to pre-existing target-path.");
        }
        for (Path path : options.getSourcePaths()) {
            FileSystem fs = path.getFileSystem(this.getConf());
            if (fs.exists(path)) continue;
            throw new CopyListing.InvalidInputException(path + " doesn't exist");
        }
        Credentials credentials = this.getCredentials();
        if (credentials != null) {
            Path[] inputPaths = options.getSourcePaths().toArray(new Path[1]);
            TokenCache.obtainTokensForNamenodes((Credentials)credentials, (Path[])inputPaths, (Configuration)this.getConf());
        }
    }

    public void doBuildListing(Path pathToListingFile, DistCpOptions options) throws IOException {
        this.doBuildListing(this.getWriter(pathToListingFile), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void doBuildListing(SequenceFile.Writer fileListWriter, DistCpOptions options) throws IOException {
        try {
            for (Path path : options.getSourcePaths()) {
                FileSystem sourceFS = path.getFileSystem(this.getConf());
                path = this.makeQualified(path);
                FileStatus rootStatus = sourceFS.getFileStatus(path);
                Path sourcePathRoot = this.computeSourceRootPath(rootStatus, options);
                boolean localFile = rootStatus.getClass() != FileStatus.class;
                FileStatus[] sourceFiles = sourceFS.listStatus(path);
                if (sourceFiles != null && sourceFiles.length > 0) {
                    for (FileStatus sourceStatus : sourceFiles) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Recording source-path: " + sourceStatus.getPath() + " for copy."));
                        }
                        this.writeToFileListing(fileListWriter, sourceStatus, sourcePathRoot, localFile);
                        if (!SimpleCopyListing.isDirectoryAndNotEmpty((FileSystem)sourceFS, (FileStatus)sourceStatus)) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Traversing non-empty source dir: " + sourceStatus.getPath()));
                        }
                        this.traverseNonEmptyDirectory(fileListWriter, sourceStatus, sourcePathRoot, localFile);
                    }
                    continue;
                }
                this.writeToFileListing(fileListWriter, rootStatus, sourcePathRoot, localFile);
            }
            fileListWriter.close();
            fileListWriter = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fileListWriter});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fileListWriter});
    }

    private Path computeSourceRootPath(FileStatus sourceStatus, DistCpOptions options) throws IOException {
        boolean solitaryFile;
        Path target = options.getTargetPath();
        FileSystem targetFS = target.getFileSystem(this.getConf());
        boolean bl = solitaryFile = options.getSourcePaths().size() == 1 && !sourceStatus.isDirectory();
        if (solitaryFile) {
            if (targetFS.isFile(target) || !targetFS.exists(target)) {
                return sourceStatus.getPath();
            }
            return sourceStatus.getPath().getParent();
        }
        boolean specialHandling = options.getSourcePaths().size() == 1 && !targetFS.exists(target) || options.shouldSyncFolder() || options.shouldOverwrite();
        return specialHandling && sourceStatus.isDirectory() ? sourceStatus.getPath() : sourceStatus.getPath().getParent();
    }

    protected long getBytesToCopy() {
        return this.totalBytesToCopy;
    }

    protected long getNumberOfPaths() {
        return this.totalPaths;
    }

    private Path makeQualified(Path path) throws IOException {
        FileSystem fs = path.getFileSystem(this.getConf());
        return path.makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    private SequenceFile.Writer getWriter(Path pathToListFile) throws IOException {
        FileSystem fs = pathToListFile.getFileSystem(this.getConf());
        if (fs.exists(pathToListFile)) {
            fs.delete(pathToListFile, false);
        }
        return SequenceFile.createWriter((Configuration)this.getConf(), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)pathToListFile), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(FileStatus.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE)});
    }

    private static boolean isDirectoryAndNotEmpty(FileSystem fileSystem, FileStatus fileStatus) throws IOException {
        return fileStatus.isDirectory() && SimpleCopyListing.getChildren((FileSystem)fileSystem, (FileStatus)fileStatus).length > 0;
    }

    private static FileStatus[] getChildren(FileSystem fileSystem, FileStatus parent) throws IOException {
        return fileSystem.listStatus(parent.getPath());
    }

    private void traverseNonEmptyDirectory(SequenceFile.Writer fileListWriter, FileStatus sourceStatus, Path sourcePathRoot, boolean localFile) throws IOException {
        FileSystem sourceFS = sourcePathRoot.getFileSystem(this.getConf());
        Stack<FileStatus> pathStack = new Stack<FileStatus>();
        pathStack.push(sourceStatus);
        while (!pathStack.isEmpty()) {
            for (FileStatus child : SimpleCopyListing.getChildren((FileSystem)sourceFS, (FileStatus)((FileStatus)pathStack.pop()))) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Recording source-path: " + sourceStatus.getPath() + " for copy."));
                }
                this.writeToFileListing(fileListWriter, child, sourcePathRoot, localFile);
                if (!SimpleCopyListing.isDirectoryAndNotEmpty((FileSystem)sourceFS, (FileStatus)child)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Traversing non-empty source dir: " + sourceStatus.getPath()));
                }
                pathStack.push(child);
            }
        }
    }

    private void writeToFileListing(SequenceFile.Writer fileListWriter, FileStatus fileStatus, Path sourcePathRoot, boolean localFile) throws IOException {
        if (fileStatus.getPath().equals((Object)sourcePathRoot) && fileStatus.isDirectory()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("REL PATH: " + DistCpUtils.getRelativePath((Path)sourcePathRoot, (Path)fileStatus.getPath()) + ", FULL PATH: " + fileStatus.getPath()));
        }
        FileStatus status = fileStatus;
        if (localFile) {
            status = this.getFileStatus(fileStatus);
        }
        fileListWriter.append((Writable)new Text(DistCpUtils.getRelativePath((Path)sourcePathRoot, (Path)fileStatus.getPath())), (Writable)status);
        fileListWriter.sync();
        if (!fileStatus.isDirectory()) {
            this.totalBytesToCopy += fileStatus.getLen();
        }
        ++this.totalPaths;
    }

    private FileStatus getFileStatus(FileStatus fileStatus) throws IOException {
        FileStatus status = new FileStatus();
        buffer.reset();
        DataOutputStream out = new DataOutputStream(buffer);
        fileStatus.write((DataOutput)out);
        this.in.reset(buffer.toByteArray(), 0, buffer.size());
        status.readFields((DataInput)this.in);
        return status;
    }
}

