/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.FileBasedCopyListing;
import org.apache.hadoop.tools.GlobbedCopyListing;
import org.apache.hadoop.tools.util.DistCpUtils;

public abstract class CopyListing
extends Configured {
    private Credentials credentials;

    public final void buildListing(Path pathToListFile, DistCpOptions options) throws IOException {
        this.validatePaths(options);
        this.doBuildListing(pathToListFile, options);
        Configuration config = this.getConf();
        config.set("distcp.listing.file.path", pathToListFile.toString());
        config.setLong("mapred.total.bytes.expected", this.getBytesToCopy());
        config.setLong("mapred.number.of.records", this.getNumberOfPaths());
        this.checkForDuplicates(pathToListFile);
    }

    protected abstract void validatePaths(DistCpOptions var1) throws IOException, InvalidInputException;

    protected abstract void doBuildListing(Path var1, DistCpOptions var2) throws IOException;

    protected abstract long getBytesToCopy();

    protected abstract long getNumberOfPaths();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForDuplicates(Path pathToListFile) throws DuplicateFileException, IOException {
        Configuration config = this.getConf();
        FileSystem fs = pathToListFile.getFileSystem(config);
        Path sortedList = DistCpUtils.sortListing(fs, config, pathToListFile);
        SequenceFile.Reader reader = new SequenceFile.Reader(config, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)sortedList)});
        try {
            Text lastKey = new Text("*");
            FileStatus lastFileStatus = new FileStatus();
            Text currentKey = new Text();
            while (reader.next((Writable)currentKey)) {
                if (currentKey.equals((Object)lastKey)) {
                    FileStatus currentFileStatus = new FileStatus();
                    reader.getCurrentValue((Writable)currentFileStatus);
                    throw new DuplicateFileException("File " + lastFileStatus.getPath() + " and " + currentFileStatus.getPath() + " would cause duplicates. Aborting");
                }
                reader.getCurrentValue((Writable)lastFileStatus);
                lastKey.set(currentKey);
            }
        }
        finally {
            IOUtils.closeStream((Closeable)reader);
        }
    }

    protected CopyListing(Configuration configuration, Credentials credentials) {
        this.setConf(configuration);
        this.setCredentials(credentials);
    }

    protected void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    protected Credentials getCredentials() {
        return this.credentials;
    }

    public static CopyListing getCopyListing(Configuration configuration, Credentials credentials, DistCpOptions options) {
        if (options.getSourceFileListing() == null) {
            return new GlobbedCopyListing(configuration, credentials);
        }
        return new FileBasedCopyListing(configuration, credentials);
    }

    static class InvalidInputException
    extends RuntimeException {
        public InvalidInputException(String message) {
            super(message);
        }
    }

    static class DuplicateFileException
    extends RuntimeException {
        public DuplicateFileException(String message) {
            super(message);
        }
    }
}

