/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools;

import java.io.Closeable;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.GlobbedCopyListing;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestGlobbedCopyListing {
    private static MiniDFSCluster cluster;
    private static final Credentials CREDENTIALS;
    public static Map<String, String> expectedValues;

    @BeforeClass
    public static void setup() throws Exception {
        cluster = new MiniDFSCluster.Builder(new Configuration()).numDataNodes(1).format(true).build();
        TestGlobbedCopyListing.createSourceData();
    }

    private static void createSourceData() throws Exception {
        TestGlobbedCopyListing.mkdirs((String)"/tmp/source/1");
        TestGlobbedCopyListing.mkdirs((String)"/tmp/source/2");
        TestGlobbedCopyListing.mkdirs((String)"/tmp/source/2/3");
        TestGlobbedCopyListing.mkdirs((String)"/tmp/source/2/3/4");
        TestGlobbedCopyListing.mkdirs((String)"/tmp/source/5");
        TestGlobbedCopyListing.touchFile((String)"/tmp/source/5/6");
        TestGlobbedCopyListing.mkdirs((String)"/tmp/source/7");
        TestGlobbedCopyListing.mkdirs((String)"/tmp/source/7/8");
        TestGlobbedCopyListing.touchFile((String)"/tmp/source/7/8/9");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mkdirs(String path) throws Exception {
        FileSystem fileSystem = null;
        try {
            fileSystem = cluster.getFileSystem();
            fileSystem.mkdirs(new Path(path));
            TestGlobbedCopyListing.recordInExpectedValues((String)path);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{fileSystem});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fileSystem});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void touchFile(String path) throws Exception {
        FileSystem fileSystem = null;
        FSDataOutputStream outputStream = null;
        try {
            fileSystem = cluster.getFileSystem();
            outputStream = fileSystem.create(new Path(path), true, 0);
            TestGlobbedCopyListing.recordInExpectedValues((String)path);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{fileSystem, outputStream});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{fileSystem, outputStream});
    }

    private static void recordInExpectedValues(String path) throws Exception {
        FileSystem fileSystem = cluster.getFileSystem();
        Path sourcePath = new Path(fileSystem.getUri().toString() + path);
        expectedValues.put(sourcePath.toString(), DistCpUtils.getRelativePath((Path)new Path("/tmp/source"), (Path)sourcePath));
    }

    @AfterClass
    public static void tearDown() {
        cluster.shutdown();
    }

    @Test
    public void testRun() throws Exception {
        URI uri = cluster.getFileSystem().getUri();
        String pathString = uri.toString();
        Path fileSystemPath = new Path(pathString);
        Path source = new Path(fileSystemPath.toString() + "/tmp/source");
        Path target = new Path(fileSystemPath.toString() + "/tmp/target");
        Path listingPath = new Path(fileSystemPath.toString() + "/tmp/META/fileList.seq");
        DistCpOptions options = new DistCpOptions(Arrays.asList(source), target);
        new GlobbedCopyListing(new Configuration(), CREDENTIALS).buildListing(listingPath, options);
        this.verifyContents(listingPath);
    }

    private void verifyContents(Path listingPath) throws Exception {
        SequenceFile.Reader reader = new SequenceFile.Reader(cluster.getFileSystem(), listingPath, new Configuration());
        Text key = new Text();
        FileStatus value = new FileStatus();
        HashMap<String, String> actualValues = new HashMap<String, String>();
        while (reader.next((Writable)key, (Writable)value)) {
            actualValues.put(value.getPath().toString(), key.toString());
        }
        Assert.assertEquals((long)expectedValues.size(), (long)actualValues.size());
        for (Map.Entry entry : actualValues.entrySet()) {
            Assert.assertEquals(entry.getValue(), expectedValues.get(entry.getKey()));
        }
    }

    static {
        CREDENTIALS = new Credentials();
        expectedValues = new HashMap();
    }
}

