/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.applications.distributedshell;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.applications.distributedshell.Log4jPropertyHelper;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.NMClientAsyncImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.log4j.LogManager;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ApplicationMaster {
    private static final Log LOG = LogFactory.getLog(ApplicationMaster.class);
    private Configuration conf;
    private AMRMClientAsync amRMClient;
    @VisibleForTesting
    UserGroupInformation appSubmitterUgi;
    private NMClientAsync nmClientAsync;
    private NMCallbackHandler containerListener;
    @VisibleForTesting
    protected ApplicationAttemptId appAttemptID;
    private String appMasterHostname = "";
    private int appMasterRpcPort = -1;
    private String appMasterTrackingUrl = "";
    @VisibleForTesting
    protected int numTotalContainers = 1;
    private int containerMemory = 10;
    private int containerVirtualCores = 1;
    private int requestPriority;
    private AtomicInteger numCompletedContainers = new AtomicInteger();
    @VisibleForTesting
    protected AtomicInteger numAllocatedContainers = new AtomicInteger();
    private AtomicInteger numFailedContainers = new AtomicInteger();
    @VisibleForTesting
    protected AtomicInteger numRequestedContainers = new AtomicInteger();
    private String shellCommand = "";
    private String shellArgs = "";
    private Map<String, String> shellEnv = new HashMap<String, String>();
    private String scriptPath = "";
    private long shellScriptPathTimestamp = 0L;
    private long shellScriptPathLen = 0L;
    private String domainId = null;
    private static final String ExecShellStringPath = "ExecScript.sh";
    private static final String ExecBatScripStringtPath = "ExecScript.bat";
    private static final String log4jPath = "log4j.properties";
    private static final String shellCommandPath = "shellCommands";
    private static final String shellArgsPath = "shellArgs";
    private volatile boolean done;
    private ByteBuffer allTokens;
    private List<Thread> launchThreads = new ArrayList<Thread>();
    @VisibleForTesting
    TimelineClient timelineClient;
    private final String linux_bash_command = "bash";
    private final String windows_command = "cmd /c";

    public static void main(String[] args) {
        boolean result = false;
        try {
            ApplicationMaster appMaster = new ApplicationMaster();
            LOG.info((Object)"Initializing ApplicationMaster");
            boolean doRun = appMaster.init(args);
            if (!doRun) {
                System.exit(0);
            }
            appMaster.run();
            result = appMaster.finish();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error running ApplicationMaster", t);
            LogManager.shutdown();
            ExitUtil.terminate((int)1, (Throwable)t);
        }
        if (result) {
            LOG.info((Object)"Application Master completed successfully. exiting");
            System.exit(0);
        } else {
            LOG.info((Object)"Application Master failed. exiting");
            System.exit(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpOutDebugInfo() {
        LOG.info((Object)"Dump debug output");
        Map<String, String> envs = System.getenv();
        for (Map.Entry<String, String> env : envs.entrySet()) {
            LOG.info((Object)("System env: key=" + env.getKey() + ", val=" + env.getValue()));
            System.out.println("System env: key=" + env.getKey() + ", val=" + env.getValue());
        }
        BufferedReader buf = null;
        try {
            String lines = Shell.WINDOWS ? Shell.execCommand((String[])new String[]{"cmd", "/c", "dir"}) : Shell.execCommand((String[])new String[]{"ls", "-al"});
            buf = new BufferedReader(new StringReader(lines));
            String line = "";
            while ((line = buf.readLine()) != null) {
                LOG.info((Object)("System CWD content: " + line));
                System.out.println("System CWD content: " + line);
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                org.apache.hadoop.io.IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{buf});
                throw throwable;
            }
            org.apache.hadoop.io.IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{buf});
        }
        org.apache.hadoop.io.IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{buf});
    }

    public ApplicationMaster() {
        this.conf = new YarnConfiguration();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean init(String[] args) throws ParseException, IOException {
        Map<String, String> envs;
        Options opts = new Options();
        opts.addOption("app_attempt_id", true, "App Attempt ID. Not to be used unless for testing purposes");
        opts.addOption("shell_env", true, "Environment for shell script. Specified as env_key=env_val pairs");
        opts.addOption("container_memory", true, "Amount of memory in MB to be requested to run the shell command");
        opts.addOption("container_vcores", true, "Amount of virtual cores to be requested to run the shell command");
        opts.addOption("num_containers", true, "No. of containers on which the shell command needs to be executed");
        opts.addOption("priority", true, "Application Priority. Default 0");
        opts.addOption("debug", false, "Dump out debug information");
        opts.addOption("help", false, "Print usage");
        CommandLine cliParser = new GnuParser().parse(opts, args);
        if (args.length == 0) {
            this.printUsage(opts);
            throw new IllegalArgumentException("No args specified for application master to initialize");
        }
        if (this.fileExist(log4jPath)) {
            try {
                Log4jPropertyHelper.updateLog4jConfiguration(ApplicationMaster.class, log4jPath);
            }
            catch (Exception e) {
                LOG.warn((Object)("Can not set up custom log4j properties. " + e));
            }
        }
        if (cliParser.hasOption("help")) {
            this.printUsage(opts);
            return false;
        }
        if (cliParser.hasOption("debug")) {
            this.dumpOutDebugInfo();
        }
        if (!(envs = System.getenv()).containsKey(ApplicationConstants.Environment.CONTAINER_ID.name())) {
            if (!cliParser.hasOption("app_attempt_id")) throw new IllegalArgumentException("Application Attempt Id not set in the environment");
            String appIdStr = cliParser.getOptionValue("app_attempt_id", "");
            this.appAttemptID = ConverterUtils.toApplicationAttemptId((String)appIdStr);
        } else {
            ContainerId containerId = ConverterUtils.toContainerId((String)envs.get(ApplicationConstants.Environment.CONTAINER_ID.name()));
            this.appAttemptID = containerId.getApplicationAttemptId();
        }
        if (!envs.containsKey("APP_SUBMIT_TIME_ENV")) {
            throw new RuntimeException("APP_SUBMIT_TIME_ENV not set in the environment");
        }
        if (!envs.containsKey(ApplicationConstants.Environment.NM_HOST.name())) {
            throw new RuntimeException(ApplicationConstants.Environment.NM_HOST.name() + " not set in the environment");
        }
        if (!envs.containsKey(ApplicationConstants.Environment.NM_HTTP_PORT.name())) {
            throw new RuntimeException(ApplicationConstants.Environment.NM_HTTP_PORT + " not set in the environment");
        }
        if (!envs.containsKey(ApplicationConstants.Environment.NM_PORT.name())) {
            throw new RuntimeException(ApplicationConstants.Environment.NM_PORT.name() + " not set in the environment");
        }
        LOG.info((Object)("Application master for app, appId=" + this.appAttemptID.getApplicationId().getId() + ", clustertimestamp=" + this.appAttemptID.getApplicationId().getClusterTimestamp() + ", attemptId=" + this.appAttemptID.getAttemptId()));
        if (!this.fileExist(shellCommandPath) && envs.get("DISTRIBUTEDSHELLSCRIPTLOCATION").isEmpty()) {
            throw new IllegalArgumentException("No shell command or shell script specified to be executed by application master");
        }
        if (this.fileExist(shellCommandPath)) {
            this.shellCommand = this.readContent(shellCommandPath);
        }
        if (this.fileExist(shellArgsPath)) {
            this.shellArgs = this.readContent(shellArgsPath);
        }
        if (cliParser.hasOption("shell_env")) {
            String[] shellEnvs;
            for (String env : shellEnvs = cliParser.getOptionValues("shell_env")) {
                int index = (env = env.trim()).indexOf(61);
                if (index == -1) {
                    this.shellEnv.put(env, "");
                    continue;
                }
                String key = env.substring(0, index);
                String val = "";
                if (index < env.length() - 1) {
                    val = env.substring(index + 1);
                }
                this.shellEnv.put(key, val);
            }
        }
        if (envs.containsKey("DISTRIBUTEDSHELLSCRIPTLOCATION")) {
            this.scriptPath = envs.get("DISTRIBUTEDSHELLSCRIPTLOCATION");
            if (envs.containsKey("DISTRIBUTEDSHELLSCRIPTTIMESTAMP")) {
                this.shellScriptPathTimestamp = Long.parseLong(envs.get("DISTRIBUTEDSHELLSCRIPTTIMESTAMP"));
            }
            if (envs.containsKey("DISTRIBUTEDSHELLSCRIPTLEN")) {
                this.shellScriptPathLen = Long.parseLong(envs.get("DISTRIBUTEDSHELLSCRIPTLEN"));
            }
            if (!(this.scriptPath.isEmpty() || this.shellScriptPathTimestamp > 0L && this.shellScriptPathLen > 0L)) {
                LOG.error((Object)("Illegal values in env for shell script path, path=" + this.scriptPath + ", len=" + this.shellScriptPathLen + ", timestamp=" + this.shellScriptPathTimestamp));
                throw new IllegalArgumentException("Illegal values in env for shell script path");
            }
        }
        if (envs.containsKey("DISTRIBUTEDSHELLTIMELINEDOMAIN")) {
            this.domainId = envs.get("DISTRIBUTEDSHELLTIMELINEDOMAIN");
        }
        this.containerMemory = Integer.parseInt(cliParser.getOptionValue("container_memory", "10"));
        this.containerVirtualCores = Integer.parseInt(cliParser.getOptionValue("container_vcores", "1"));
        this.numTotalContainers = Integer.parseInt(cliParser.getOptionValue("num_containers", "1"));
        if (this.numTotalContainers == 0) {
            throw new IllegalArgumentException("Cannot run distributed shell with no containers");
        }
        this.requestPriority = Integer.parseInt(cliParser.getOptionValue("priority", "0"));
        return true;
    }

    private void printUsage(Options opts) {
        new HelpFormatter().printHelp("ApplicationMaster", opts);
    }

    public void run() throws YarnException, IOException, InterruptedException {
        LOG.info((Object)"Starting ApplicationMaster");
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        Iterator iter = credentials.getAllTokens().iterator();
        LOG.info((Object)"Executing with tokens:");
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            LOG.info((Object)token);
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            iter.remove();
        }
        this.allTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        String appSubmitterUserName = System.getenv(ApplicationConstants.Environment.USER.name());
        this.appSubmitterUgi = UserGroupInformation.createRemoteUser((String)appSubmitterUserName);
        this.appSubmitterUgi.addCredentials(credentials);
        RMCallbackHandler allocListener = new RMCallbackHandler();
        this.amRMClient = AMRMClientAsync.createAMRMClientAsync((int)1000, (AMRMClientAsync.CallbackHandler)allocListener);
        this.amRMClient.init(this.conf);
        this.amRMClient.start();
        this.containerListener = this.createNMCallbackHandler();
        this.nmClientAsync = new NMClientAsyncImpl((NMClientAsync.CallbackHandler)this.containerListener);
        this.nmClientAsync.init(this.conf);
        this.nmClientAsync.start();
        this.startTimelineClient(this.conf);
        if (this.timelineClient != null) {
            ApplicationMaster.publishApplicationAttemptEvent(this.timelineClient, this.appAttemptID.toString(), DSEvent.DS_APP_ATTEMPT_START, this.domainId, this.appSubmitterUgi);
        }
        this.appMasterHostname = NetUtils.getHostname();
        RegisterApplicationMasterResponse response = this.amRMClient.registerApplicationMaster(this.appMasterHostname, this.appMasterRpcPort, this.appMasterTrackingUrl);
        int maxMem = response.getMaximumResourceCapability().getMemory();
        LOG.info((Object)("Max mem capabililty of resources in this cluster " + maxMem));
        int maxVCores = response.getMaximumResourceCapability().getVirtualCores();
        LOG.info((Object)("Max vcores capabililty of resources in this cluster " + maxVCores));
        if (this.containerMemory > maxMem) {
            LOG.info((Object)("Container memory specified above max threshold of cluster. Using max value., specified=" + this.containerMemory + ", max=" + maxMem));
            this.containerMemory = maxMem;
        }
        if (this.containerVirtualCores > maxVCores) {
            LOG.info((Object)("Container virtual cores specified above max threshold of cluster. Using max value., specified=" + this.containerVirtualCores + ", max=" + maxVCores));
            this.containerVirtualCores = maxVCores;
        }
        List previousAMRunningContainers = response.getContainersFromPreviousAttempts();
        LOG.info((Object)(this.appAttemptID + " received " + previousAMRunningContainers.size() + " previous attempts' running containers on AM registration."));
        this.numAllocatedContainers.addAndGet(previousAMRunningContainers.size());
        int numTotalContainersToRequest = this.numTotalContainers - previousAMRunningContainers.size();
        for (int i = 0; i < numTotalContainersToRequest; ++i) {
            AMRMClient.ContainerRequest containerAsk = this.setupContainerAskForRM();
            this.amRMClient.addContainerRequest(containerAsk);
        }
        this.numRequestedContainers.set(this.numTotalContainers);
    }

    @VisibleForTesting
    void startTimelineClient(final Configuration conf) throws YarnException, IOException, InterruptedException {
        try {
            this.appSubmitterUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    if (conf.getBoolean("yarn.timeline-service.enabled", false)) {
                        ApplicationMaster.this.timelineClient = TimelineClient.createTimelineClient();
                        ApplicationMaster.this.timelineClient.init(conf);
                        ApplicationMaster.this.timelineClient.start();
                    } else {
                        ApplicationMaster.this.timelineClient = null;
                        LOG.warn((Object)"Timeline service is not enabled");
                    }
                    return null;
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            throw new YarnException(e.getCause());
        }
    }

    @VisibleForTesting
    NMCallbackHandler createNMCallbackHandler() {
        return new NMCallbackHandler(this);
    }

    @VisibleForTesting
    protected boolean finish() {
        FinalApplicationStatus appStatus;
        while (!this.done && this.numCompletedContainers.get() != this.numTotalContainers) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {}
        }
        if (this.timelineClient != null) {
            ApplicationMaster.publishApplicationAttemptEvent(this.timelineClient, this.appAttemptID.toString(), DSEvent.DS_APP_ATTEMPT_END, this.domainId, this.appSubmitterUgi);
        }
        for (Thread launchThread : this.launchThreads) {
            try {
                launchThread.join(10000L);
            }
            catch (InterruptedException e) {
                LOG.info((Object)("Exception thrown in thread join: " + e.getMessage()));
                e.printStackTrace();
            }
        }
        LOG.info((Object)"Application completed. Stopping running containers");
        this.nmClientAsync.stop();
        LOG.info((Object)"Application completed. Signalling finish to RM");
        String appMessage = null;
        boolean success = true;
        if (this.numFailedContainers.get() == 0 && this.numCompletedContainers.get() == this.numTotalContainers) {
            appStatus = FinalApplicationStatus.SUCCEEDED;
        } else {
            appStatus = FinalApplicationStatus.FAILED;
            appMessage = "Diagnostics., total=" + this.numTotalContainers + ", completed=" + this.numCompletedContainers.get() + ", allocated=" + this.numAllocatedContainers.get() + ", failed=" + this.numFailedContainers.get();
            LOG.info((Object)appMessage);
            success = false;
        }
        try {
            this.amRMClient.unregisterApplicationMaster(appStatus, appMessage, null);
        }
        catch (YarnException ex) {
            LOG.error((Object)"Failed to unregister application", (Throwable)ex);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to unregister application", (Throwable)e);
        }
        this.amRMClient.stop();
        if (this.timelineClient != null) {
            this.timelineClient.stop();
        }
        return success;
    }

    private void renameScriptFile(final Path renamedScriptPath) throws IOException, InterruptedException {
        this.appSubmitterUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                FileSystem fs = renamedScriptPath.getFileSystem(ApplicationMaster.this.conf);
                fs.rename(new Path(ApplicationMaster.this.scriptPath), renamedScriptPath);
                return null;
            }
        });
        LOG.info((Object)("User " + this.appSubmitterUgi.getUserName() + " added suffix(.sh/.bat) to script file as " + renamedScriptPath));
    }

    private AMRMClient.ContainerRequest setupContainerAskForRM() {
        Priority pri = Priority.newInstance((int)this.requestPriority);
        Resource capability = Resource.newInstance((int)this.containerMemory, (int)this.containerVirtualCores);
        AMRMClient.ContainerRequest request = new AMRMClient.ContainerRequest(capability, null, null, pri);
        LOG.info((Object)("Requested container ask: " + request.toString()));
        return request;
    }

    private boolean fileExist(String filePath) {
        return new File(filePath).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContent(String filePath) throws IOException {
        String string;
        DataInputStream ds = null;
        try {
            ds = new DataInputStream(new FileInputStream(filePath));
            string = ds.readUTF();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(ds);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)ds);
        return string;
    }

    private static void publishContainerStartEvent(final TimelineClient timelineClient, Container container, String domainId, UserGroupInformation ugi) {
        final TimelineEntity entity = new TimelineEntity();
        entity.setEntityId(container.getId().toString());
        entity.setEntityType(DSEntity.DS_CONTAINER.toString());
        entity.setDomainId(domainId);
        entity.addPrimaryFilter("user", (Object)ugi.getShortUserName());
        TimelineEvent event = new TimelineEvent();
        event.setTimestamp(System.currentTimeMillis());
        event.setEventType(DSEvent.DS_CONTAINER_START.toString());
        event.addEventInfo("Node", (Object)container.getNodeId().toString());
        event.addEventInfo("Resources", (Object)container.getResource().toString());
        entity.addEvent(event);
        try {
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TimelinePutResponse>(){

                @Override
                public TimelinePutResponse run() throws Exception {
                    return timelineClient.putEntities(new TimelineEntity[]{entity});
                }
            });
        }
        catch (Exception e) {
            LOG.error((Object)("Container start event could not be published for " + container.getId().toString()), e instanceof UndeclaredThrowableException ? e.getCause() : e);
        }
    }

    private static void publishContainerEndEvent(TimelineClient timelineClient, ContainerStatus container, String domainId, UserGroupInformation ugi) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId(container.getContainerId().toString());
        entity.setEntityType(DSEntity.DS_CONTAINER.toString());
        entity.setDomainId(domainId);
        entity.addPrimaryFilter("user", (Object)ugi.getShortUserName());
        TimelineEvent event = new TimelineEvent();
        event.setTimestamp(System.currentTimeMillis());
        event.setEventType(DSEvent.DS_CONTAINER_END.toString());
        event.addEventInfo("State", (Object)container.getState().name());
        event.addEventInfo("Exit Status", (Object)container.getExitStatus());
        entity.addEvent(event);
        try {
            timelineClient.putEntities(new TimelineEntity[]{entity});
        }
        catch (IOException | YarnException e) {
            LOG.error((Object)("Container end event could not be published for " + container.getContainerId().toString()), e);
        }
    }

    private static void publishApplicationAttemptEvent(TimelineClient timelineClient, String appAttemptId, DSEvent appEvent, String domainId, UserGroupInformation ugi) {
        TimelineEntity entity = new TimelineEntity();
        entity.setEntityId(appAttemptId);
        entity.setEntityType(DSEntity.DS_APP_ATTEMPT.toString());
        entity.setDomainId(domainId);
        entity.addPrimaryFilter("user", (Object)ugi.getShortUserName());
        TimelineEvent event = new TimelineEvent();
        event.setEventType(appEvent.toString());
        event.setTimestamp(System.currentTimeMillis());
        entity.addEvent(event);
        try {
            timelineClient.putEntities(new TimelineEntity[]{entity});
        }
        catch (IOException | YarnException e) {
            LOG.error((Object)("App Attempt " + (appEvent.equals((Object)DSEvent.DS_APP_ATTEMPT_START) ? "start" : "end") + " event could not be published for " + appAttemptId.toString()), e);
        }
    }

    private class LaunchContainerRunnable
    implements Runnable {
        Container container;
        NMCallbackHandler containerListener;

        public LaunchContainerRunnable(Container lcontainer, NMCallbackHandler containerListener) {
            this.container = lcontainer;
            this.containerListener = containerListener;
        }

        @Override
        public void run() {
            LOG.info((Object)("Setting up container launch container for containerid=" + this.container.getId()));
            HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
            if (!ApplicationMaster.this.scriptPath.isEmpty()) {
                Path renamedScriptPath = null;
                renamedScriptPath = Shell.WINDOWS ? new Path(ApplicationMaster.this.scriptPath + ".bat") : new Path(ApplicationMaster.this.scriptPath + ".sh");
                try {
                    ApplicationMaster.this.renameScriptFile(renamedScriptPath);
                }
                catch (Exception e) {
                    LOG.error((Object)"Not able to add suffix (.bat/.sh) to the shell script filename", (Throwable)e);
                    ApplicationMaster.this.numCompletedContainers.incrementAndGet();
                    ApplicationMaster.this.numFailedContainers.incrementAndGet();
                    return;
                }
                URL yarnUrl = null;
                try {
                    yarnUrl = ConverterUtils.getYarnUrlFromURI((URI)new URI(renamedScriptPath.toString()));
                }
                catch (URISyntaxException e) {
                    LOG.error((Object)("Error when trying to use shell script path specified in env, path=" + renamedScriptPath), (Throwable)e);
                    ApplicationMaster.this.numCompletedContainers.incrementAndGet();
                    ApplicationMaster.this.numFailedContainers.incrementAndGet();
                    return;
                }
                LocalResource shellRsrc = LocalResource.newInstance((URL)yarnUrl, (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)ApplicationMaster.this.shellScriptPathLen, (long)ApplicationMaster.this.shellScriptPathTimestamp);
                localResources.put(Shell.WINDOWS ? ApplicationMaster.ExecBatScripStringtPath : ApplicationMaster.ExecShellStringPath, shellRsrc);
                ApplicationMaster.this.shellCommand = Shell.WINDOWS ? "cmd /c" : "bash";
            }
            Vector<String> vargs = new Vector<String>(5);
            vargs.add(ApplicationMaster.this.shellCommand);
            if (!ApplicationMaster.this.scriptPath.isEmpty()) {
                vargs.add(Shell.WINDOWS ? ApplicationMaster.ExecBatScripStringtPath : ApplicationMaster.ExecShellStringPath);
            }
            vargs.add(ApplicationMaster.this.shellArgs);
            vargs.add("1><LOG_DIR>/stdout");
            vargs.add("2><LOG_DIR>/stderr");
            StringBuilder command = new StringBuilder();
            for (CharSequence charSequence : vargs) {
                command.append(charSequence).append(" ");
            }
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(command.toString());
            ContainerLaunchContext containerLaunchContext = ContainerLaunchContext.newInstance(localResources, (Map)ApplicationMaster.this.shellEnv, commands, null, (ByteBuffer)ApplicationMaster.this.allTokens.duplicate(), null);
            this.containerListener.addContainer(this.container.getId(), this.container);
            ApplicationMaster.this.nmClientAsync.startContainerAsync(this.container, containerLaunchContext);
        }
    }

    @VisibleForTesting
    static class NMCallbackHandler
    implements NMClientAsync.CallbackHandler {
        private ConcurrentMap<ContainerId, Container> containers = new ConcurrentHashMap<ContainerId, Container>();
        private final ApplicationMaster applicationMaster;

        public NMCallbackHandler(ApplicationMaster applicationMaster) {
            this.applicationMaster = applicationMaster;
        }

        public void addContainer(ContainerId containerId, Container container) {
            this.containers.putIfAbsent(containerId, container);
        }

        public void onContainerStopped(ContainerId containerId) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Succeeded to stop Container " + containerId));
            }
            this.containers.remove(containerId);
        }

        public void onContainerStatusReceived(ContainerId containerId, ContainerStatus containerStatus) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Container Status: id=" + containerId + ", status=" + containerStatus));
            }
        }

        public void onContainerStarted(ContainerId containerId, Map<String, ByteBuffer> allServiceResponse) {
            Container container;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Succeeded to start Container " + containerId));
            }
            if ((container = (Container)this.containers.get(containerId)) != null) {
                this.applicationMaster.nmClientAsync.getContainerStatusAsync(containerId, container.getNodeId());
            }
            if (this.applicationMaster.timelineClient != null) {
                ApplicationMaster.publishContainerStartEvent(this.applicationMaster.timelineClient, container, this.applicationMaster.domainId, this.applicationMaster.appSubmitterUgi);
            }
        }

        public void onStartContainerError(ContainerId containerId, Throwable t) {
            LOG.error((Object)("Failed to start Container " + containerId));
            this.containers.remove(containerId);
            this.applicationMaster.numCompletedContainers.incrementAndGet();
            this.applicationMaster.numFailedContainers.incrementAndGet();
        }

        public void onGetContainerStatusError(ContainerId containerId, Throwable t) {
            LOG.error((Object)("Failed to query the status of Container " + containerId));
        }

        public void onStopContainerError(ContainerId containerId, Throwable t) {
            LOG.error((Object)("Failed to stop Container " + containerId));
            this.containers.remove(containerId);
        }
    }

    private class RMCallbackHandler
    implements AMRMClientAsync.CallbackHandler {
        private RMCallbackHandler() {
        }

        public void onContainersCompleted(List<ContainerStatus> completedContainers) {
            LOG.info((Object)("Got response from RM for container ask, completedCnt=" + completedContainers.size()));
            for (ContainerStatus containerStatus : completedContainers) {
                LOG.info((Object)(ApplicationMaster.this.appAttemptID + " got container status for containerID=" + containerStatus.getContainerId() + ", state=" + containerStatus.getState() + ", exitStatus=" + containerStatus.getExitStatus() + ", diagnostics=" + containerStatus.getDiagnostics()));
                assert (containerStatus.getState() == ContainerState.COMPLETE);
                int exitStatus = containerStatus.getExitStatus();
                if (0 != exitStatus) {
                    if (-100 != exitStatus) {
                        ApplicationMaster.this.numCompletedContainers.incrementAndGet();
                        ApplicationMaster.this.numFailedContainers.incrementAndGet();
                    } else {
                        ApplicationMaster.this.numAllocatedContainers.decrementAndGet();
                        ApplicationMaster.this.numRequestedContainers.decrementAndGet();
                    }
                } else {
                    ApplicationMaster.this.numCompletedContainers.incrementAndGet();
                    LOG.info((Object)("Container completed successfully., containerId=" + containerStatus.getContainerId()));
                }
                if (ApplicationMaster.this.timelineClient == null) continue;
                ApplicationMaster.publishContainerEndEvent(ApplicationMaster.this.timelineClient, containerStatus, ApplicationMaster.this.domainId, ApplicationMaster.this.appSubmitterUgi);
            }
            int askCount = ApplicationMaster.this.numTotalContainers - ApplicationMaster.this.numRequestedContainers.get();
            ApplicationMaster.this.numRequestedContainers.addAndGet(askCount);
            if (askCount > 0) {
                for (int i = 0; i < askCount; ++i) {
                    AMRMClient.ContainerRequest containerAsk = ApplicationMaster.this.setupContainerAskForRM();
                    ApplicationMaster.this.amRMClient.addContainerRequest(containerAsk);
                }
            }
            if (ApplicationMaster.this.numCompletedContainers.get() == ApplicationMaster.this.numTotalContainers) {
                ApplicationMaster.this.done = true;
            }
        }

        public void onContainersAllocated(List<Container> allocatedContainers) {
            LOG.info((Object)("Got response from RM for container ask, allocatedCnt=" + allocatedContainers.size()));
            ApplicationMaster.this.numAllocatedContainers.addAndGet(allocatedContainers.size());
            for (Container allocatedContainer : allocatedContainers) {
                LOG.info((Object)("Launching shell command on a new container., containerId=" + allocatedContainer.getId() + ", containerNode=" + allocatedContainer.getNodeId().getHost() + ":" + allocatedContainer.getNodeId().getPort() + ", containerNodeURI=" + allocatedContainer.getNodeHttpAddress() + ", containerResourceMemory" + allocatedContainer.getResource().getMemory() + ", containerResourceVirtualCores" + allocatedContainer.getResource().getVirtualCores()));
                LaunchContainerRunnable runnableLaunchContainer = new LaunchContainerRunnable(allocatedContainer, ApplicationMaster.this.containerListener);
                Thread launchThread = new Thread(runnableLaunchContainer);
                ApplicationMaster.this.launchThreads.add(launchThread);
                launchThread.start();
            }
        }

        public void onShutdownRequest() {
            ApplicationMaster.this.done = true;
        }

        public void onNodesUpdated(List<NodeReport> updatedNodes) {
        }

        public float getProgress() {
            float progress = (float)ApplicationMaster.this.numCompletedContainers.get() / (float)ApplicationMaster.this.numTotalContainers;
            return progress;
        }

        public void onError(Throwable e) {
            ApplicationMaster.this.done = true;
            ApplicationMaster.this.amRMClient.stop();
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static enum DSEntity {
        DS_APP_ATTEMPT,
        DS_CONTAINER;

    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static enum DSEvent {
        DS_APP_ATTEMPT_START,
        DS_APP_ATTEMPT_END,
        DS_CONTAINER_START,
        DS_CONTAINER_END;

    }
}

